      SUBROUTINE MN_SET(IDELIM)
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mnprs.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mntyq.inc"
#include "mngrn.inc"
#include "mnlun.inc"
C
      INTEGER MSET1,MSET2,MPOS,MINO,MLBL,MXYZ,MGRD,MSTA
      PARAMETER (MSET1= 90, MSET2= 19)
      PARAMETER (MPOS = 7)
      PARAMETER (MINO = 3)
      PARAMETER (MLBL = 3)
      PARAMETER (MXYZ = 4)
      PARAMETER (MGRD = 3)
      PARAMETER (MSTA = 3)
C
      CHARACTER*10 SETNM1(MSET1)
      CHARACTER*10 SETNM2(MSET2)
      CHARACTER*10 POSNAM(MPOS),INONAM(MINO),LBLNAM(MLBL)
     1 ,XYZNAM(MXYZ),GRDNAM(MGRD)
      CHARACTER*10 STANAM(MSTA)
      CHARACTER*10 TMODE(2)
C
      INTEGER IUSEE(MFUNMX)
      LOGICAL QMNHEX,QEXIST
      LOGICAL QPLOT,QZERO,QPRDRW,QDISP
C
      REAL RNUM(10)
      integer mlist
      parameter (mlist = 10)
      integer ilist(mlist)
C
      CHARACTER*40 TEXTAX
      CHARACTER*255 TXT1,TXT2,CONCAT,CONCT0
      CHARACTER*80  THELP,THEAD
      CHARACTER*10 TCOMM
      LOGICAL QVAL,QEXIT
      CHARACTER*1 TTAX(3)
C
      DATA SETNM1/
     1 'EXIT',       'ENDSET',
     2 'X',         'Y',          'Z',         'PLOT',
     3 'IDB',       'SECONDARY',  'DIRECTORY', 'WORKING_DI','PATH',
     4 'SSIZE', 'TSIZE', 'USIZE', 'DSIZE', 'LSIZE', 'FSIZE', 'GSIZE',
     5 'SYMBOL',    'HATCH',      'PATTERN',   'COLOUR',    'COLOR',
     6 'EXCLUSIONS','THICKNESS',  'FIT',       'FUNCTION',  'BIN',
     7 'TITLE',     'TEXT',       'HEADER',    'FOOTER',   'STATISTICS',
     8 'IDSHOW',    'IDSIZE',     'BOX',       'PI',        'DISPLAY',
     9 'WINDOW',    'NO_WINDOW',  'NEXT_WINDO','ROTATION', 'PAPER',
     A 'DEFAULT',   'ALIAS',      'DEBUG',     'MANUAL',    'ABORT',
     B 'EDIT',      'SHELL',      'PAGER',     'DUMP',      'HARDCOPY',
     C 'REDRAW',    'ECHO',       'LOG',       'AUTOSWITCH', 'WAIT_CR',
     D 'HISTOGRAM', 'ORTHOGONAL', 'NORMALIZE', 'RATIO',    'CHARACTER',
     E 'SIGNAL',    'BACKGROUND', 'AUTOSCALE', 'AUTOTRIM', 'AUTOFETCH',
     F 'ORDER',     'TIME',       'NTUPLE',    'IGARC',    'HIGZ',
     G 'IGTABLE',   'FONT',      'RECL',       'ERR_ZERO',  'SHOW_ZERO',
     H 'FRAME',     'TICKS',  'GRID',  'SCALE','LABEL',  'AXIS',
     I 'PARAMETER', 'BREAK',      'MOUSE',     'DBASE',  'TKTCL',
     Z ' '/
C
      DATA SETNM2/
     1 'EXIT',  'ENDSET',
     2 'PSIZE',  'SIZE',  'HSIZE', 'MARGIN',
     3 'WSIZE',  'WMARGIN',
     3 'LIMITS', 'TICKS', 'SCALE', 'MODE',
     5 'AXIS',   'LABEL',
     4 'NULL',   'ZERO',  'GRID',  'OPT_ZERO',
     Z ' '/
C
      DATA POSNAM/
     1  'BOTTOM', 'TOP',  'LEFT', 'RIGHT', 'VERTICAL', 'ALL', ' '/
C
      DATA INONAM/'INSIDE', 'OUTSIDE', ' '/
C
      DATA LBLNAM/'PLOT', 'PAGE', ' '/
C
      DATA XYZNAM/'X', 'Y', 'Z', ' '/
C
      DATA GRDNAM/'BIG','ALL',' '/
C
      DATA STANAM/'MN_FIT','HBOOK',' '/
      DATA TMODE/'MODE', ' '/
C
      DATA TTAX/'X','Y','Z'/
C
      QEXIT  = IDELIM.EQ.0
      IERR   = 0
      QPRDRW = .FALSE.
      QPLOT  = .FALSE.
      QZERO  = .FALSE.
      QDISP  = .FALSE.
      GOTO 1010
 1000 CONTINUE
      IF(IDELIM.LT.0 .AND. QEXIT .AND. QPRDRW .AND. .NOT.QRFILE)
     1 WRITE(LUNTTO
     1  ,'('' Give command REDRAW to see the effect of changes'')')
      IF(IERR.NE.0 .OR. (IDELIM.LT.0 .AND. QEXIT)) GOTO 9000
 1010 CONTINUE
      CALL WAITYQ('SET> Give variable name or ?: ')
      JCMD = ICMTYQ(.TRUE.,IDELIM,SETNM1)
      COMND2 = ' '
      IF(JCMD.GT.0) COMND2 = SETNM1(JCMD)
      IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('SET')
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1010
      ENDIF
      CALL ICMSTR(TCOMM)
*
*     Check for English and American spelling of colour
*
      if(jcmd.eq.0) then
        nmatch = icmlst(mlist,ilist)
        if(nmatch.eq.2) then
          if(setnm1(ilist(1)).eq.'COLOUR') then
            jcmd   = ilist(1)
            comnd2 = setnm1(ilist(1))
          endif
        endif
      endif
C
C     SEE IF THE COMMAND WAS A NUMBER IF SO TREAT IT AS A PLOT COMMAND
C     NOTE THIS ONLY APPLIES IF WE HAVEN'T SPECIFIED A PLOT ALREADY
C
      IF(JCMD.EQ.0 .AND. .NOT.QPLOT) THEN
          CALL RESTYQ
          NVAL = INTTYQ(.TRUE.,IDELIM)
          CALL RESTYQ
          IF(IDELIM.LE.0 .OR. IDELIM.EQ.ICHAR('&')) THEN
              COMND2 = 'PLOT'
              GOTO 1100
          ELSE
              JCMD = ICMTYQ(.TRUE.,IDELIM,SETNM1)
          ENDIF
      ENDIF
C
C     CHECK FOR NORMAL ERRORS
C
      IF(IDELIM.GT.0 .OR. JCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,JCMD,MSET1,SETNM1,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          GOTO 1000
      ELSEIF(JCMD.LT.0) THEN
          IF(QRFILE) THEN
              GOTO 1000
          ELSE
              GOTO 9000
          ENDIF
      ENDIF
C
1100  CONTINUE
      IF(COMND2.EQ.'EXIT'.OR. COMND2.EQ.'ENDSET') THEN
          GOTO 9000
      ELSEIF(COMND2.EQ.'X' .OR. COMND2.EQ.'Y' .OR. COMND2.EQ.'Z') THEN
          IF(COMND2.EQ.'X') THEN
              NAX = 1
          ELSE IF(COMND2.EQ.'Y') THEN
              NAX = 2
          ELSE IF(COMND2.EQ.'Z') THEN
              NAX = 3
          ENDIF
          TEXTAX = CONCAT('SET> Give',TTAX(NAX))
          TXT1   = CONCT0(TEXTAX,'-axis variable name or ?: ')
          TEXTAX = TXT1
          IF(TCOMM.NE.TTAX(NAX)) THEN
              NCHAR = 0
              THEAD = ' '
              IF(IDELIM.GE.0) ISTR = ISTRNQ(.TRUE.,THEAD,NCHAR)
              TXT1 = TCOMM(2:)
              IF(NCHAR.GT.0) THEN
                  TXT2 = CONCAT(TXT1,THEAD(1:NCHAR))
                  TXT1 = TXT2
              ENDIF
              CALL QUOTYQ(TXT1)
          ENDIF
          GOTO 3000
C
C     SET THE PLOT NUMBER TO BE CHANGED
C
      ELSE IF(COMND2.EQ.'PLOT') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDAS,IDBS,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 1000
C
C         Check if the next command is default
C
          IDEF = 0
          IF(IDELIM.GE.0) THEN
              KCMD = ICMTYQ(.TRUE.,JDELIM,SETNM1)
              IF(KCMD.GT.0) COMND3 = SETNM1(KCMD)
              IF(COMND3.EQ.'DEFAULT') IDEF = 1
              CALL RESTYQ
          ENDIF
C
          QPLOT = .FALSE.
          QZERO = .FALSE.
          QDISP = .FALSE.
          IF(IDAS.EQ.0) THEN
              QPLOT = .TRUE.
              QZERO = .TRUE.
              NPS1 = 1
              NPS2 = NHPLT
              NPS3 = NHPLT
          ELSE
              DO 1150 NP=1,NHPLT
                  IF(IDAS.EQ.IPLTIA(NP) .AND. IDBS.EQ.IPLTIB(NP)) THEN
                      QPLOT = .TRUE.
                      NPS1 = NP
                      NPS2 = NP
                      NPS3 = NP
C
C                     MAKE SURE ALL OTHER OVERLAYS ARE CHANGED IN THE
C                     SAME WAY IF NECESSARY
C
                      IF(IPLTFL(NP).EQ.1) THEN
                          DO 1140 NNP=NP+1,NHPLT
                              IF(IPLTFL(NNP).EQ.1) GOTO 1141
                              NPS2 = NNP
1140                      CONTINUE
1141                      CONTINUE
                      ENDIF
                      GOTO 1151
                  ENDIF
1150          CONTINUE
              IF(IDEF.EQ.0) THEN
                  WRITE(LUNTTO,'('' *** Histogram'',I7,I4,'' not being''
     1             ,'' plotted'')') IDAS,IDBS
                  GOTO 1000
              ELSE
                  QPLOT = .TRUE.
                  NPS1  = 0
              ENDIF
1151          CONTINUE
          ENDIF
          IF(QEXIT) QEXIT = IDELIM.EQ.0
          GOTO 1010
C
C     SET THE DEFAULT SECONDARY IDENTIFIER
C
      ELSEIF(COMND2.EQ.'IDB' .OR. COMND2.EQ.'SECONDARY_') THEN
          CALL WAITYQ('Give default secondary identifier: ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 1000
          IF(NVAL.LT.0 .OR. NVAL.GE.980) THEN
              WRITE(LUNTTO,'(1X,I4,'' is not a valid secondary ID''
     1         ,'' It must lie between 0 and 999'')')
     1         NVAL
              GOTO 1000
          ENDIF
          NDIDB = NVAL
C
C     Set the default directory for HBOOK input files
C     Must increase the allowed symbols to include /
C
      ELSEIF(COMND2.EQ.'DIRECTORY') THEN
          CALL M_CDIR(IDELIM,0,IERR)
          IF(IERR.NE.0) GOTO 1000
C
C     Set the working directory for files
C
      ELSEIF(COMND2.EQ.'WORKING_DI') THEN
          CALL M_SPWD(IDELIM,0,IERR)
          IF(IERR.NE.0) GOTO 1000
C
C     Set the path for files
C
      ELSEIF(COMND2.EQ.'PATH') THEN
          CALL M_SPWD(IDELIM,2,IERR)
          IF(IERR.NE.0) GOTO 1000
C
C     Change the size of a plotting parameter
C
      ELSEIF(COMND2.EQ.'SSIZE' .OR. COMND2.EQ.'TSIZE' .OR.
     1       COMND2.EQ.'USIZE' .OR. COMND2.EQ.'DSIZE' .OR.
     +       COMND2.EQ.'IDSIZE'.OR. COMND2.EQ.'LSIZE' .OR.
     +       COMND2.EQ.'FSIZE' .OR. COMND2.EQ.'GSIZE' .OR.
     +       COMND2.EQ.'ROTATION') THEN
          CALL M_SSIZ(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Change the default symbol, hatch or pattern number
C
      ELSEIF(COMND2.EQ.'SYMBOL'  .OR. COMND2.EQ.'HATCH' .OR.
     1       COMND2.EQ.'PATTERN') THEN
          CALL M_SSYM(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set the option for showing the header and/or footer
C
      ELSEIF(COMND2.EQ.'HEADER' .OR. COMND2.EQ.'IDSHOW' .or.
     +       comnd2.eq.'FOOTER') THEN
          call m_shead(idelim,qprdrw,ierr)
C
C     Set various flags
C
      ELSEIF(COMND2.EQ.'EXCLUSIONS' .OR. COMND2.EQ.'TEXT'       .OR.
     1       COMND2.EQ.'BOX'        .OR. COMND2.EQ.'ALIAS'      .OR.
     3       COMND2.EQ.'ECHO'       .OR. COMND2.EQ.'LOG'        .OR.
     +       COMND2.EQ.'AUTOSWITCH' .OR. COMND2.EQ.'WAIT_CR'    .OR.
     4       COMND2.EQ.'NORMALIZE'  .OR. COMND2.EQ.'RATIO'      .OR.
     5       COMND2.EQ.'ERR_ZERO'   .OR. COMND2.EQ.'SHOW_ZERO'  .OR.
     +       COMND2.EQ.'DEBUG'      .OR. COMND2.EQ.'MANUAL'     .OR.
     +       COMND2.EQ.'BREAK'      .OR. COMND2.EQ.'MOUSE'      .OR.
     +       COMND2.EQ.'PI'         .or. COMND2.EQ.'ABORT'      .OR.
     +       comnd2.eq.'AUTOSCALE'  .or. comnd2.eq.'AUTOTRIM'   .OR.
     +       comnd2.eq.'IGARC'      .or. comnd2.EQ.'TKTCL')  THEN
          CALL M_SFLG(IDELIM,QPRDRW,IERR)
C
C     Set colour
C
      ELSEIF(COMND2.EQ.'COLOUR' .or. comnd2.eq.'COLOR') THEN
          CALL M_SCOL(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set pen thickness
C
      ELSEIF(COMND2.EQ.'THICKNESS') THEN
          CALL M_STHK(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set the fonts for text
C
      ELSEIF(COMND2.EQ.'FONT') THEN
          CALL M_SFNT(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set bin scale factor and offset
C
      ELSEIF(COMND2.EQ.'BIN') THEN
          CALL M_SBIN(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set the comment and continuation characters
C
      ELSEIF(COMND2.EQ.'CHARACTER') THEN
          CALL M_SCHAR(IDELIM,IERR)
C
C     Set the paper size
C
      ELSEIF(COMND2.EQ.'PAPER') THEN
          CALL M_SPAPER(IDELIM,IERR)
C
C     Set HIGZ parameters, either HPLSET,IGSET or HPLTAB parameters
C
      ELSEIF(COMND2.EQ.'HIGZ') THEN
          CALL M_IGSET(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set IGTABLE parameters - can also use SET HIGZ IGTABLE syntax
C
      ELSEIF(COMND2.EQ.'IGTABLE') THEN
          CALL M_SIGTABL(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     Set database access parameters
C
      ELSEIF(COMND2.EQ.'DBASE') THEN
          CALL M_DBSET(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     CHANGE THE TITLE DISPLAY
C
      ELSEIF(COMND2.EQ.'TITLE') THEN
          CALL M_STITL(IDELIM,QPLOT,QZERO,NPS1,NPS3,QPRDRW,IERR)
C
C     CHANGE THE DISPLAY MODE
C
      ELSEIF(COMND2.EQ.'DISPLAY') THEN
          CALL WAITYQ('SET> Give variable name or MODE: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,TMODE)
          IF(KCMD.LE.0) THEN
              QPLOT = .FALSE.
              QZERO = .FALSE.
              CALL RESTYQ
              QDISP = .TRUE.
              GOTO 1010
          ELSE
 1500         CONTINUE
              IF(IDELIM.NE.0 .AND. .NOT.QRFILE) WRITE(LUNTTO
     1         ,'('' Valid display modes are:''
     1         ,/,''  1: Show fit''
     2         ,/,''  2: Show background subtracted fit''
     3         ,/,''  3: Show both fit and background subtraction''
     3         ,/,'' -2: Same as 2 but divide by background also''
     3         ,/,'' -3: Same as 3 but divide by background also''
     4         )')
              CALL WAITYQ('Give display mode: ')
              NVAL = INTTYQ(.TRUE.,IDELIM)
              CALL MN_NCK(NVAL,IDELIM,IERR)
              IF(IERR.GT.0) GOTO 1000
              IF(NVAL.EQ.1 .OR. IABS(NVAL).EQ.2 .OR.
     1           IABS(NVAL).EQ.3) THEN
                  NDMODE = NVAL
              ELSE
                  WRITE(LUNTTO,'(1X,I4,'' is not a valid mode'')')
     1             NVAL
                  GOTO 1000
              ENDIF
          ENDIF
C
C     CHANGE THE CURRENT WINDOW NUMBER
C
      ELSE IF((QPLOT .AND. COMND2.EQ.'WINDOW') .OR.
     1        COMND2.EQ.'NEXT_WINDO') THEN
          CALL MN_WND(0,IDELIM,QPLOT,NPS1,NPS2)
C
C     SET UP FOR WINDOWING
C
      ELSE IF(COMND2.EQ.'WINDOW') THEN
          CALL MN_WND(1,IDELIM,QPLOT,NPS1,NPS2)
C
C     TURN OFF WINDOWING
C
      ELSE IF(COMND2.EQ.'NO_WINDOW') THEN
          CALL MN_WND(-1,IDELIM,QPLOT,NPS1,NPS2)
C
C     Set everything back to default
C     or set a plot to be the default
C
      ELSEIF(COMND2.EQ.'DEFAULT' .OR. COMND2.EQ.'HISTOGRAM') THEN
          IF(COMND2.EQ.'DEFAULT' .AND. .NOT.QPLOT) THEN
              CALL MN_DFL
C
C             SET ALL THE CURRENT PLOTS TO DEFAULT ALSO
C
              DO 1650 NP=1,NHPLT
                  NTYPFL = 1
                  CALL MN_PSP(NTYPFL,NP,IERR)
1650          CONTINUE
C
C         MAKE THIS PLOT THE DEFAULT PLOT
C
          ELSE
            call m_spdfl(idas,idbs,qzero,idelim,ierr)
            if(ierr.ne.0) goto 9000
C
C           If this plot is not being displayed turn off the QPLOT flag
C
            IF(COMND2.EQ.'DEFAULT' .AND. NPS1.EQ.1) THEN
              QPLOT = .FALSE.
            ENDIF
          ENDIF
C
C     Change parameters for fitting
C
      ELSEIF(COMND2.EQ.'FIT') THEN
          CALL M_SFIT(IDELIM,IERR)
C
C     Change ways of using functions
C
      ELSEIF(COMND2.EQ.'FUNCTION') THEN
          CALL M_SFUN(IDELIM,IERR)
C
C     CHANGE THE EDIT COMMAND
C
      ELSEIF(COMND2.EQ.'EDIT'     .or. comnd2.eq.'SHELL' .or.
     +       comnd2.eq.'PAGER'    .or. comnd2.eq.'DUMP'  .or.
     +       comnd2.eq.'HARDCOPY') THEN
          call m_scmd(idelim,ierr)
C
C     REDRAW COMMAND
C
      ELSEIF(COMND2.EQ.'REDRAW') THEN
          QPRDRW = .FALSE.
          NFLAG = 2
          IF(QDFIT) NFLAG = -2
          CALL MN_DRW(NFLAG,NDERR)
C
C     Define signal or background functions
C
      ELSE IF(COMND2.EQ.'SIGNAL' .OR. COMND2.EQ.'BACKGROUND') THEN
          IF(COMND2.EQ.'SIGNAL') THEN
              CALL WAITYQ('Give function number(s) for signal: ')
              QSBACK = .FALSE.
          ELSE
              CALL WAITYQ('Give function number(s) for background: ')
              QSBACK = .TRUE.
          ENDIF
C
          CALL MN_FQU(IUSEE,-1,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
          DO 1700 IF=1,NFUN_MN
              IF(IUSEF(IF).LE.0) GOTO 1700
              IF(COMND2.EQ.'SIGNAL') THEN
                  IF(IUSEE(IF).GT.0) THEN
                      ISIGF(IF) = 1
                      IBCKF(IF) = 0
                  ELSE
                      QSBACK = .TRUE.
                      ISIGF(IF) = 0
                      IBCKF(IF) = 1
                  ENDIF
              ELSE
                  IF(IUSEE(IF).GT.0) THEN
                      ISIGF(IF) = 0
                      IBCKF(IF) = 1
                  ELSE
                      ISIGF(IF) = 1
                      IBCKF(IF) = 0
                  ENDIF
              ENDIF
1700      CONTINUE
C
C     SET ORTHOGONALITY LIMITS
C
      ELSE IF(COMND2.EQ.'ORTHOGONAL') THEN
          CALL M_SORT(IDELIM,IERR)
C
C     DEFINE THE ORDER OF THE VARIABLES WHEN READING IN DATA CARDS
C
      ELSEIF(COMND2.EQ.'ORDER') THEN
          CALL WAITYQ('Give order or ?: ')
          CALL M_SORD(0,IDELIM,IERR)
C
C     Define the order Ntuple variables for plotting Ntuples directly
C     or for fitting them.
C
      ELSEIF(COMND2.EQ.'NTUPLE') THEN
          CALL WAITYQ('Give command PLOT|VARIABLE|NAME or ?: ')
          CALL M_SNTP(0,IDELIM,IERR)
C
C     Define the time mode for plots and the reference time
C
      ELSE IF(COMND2.EQ.'TIME') THEN
          CALL WAITYQ('Give mode and reference time or ?: ')
          CALL M_STIM(0,IDELIM,IERR)
C
C     Set the record length for HBOOK4 files
C
      ELSE IF(COMND2.EQ.'RECL') THEN
          CALL WAITYQ('Give record length for HBOOK4 file: ')
          NVAL = INTTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.GT.0 .OR. NVAL.LT.0) GOTO 1000
          NRCLHB = NVAL
C
C     Set flag for where to get histogram statistics from
C
      ELSEIF(COMND2.EQ.'STATISTICS') THEN
          CALL WAITYQ('Use MN_FIT or HBOOK statistics: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,STANAM)
          IF(KCMD.LE.0) THEN
              CALL MN_DCK(IDELIM,KCMD,MSTA,STANAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          ELSEIF(KCMD.EQ.1) THEN
              QHSTAT = .FALSE.
          ELSEIF(KCMD.EQ.2) THEN
              QHSTAT = .TRUE.
          ENDIF
C
C     DRAW FRAME ROUND OUTSIDE OF PLOT OR NOT
C
      ELSE IF(COMND2.EQ.'FRAME') THEN
2000      CONTINUE
          CALL WAITYQ(
     +     'Give All, Bottom, Top, Left, Right, Vertical or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,POSNAM)
          IF(KCMD.GT.0) COMND3 = POSNAM(KCMD)
C
          IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ('SET FRAME')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2000
          ENDIF
C
          CALL MN_DCK(IDELIM,KCMD,MPOS,POSNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(KCMD.LT.0) GOTO 1000
          IF(IERR.NE.0) GOTO 1000
C
C         CHANGE WHERE TO PUT FRAME
C
          IF(KCMD.LE.5) THEN
              NBT1 = MOD(KCMD-1,2) + 1
              NBT2 = NBT1
              NAX1 = (KCMD-1) / 2 + 1
              NAX2 = NAX1
          ELSE
              NBT1 = 1
              NBT2 = 2
              NAX1 = 1
              NAX2 = 3
          ENDIF
          CALL WAITYQ('On or Off: ')
          NCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          CALL MN_DCK(IDELIM,NCMD,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(IERR.GT.0) GOTO 1000
          IF(MOD(NCMD,2).EQ.1) THEN
              QVAL = .TRUE.
          ELSE IF(NCMD.GT.0) THEN
              QVAL = .FALSE.
          ELSE
              GOTO 1000
          ENDIF
          IF(QPLOT) THEN
              DO 2020 NP=NPS1,NPS2
                  QPRDRW = .TRUE.
                  DO 2018 NAX=NAX1,NAX2
                      DO 2016 NBT=NBT1,NBT2
                          QFRAMP(NBT,NAX,NP) = QVAL
2016                  CONTINUE
2018              CONTINUE
2020          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              DO 2024 NAX=NAX1,NAX2
                  DO 2022 NBT=NBT1,NBT2
                      QFRAMS(NBT,NAX) = QVAL
2022              CONTINUE
2024          CONTINUE
          ENDIF
          IF(IDELIM.EQ.0) GOTO 2000
C
C     TICK MARKS
C
      ELSE IF(COMND2.EQ.'TICKS') THEN
2100      CONTINUE
          CALL WAITYQ('Give axis, All, Bottom, Top, Left, Right' //
     1     ' or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,XYZNAM)
          IF(KCMD.GT.0) THEN
              COMND3 = COMND2
              COMND2 = XYZNAM(KCMD)
              NAX = KCMD
              GOTO 3030
          ELSE
              CALL RESTYQ
          ENDIF
C
          CALL WAITYQ(
     +     'Give All, Bottom, Top, Left, Right, Vertical or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,POSNAM)
          IF(KCMD.GT.0) COMND3 = POSNAM(KCMD)
          IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ('SET TICK')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2100
          ENDIF
C
          CALL MN_DCK(IDELIM,KCMD,MPOS,POSNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(KCMD.LT.0) GOTO 1000
          IF(IERR.NE.0) GOTO 1000
C
          IF(KCMD.LE.5) THEN
              NBT1 = MOD(KCMD-1,2) + 1
              NBT2 = NBT1
              NAX1 = (KCMD-1) / 2 + 1
              NAX2 = NAX1
          ELSE
              NBT1 = 1
              NBT2 = 2
              NAX1 = 1
              NAX2 = 3
          ENDIF
C
          NIO1 = 1
          NIO2 = 2
          CALL WAITYQ('Give Inside, Outside, On or Off: ')
          NCMD = ICMTYQ(.TRUE.,IDELIM,INONAM)
          IF(NCMD.GT.0) THEN
              NIO1 = NCMD
              NIO2 = NCMD
          ELSE
              CALL RESTYQ
          ENDIF
C
          CALL WAITYQ('On or Off: ')
          NLOG = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          CALL MN_DCK(IDELIM,NLOG,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(IERR.GT.0) GOTO 1000
          IF(MOD(NLOG,2).EQ.1) THEN
              NON = 1
          ELSE IF(NLOG.GT.0) THEN
              NON = 2
          ELSE
              GOTO 1000
          ENDIF
          QVAL = NON.EQ.1

          IF(QPLOT) THEN
              DO 2120 NP=NPS1,NPS3
                  QPRDRW = .TRUE.
                  DO 2118 NAX=NAX1,NAX2
                      DO 2116 NBT=NBT1,NBT2
                          DO 2114 NIO=NIO1,NIO2
                              NN = 2*(NBT-1) + NIO
                              QTICKP(NN,NAX,NP) = QVAL
2114                      CONTINUE
2116                  CONTINUE
2118              CONTINUE
2120          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              DO 2126 NAX=NAX1,NAX2
                  DO 2124 NBT=NBT1,NBT2
                      DO 2122 NIO=NIO1,NIO2
                          NN = 2*(NBT-1) + NIO
                          QTICKS(NN,NAX) = QVAL
2122                  CONTINUE
2124              CONTINUE
2126          CONTINUE
          ENDIF
          IF(IDELIM.EQ.0) GOTO 2100
C
C     GRID
C
      ELSEIF(COMND2.EQ.'GRID') THEN
2150      CONTINUE
          CALL WAITYQ('Give axis or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,XYZNAM)
          IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ('SET GRID')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2150
          ENDIF
          CALL MN_DCK(IDELIM,NLOG,MXYZ,XYZNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(IERR.GT.0) GOTO 1000
          IF(KCMD.GT.0) THEN
              COMND3 = COMND2
              COMND2 = XYZNAM(KCMD)
              NAX = KCMD
              GOTO 3030
          ENDIF
C
C     SCALE
C
      ELSE IF(COMND2.EQ.'SCALE') THEN
2200      CONTINUE
          CALL WAITYQ('Give axis, All, Bottom, Top, Left, Right' //
     1     ' or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,XYZNAM)
          IF(KCMD.GT.0) THEN
              COMND3 = COMND2
              COMND2 = XYZNAM(KCMD)
              NAX = KCMD
              GOTO 3030
          ELSE
              CALL RESTYQ
          ENDIF
C
          CALL WAITYQ(
     +     'Give All, Bottom, Top, Left, Right, Vertical or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,POSNAM)
          IF(KCMD.GT.0) COMND3 = POSNAM(KCMD)
C
          IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ('SET SCALE')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2200
          ENDIF
C
          CALL MN_DCK(IDELIM,KCMD,MPOS,POSNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(KCMD.LT.0) GOTO 1000
          IF(IERR.NE.0) GOTO 1000
C
C         CHANGE WHERE TO PUT SCALE
C
          IF(KCMD.LE.5) THEN
              NBT1 = MOD(KCMD-1,2) + 1
              NBT2 = NBT1
              NAX1 = (KCMD-1) / 2 + 1
              NAX2 = NAX1
          ELSE
              NBT1 = 1
              NBT2 = 2
              NAX1 = 1
              NAX2 = 3
          ENDIF
          CALL WAITYQ('On or Off: ')
          NCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          CALL MN_DCK(IDELIM,NCMD,MLOG,LOGNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(IERR.GT.0) GOTO 1000
          IF(MOD(NCMD,2).EQ.1) THEN
              QVAL = .TRUE.
          ELSE IF(NCMD.GT.0) THEN
              QVAL = .FALSE.
          ELSE
              GOTO 1000
          ENDIF
          IF(QPLOT) THEN
              DO 2220 NP=NPS1,NPS2
                  QPRDRW = .TRUE.
                  DO 2218 NAX=NAX1,NAX2
                      DO 2216 NBT=NBT1,NBT2
                          QSCALP(NBT,NAX,NP) = QVAL
2216                  CONTINUE
2218              CONTINUE
2220          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              DO 2224 NAX=NAX1,NAX2
                  DO 2222 NBT=NBT1,NBT2
                      QSCALS(NBT,NAX) = QVAL
2222              CONTINUE
2224          CONTINUE
          ENDIF
          IF(IDELIM.EQ.0) GOTO 2200
C
C     LABEL
C
      ELSE IF(COMND2.EQ.'LABEL' .OR. COMND2.EQ.'AXIS') THEN
2300      CONTINUE
          CALL WAITYQ('Give axis, All, Bottom, Top, Left, Right' //
     1     ' or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,XYZNAM)
          IF(KCMD.GT.0) THEN
              COMND3 = COMND2
              COMND2 = XYZNAM(KCMD)
              NAX = KCMD
              GOTO 3030
          ELSE
              CALL RESTYQ
          ENDIF
C
C         CHANGE THE LABEL MODE OR WHERE TO PUT IT
C
          CALL WAITYQ(
     +     'Give All, Bottom, Top, Left, Right, Vertical or ?: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,POSNAM)
          IF(KCMD.GT.0) COMND3 = POSNAM(KCMD)
C
          IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              IF(COMND2.EQ.'LABEL') THEN
                  CALL QUOTYQ('SET LABEL')
              ELSE
                  CALL QUOTYQ('SET AXIS')
              ENDIF
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 2300
          ENDIF
C
          CALL MN_DCK(IDELIM,KCMD,MPOS,POSNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          IF(KCMD.LT.0) GOTO 1000
          IF(IERR.NE.0) GOTO 1000
C
C         CHANGE WHERE TO PUT LABEL
C
          IF(KCMD.LE.5) THEN
              NBT1 = MOD(KCMD-1,2) + 1
              NBT2 = NBT1
              NAX1 = (KCMD-1) / 2 + 1
              NAX2 = NAX1
          ELSE
              NBT1 = 1
              NBT2 = 2
              NAX1 = 1
              NAX2 = 3
          ENDIF
C
          CALL WAITYQ('Plot, Page, On or Off: ')
          NCMD = ICMTYQ(.TRUE.,IDELIM,LBLNAM)
C
C         ONE LABEL PER PLOT OR PAGE
C
          IF(NCMD.GT.0) THEN
              IF(QPLOT .AND. .NOT.QZERO) THEN
                  WRITE(LUNTTO,'('' This mode is not valid for''
     1             ,''particular plots'')')
                  GOTO 1000
              ENDIF
C
              IF(NCMD.EQ.1) THEN
                  QVAL = .FALSE.
              ELSE
                  QVAL = .TRUE.
              ENDIF
              IF(QPLOT) THEN
                  DO 2310 NP=NPS1,NPS2
                      QPRDRW = .TRUE.
                      DO 2308 NAX=NAX1,NAX2
                          QLABLP(3,NAX,NP) = QVAL
                          IF(QVAL) THEN
                              IF(IPLTCL(NP).EQ.1) THEN
                                  QLABLP(1,NAX,NP) = .TRUE.
                              ELSE
                                  QLABLP(1,NAX,NP) = .FALSE.
                              ENDIF
                              QLABLP(2,NAX,NP) = .FALSE.
                          ELSE
                              IF(IPLTFL(NP).EQ.1) THEN
                                  QLABLP(1,NAX,NP) = .TRUE.
                              ELSE
                                  QLABLP(1,NAX,NP) = .FALSE.
                              ENDIF
                              QLABLP(2,NAX,NP) = .FALSE.
                          ENDIF
2308                  CONTINUE
2310              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR. QZERO) THEN
                  DO 2314 NAX=NAX1,NAX2
                      QLABLS(3,NAX) = QVAL
2314              CONTINUE
              ENDIF
C
C         TURN LABEL ON OR OFF FOR A PARTICULAR AXIS
C
          ELSE
              CALL RESTYQ
              NCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
              CALL MN_DCK(IDELIM,NCMD,MLOG,LOGNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
              IF(IERR.GT.0) GOTO 1000
              IF(MOD(NCMD,2).EQ.1) THEN
                  QVAL = .TRUE.
              ELSE IF(NCMD.GT.0) THEN
                  QVAL = .FALSE.
              ELSE
                  GOTO 1000
              ENDIF
              IF(QPLOT) THEN
                  DO 2320 NP=NPS1,NPS2
                      QPRDRW = .TRUE.
                      DO 2318 NAX=NAX1,NAX2
                          DO 2316 NBT=NBT1,NBT2
                              QLABLP(NBT,NAX,NP) = QVAL
2316                      CONTINUE
2318                  CONTINUE
2320              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR. QZERO) THEN
                  DO 2324 NAX=NAX1,NAX2
                      DO 2322 NBT=NBT1,NBT2
                          QLABLS(NBT,NAX) = QVAL
2322                  CONTINUE
2324              CONTINUE
              ENDIF
          ENDIF
          IF(IDELIM.EQ.0) GOTO 2300
C
C     Set parameters for the L3 online display
C
      ELSEIF(COMND2.EQ.'PARAMETER' .OR.
     +       COMND2.EQ.'KEY') THEN
          CALL MN_DSS(IDELIM,QZERO,QPLOT,NPS1,NPS2)
      ENDIF
      GOTO 1000
C
C----------------------------------------------------------------------------
C     VARIABLES SPECIFIC TO AN AXIS
C----------------------------------------------------------------------------
C
 3000 CONTINUE
      CALL WAITYQ(TEXTAX(1:MNLLEN(TEXTAX)+1))
      KCMD = ICMTYQ(.TRUE.,IDELIM,SETNM2)
      IF(KCMD.GT.0) COMND3 = SETNM2(KCMD)
      IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('SET')
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 3000
      ENDIF
C
      IF(QRFILE .AND. (IDELIM.GT.0 .OR. KCMD.EQ.0)) THEN
          CALL RESTYQ
          GOTO 1000
      ENDIF
      IF(IDELIM.GT.0 .OR. KCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,KCMD,MSET2,SETNM2,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
          GOTO 3000
      ELSEIF(KCMD.LT.0) THEN
          GOTO 1000
      ENDIF
3030  CONTINUE
C
C     SET UP THE HEADER FOR CHANGING THINGS
C
      IF(QPLOT) THEN
          THEAD = 'Present parameters for plot'
          WRITE(TCOMM,'(I7)') IDAS
          THEAD = CONCAT(THEAD,TCOMM)
          THEAD = CONCT0(THEAD,',')
          WRITE(TCOMM,'(I4)') IDBS
          THEAD = CONCAT(THEAD,TCOMM)
          THEAD = CONCAT(THEAD,TTAX(NAX))
          THEAD = CONCAT(THEAD,'axis are:')
      ELSE
          THEAD = 'Present parameters for'
          THEAD = CONCAT(THEAD,TTAX(NAX))
          THEAD = CONCAT(THEAD,'axis are:')
      ENDIF
C
C     EXIT FROM SET
C
      IF(COMND3.EQ.'EXIT' .OR. COMND3.EQ.'ENDSET') THEN
          GOTO 9000
C
C     ONLY ALLOWED TO SET CERTAIN THINGS FOR Z AXIS
C
      ELSEIF(COMND2.EQ.'Z'     .AND. COMND3.NE.'LIMITS' .AND.
     +       COMND3.NE.'TICKS' .AND.
     +       COMND3.NE.'SCALE' .AND. COMND3.NE.'MODE'  .AND.
     +       COMND3.NE.'AXIS'  .AND. COMND3.NE.'LABEL' .AND.
     +       COMND3.NE.'GRID'  .AND. COMND3.NE.'OPT_ZERO') THEN
          CALL MN_ERR('MN_SET','Command is not valid for the z-axis')
          GOTO 1000
C
C     OVERALL PICTURE SIZE
C
      ELSE IF(COMND3.EQ.'PSIZE') THEN
          IF(QPLOT .AND. .NOT.QZERO) THEN
              WRITE(LUNTTO,'('' You can only change the overall''
     1         ,'' picture size for all the plots'')')
              GOTO 1000
          ENDIF
C
          THEAD = ' '
          THELP = 'SET PSIZE'
          CALL MN_ENM(IDELIM,THELP,THEAD,2
     1     ,TSIZEN,ISIZEN,SIZES(NAX)
     1     ,NNUM,RNUM,IERR)
          IF(IERR.NE.0) GOTO 1000
          IF(NNUM.LE.0) GOTO 1000
          RVAL = RNUM(1)
C
          QPRDRW = .TRUE.
          IF(QDISP) THEN
              IF(RVAL.EQ.0.0) RVAL = FSIZED(NAX)
              IF(QDFIT) SIZES(NAX) = RVAL
              FSIZE(NAX) = RVAL
          ELSE
              IF(RVAL.EQ.0.0) RVAL = SIZED(NAX)
              SIZES(NAX) = RVAL
              PSIZE(NAX) = RVAL
          ENDIF
C
C     OVERALL PLOT SIZE
C
      ELSE IF(COMND3.EQ.'SIZE' .OR. COMND3.EQ.'HSIZE') THEN
          IF(QPLOT) THEN
              IF(IPLTFL(NPS1).NE.1) THEN
                  WRITE(LUNTTO,'('' You cannot change the histogram''
     1             ,'' size for an overlayed plot'')')
                  GOTO 1000
              ENDIF
          ENDIF
C
          THEAD = ' '
          THELP = 'SET SIZE'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,THSZEN,IHSZEN,HSZEP(NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,THSZEN,IHSZEN,HSZES(NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
          IF(IERR.NE.0) GOTO 1000
          IF(NNUM.LE.0) GOTO 1000
          RVAL = RNUM(1)
C
          IF(RVAL.EQ.0.0) THEN
              IF(QDISP) THEN
                  RVAL = FHSZED(NAX)
              ELSE
                  RVAL = HSZED(NAX)
              ENDIF
          ENDIF
C
          IF(QPLOT) THEN
              IF(QWIND) THEN
                  WRITE(LUNTTO
     1             ,'('' *** This command has no effect.''
     2             ,/,'' *** Use the SET X|Y WSIZE command''
     3               ,'' to change the size of plots in a window''
     4             )')
              ELSE
                  DO 3120 NP=NPS1,NPS2
                      QPRDRW = .TRUE.
                      HSZEP(NAX,NP) = RVAL
3120              CONTINUE
              ENDIF
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              IF(QDISP) THEN
                  FHSZE(NAX) = RVAL
                  IF(QDFIT) HSZES(NAX) = RVAL
              ELSE
                  HSZES(NAX) = RVAL
                  PHSZE(NAX) = RVAL
              ENDIF
          ENDIF
C
C     OVERALL MARGIN SIZE
C
      ELSE IF(COMND3.EQ.'MARGIN') THEN
          IF(QPLOT) THEN
              IF(IPLTFL(NPS1).NE.1) THEN
                  WRITE(LUNTTO,'('' You cannot change the margin''
     1             ,'' size for an overlayed plot'')')
                  GOTO 1000
              ENDIF
          ENDIF
C
          THEAD = ' '
          THELP = 'SET MARGIN'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,TMRGN,IMRGN,AMRGP(NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,TMRGN,IMRGN,AMRGS(NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
          IF(IERR.NE.0) GOTO 1000
          IF(NNUM.LE.0) GOTO 1000
          RVAL = RNUM(1)
C
          IF(RVAL.EQ.0.0) THEN
              IF(QDISP) THEN
                  RVAL = FAMRGD(NAX)
              ELSE
                  RVAL = AMRGD(NAX)
              ENDIF
          ENDIF
          IF(QPLOT) THEN
              IF(QWIND) THEN
                  WRITE(LUNTTO
     1             ,'('' *** This command has no effect.''
     2             ,/,'' *** Use the SET X|Y WMARGIN command''
     3               ,'' to change the position of plots in a window''
     4             )')
              ELSE
                  DO 3130 NP=NPS1,NPS2
                      QPRDRW = .TRUE.
                      AMRGP(NAX,NP) = RVAL
3130              CONTINUE
              ENDIF
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              IF(QDISP) THEN
                  FAMRG(NAX) = RVAL
                  IF(QDFIT) AMRGS(NAX) = RVAL
              ELSE
                  AMRGS(NAX) = RVAL
                  PAMRG(NAX) = RVAL
              ENDIF
          ENDIF
C
C     MARGIN SIZE
C
      ELSE IF(COMND3.EQ.'WMARGIN') THEN
          IF(QPLOT) THEN
              IF(IPLTFL(NPS1).NE.1) THEN
                  WRITE(LUNTTO,'('' You cannot change the margin''
     1             ,'' size for an overlayed plot'')')
                  GOTO 1000
              ENDIF
          ENDIF
          THEAD = ' '
          THELP = 'SET WMARGIN'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,TMRGN,IMRGN,WMRGP(NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,TMRGN,IMRGN,WMRGS(NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
          IF(IERR.NE.0) GOTO 1000
          IF(NNUM.LE.0) GOTO 1000
          RVAL = RNUM(1)
C
          IF(RVAL.EQ.0.0) RVAL = WMRGD(NAX)
C
          IF(QPLOT) THEN
              DO 3140 NP=NPS1,NPS2
                  QPRDRW = .TRUE.
                  WMRGP(NAX,NP) = RVAL
3140          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              WMRGS(NAX) = RVAL
          ENDIF
C
C     PLOT SIZE
C
      ELSE IF(COMND3.EQ.'WSIZE') THEN
          IF(QPLOT) THEN
              IF(IPLTFL(NPS1).NE.1) THEN
                  WRITE(LUNTTO,'('' You cannot change the histogram''
     1             ,'' size for an overlayed plot'')')
                  GOTO 1000
              ENDIF
          ENDIF
          THEAD = ' '
          THELP = 'SET WSIZE'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,THSZEN,IHSZEN,WSZEP(NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,2
     1         ,THSZEN,IHSZEN,WSZES(NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
          IF(IERR.NE.0) GOTO 1000
          IF(NNUM.LE.0) GOTO 1000
          RVAL = RNUM(1)
          IF(RVAL.EQ.0.0) RVAL = WSZED(NAX)
C
          IF(QPLOT) THEN
              DO 3150 NP=NPS1,NPS2
                  QPRDRW = .TRUE.
                  WSZEP(NAX,NP) = RVAL
3150          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              WSZES(NAX) = RVAL
          ENDIF
C
      ELSE IF(COMND3.EQ.'LIMITS') THEN
          call m_slim(idelim,qplot,qzero,nax,nps1,nps2,qprdrw,ierr)
C
C     Bottom limit should be zero or not (default = .TRUE.)
C
      ELSEIF(COMND3.EQ.'OPT_ZERO') THEN
          CALL WAITYQ('On or Off: ')
          LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          IF(MOD(LCMD,2).EQ.1) THEN
              QVAL = .TRUE.
          ELSEIF(KCMD.GT.0) THEN
              QVAL = .FALSE.
          ELSE
              GOTO 1000
          ENDIF
C
          IF(QPLOT) THEN
              DO 3300 NP=NPS1,NPS3
                  QPRDRW = .TRUE.
                  QSCALP(10,NAX,NP) = QVAL
                  QLIMCP(NAX,NP) = .TRUE.
3300          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              QSCALS(10,NAX) = QVAL
          ENDIF
C
      ELSE IF(COMND3.EQ.'NULL' .OR. COMND3.EQ.'ZERO' .OR.
     +        COMND3.EQ.'GRID') THEN
          CALL WAITYQ('On or Off: ')
          LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          IF(MOD(LCMD,2).EQ.1) THEN
              QVAL = .TRUE.
          ELSEIF(LCMD.GT.0) THEN
              QVAL = .FALSE.
          ELSE
              GOTO 1000
          ENDIF
          IF(QVAL) THEN
C
C             Get the grid option
C
              IF(COMND3.EQ.'GRID') THEN
                  CALL WAITYQ(
     +             'Give option for grid (ALL, BIG, <CR>=BIG): ')
                  LCMD = ICMTYQ(.TRUE.,IDELIM,GRDNAM)
                  IF(LCMD.LE.0) LCMD = 1
              ENDIF
C
C             Get symbol number for the line
C
              IF(COMND3.EQ.'NULL' .OR. COMND3.EQ.'ZERO') THEN
                  TXT1 = 'Give symbol for line (<CR>='
                  WRITE(TCOMM,'(I6)') IZEROS(NAX)
              ELSE
                  IF(IGRIDS(1,NAX).LE.0) IGRIDS(1,NAX) = 3
                  TXT1 = 'Give symbol for grid (<CR>='
                  WRITE(TCOMM,'(I6)') IGRIDS(1,NAX)
              ENDIF
              TXT2 = CONCT0(TXT1,TCOMM)
              TXT1 = CONCT0(TXT2,'):')
              CALL WAITYQ(TXT1(1:MNLLEN(TXT1)+1))
              NVAL = INTTYQ(.TRUE.,IDELIM)
              CALL MN_NCK(NVAL,IDELIM,IERR)
              IF(IERR.GT.0 .AND. IERR.NE.2) THEN
                  GOTO 1000
              ELSE IF(IERR.EQ.2) THEN
                  IF(COMND3.EQ.'NULL' .OR. COMND3.EQ.'ZERO') THEN
                      NVAL = IZEROS(NAX)
                  ELSE
                      NVAL = IGRIDS(1,NAX)
                      IF(NVAL.EQ.0) NVAL = 3
                  ENDIF
              ENDIF
          ENDIF
C
          IF(QPLOT) THEN
              DO 3310 NP=NPS1,NPS3
                  QPRDRW = .TRUE.
                  IF(COMND3.EQ.'NULL' .OR. COMND3.EQ.'ZERO') THEN
                      QZEROP(NAX,NP) = QVAL
                      IF(QVAL) IZEROP(NAX,NP) = NVAL
                  ELSE
                      IF(QVAL) THEN
                          IGRIDP(1,NAX,NP) = NVAL
                          IGRIDP(2,NAX,NP) = LCMD
                      ELSE
                          IGRIDP(1,NAX,NP) = 0
                      ENDIF
                  ENDIF
3310          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              IF(COMND3.EQ.'NULL' .OR. COMND3.EQ.'ZERO') THEN
                  QZEROS(NAX) = QVAL
                  IF(QVAL) IZEROS(NAX) = NVAL
              ELSE
                  IF(QVAL) THEN
                      IGRIDS(1,NAX) = NVAL
                      IGRIDS(2,NAX) = LCMD
                  ELSE
                      IGRIDS(1,NAX) = 0
                  ENDIF
              ENDIF
          ENDIF
C
C     SET THE NUMBER OF TICK MARKS
C
      ELSEIF(COMND3.EQ.'TICKS') THEN
          THELP = 'SET TICK'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TTICKN,ITICKN,TICKP(1,NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TTICKN,ITICKN,TICKS(1,NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
C
          DO 4100 II=1,NNUM
              IF(RNUM(II).EQ.0.0) RNUM(II) = TICKD(II,NAX)
              IF(QPLOT) THEN
                  DO 4090 NP=NPS1,NPS3
                      QPRDRW = .TRUE.
                      TICKP(II,NAX,NP) = RNUM(II)
                      IF(NNUM.EQ.1 .AND. RNUM(II).EQ.0.0) THEN
                          TICKP(6,NAX,NP) = 0.0
                          TICKP(7,NAX,NP) = 0.0
                      ENDIF
4090              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR. QZERO) THEN
                  TICKS(II,NAX) = RNUM(II)
                  IF(NNUM.EQ.1 .AND. RNUM(II).EQ.0.0) THEN
                      TICKS(6,NAX) = 0.0
                      TICKS(7,NAX) = 0.0
                  ENDIF
              ENDIF
4100      CONTINUE
C
C     CHANGE THE SCALE PARAMETERS
C
      ELSE IF(COMND3.EQ.'SCALE') THEN
          THELP = 'SET SCALE'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TSCALN,ISCALN,SCALP(1,NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              SCALS(8,NAX) = FLOAT(IFNTS(3+2*NAX))
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TSCALN,ISCALN,SCALS(1,NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
C
C         ONLY CHANGE THE SCALE PARAMETERS FOR THE ONE PLOT
C         SPECIFIED, UNLESS IT IS 0
C
          DO 4200 II=1,NNUM
              IF(RNUM(II).EQ.0.0) RNUM(II) = SCALD(II,NAX)
              IF(QPLOT) THEN
                  DO 4190 NP=NPS1,NPS3
                      QPRDRW = .TRUE.
                      SCALP(II,NAX,NP) = RNUM(II)
                      IF(II.EQ.8) IFNTP(3+2*NAX,NP) = NINT(RNUM(II))
4190              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR. QZERO) THEN
                  SCALS(II,NAX) = RNUM(II)
                  IF(II.EQ.8) IFNTS(3+2*NAX) = NINT(RNUM(II))
              ENDIF
4200      CONTINUE
C
C         CHANGE THE MODE FOR THE SCALE
C
      ELSE IF(COMND3.EQ.'MODE') THEN
4250      CONTINUE
          CALL WAITYQ('Give mode or ?: ')
C
C         SEE IF THE MODE IS A NUMBER
C
          LCMD = INTTYQ(.TRUE.,IDELIM)
          IF(LCMD.EQ.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
              CALL QUOTYQ('SET MODE')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 4250
          ENDIF
          IF(IDELIM.GT.0) THEN
              CALL RESTYQ
              LCMD = ICMTYQ(.TRUE.,IDELIM,SCLMOD)
C
              CALL MN_DCK(IDELIM,LCMD,MSMOD,SCLMOD,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
              IF(LCMD.LT.0) GOTO 1000
              IF(IERR.NE.0) GOTO 1000
          ELSE
              CALL MN_NCK(LCMD,IDELIM,IERR)
              IF(IERR.GT.0) GOTO 1000
              LCMD = LCMD + 1
          ENDIF
C
C         CHANGE THE MODE FOR THE SCALE
C
          NMODE = LCMD - 1
C
C         Can also get limits for a log scale
C
          ASLO = 0.0
          ASHI = 0.0
          IF(IDELIM.GE.0 .AND. NMODE.EQ.2) THEN
              KNUM = 0
4300          CONTINUE
              CALL WAITYQ(
     1         'Give lower limit and number of decades to plot: ')
              RVAL = VALTYQ(.TRUE.,IDELIM)
              IF(IDELIM.GT.0 .OR. RVAL.EQ.0.0) THEN
                  IF(KNUM.LT.1) ASLO = 1.0
                  IF(KNUM.LT.2) ASDC = 3.0
                  WRITE(LUNTTO,'('' Error specifying log''
     1             ,'' scale.''
     2             ,/,'' Lower limit set to'',1PG10.3,'',''
     3               ,'' number of decades to'',I4)')
     4             ASLO,NINT(ASDC)
                  GOTO 4350
              ENDIF
C
              KNUM = KNUM + 1
              IF(KNUM.EQ.1) THEN
                  ASLO = RVAL
              ELSE
                  ASDC = RVAL
              ENDIF
              IF(KNUM.LT.2 .AND. IDELIM.EQ.0) GOTO 4300
              IF(KNUM.LT.2) THEN
                  WRITE(LUNTTO,'('' Must give lower limit''
     1             ,'' and number of decades'')')
                  KNUM = 0
                  GOTO 4300
              ENDIF
              IF(ASDC.GT.30.0) THEN
                  WRITE(LUNTTO,'('' Number of decades''
     1             ,'' too large. It will be set to 3'')')
                  ASDC = 3.0
              ENDIF
 4350         CONTINUE
              ASHI = ASLO * 10.0**NINT(ASDC)
          ENDIF
C
          IF(QPLOT) THEN
              DO 4410 NP=NPS1,NPS2
                  QPRDRW = .TRUE.
                  IF(QZERO .OR. IPLTFL(NP).EQ.1 .OR.
     1               IPLTFL(NP).EQ.2) THEN
                      IF(NMODE.EQ.2) THEN
                          QLIMCP(NAX,NP) = .TRUE.
                          ALIMP(1,NAX,NP) = ASLO
                          ALIMP(2,NAX,NP) = ASHI
                      ELSE IF(ISMODP(NAX,NP).EQ.2) THEN
                          QLIMCP(NAX,NP) = .TRUE.
                          ALIMP(1,NAX,NP) = 0.0
                          ALIMP(2,NAX,NP) = 0.0
                      ENDIF
                      ISMODP(NAX,NP) = NMODE
                  ENDIF
4410          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              IF(NMODE.EQ.2) THEN
                  ALIMS(1,NAX) = ASLO
                  ALIMS(2,NAX) = ASHI
              ELSE IF(ISMODS(NAX).EQ.2) THEN
                  ALIMS(1,NAX) = 0.0
                  ALIMS(2,NAX) = 0.0
              ENDIF
              ISMODS(NAX) = NMODE
          ENDIF
C
C     SET THE AXIS LABEL
C
      ELSEIF(COMND3.EQ.'AXIS' .OR. COMND3.EQ.'LABEL') THEN
          THEAD = TTAX(NAX) // ' axis label'
          IF(QPLOT) THEN
              CALL MN_ETX(0,IDELIM,THEAD,TLABLP(NAX,NPS1),TXT1,IERR)
          ELSE
              CALL MN_ETX(0,IDELIM,THEAD,TLABLS(NAX),TXT1,IERR)
          ENDIF
C
          IF(QPLOT) THEN
              DO 4610 NP=NPS1,NPS3
                  QPRDRW = .TRUE.
                  TLABLP(NAX,NP) = TXT1
                  ILABLP(NAX,NP) = MNLLEN(TXT1)
4610          CONTINUE
          ENDIF
C
          IF(.NOT.QPLOT .OR. QZERO) THEN
              TLABLS(NAX) = TXT1
              ILABLS(NAX) = MNLLEN(TXT1)
          ENDIF
C
C         GET NEW LABEL POSITION
C
          THELP = 'SET LABEL'
          THEAD = 'Label position is with respect to centre of axis'
          IF(QPLOT) THEN
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TLABLN,ILABLN,ALABLP(1,NAX,NPS1)
     1         ,NNUM,RNUM,IERR)
          ELSE
              ALABLS(6,NAX) = FLOAT(IFNTS(4+2*NAX))
              CALL MN_ENM(IDELIM,THELP,THEAD,10
     1         ,TLABLN,ILABLN,ALABLS(1,NAX)
     1         ,NNUM,RNUM,IERR)
          ENDIF
C
          DO 4630 II=1,NNUM
              IF(RNUM(II).EQ.0.0) RNUM(II) = ALABLD(II,NAX)
              IF(QPLOT) THEN
                  DO 4620 NP=NPS1,NPS3
                      QPRDRW = .TRUE.
                      ALABLP(II,NAX,NP) = RNUM(II)
                      IF(II.EQ.6) IFNTP(4+2*NAX,NP) = NINT(RNUM(II))
4620              CONTINUE
              ENDIF
C
              IF(.NOT.QPLOT .OR. QZERO) THEN
                  ALABLS(II,NAX) = RNUM(II)
                  IF(II.EQ.6) IFNTS(4+2*NAX) = NINT(RNUM(II))
              ENDIF
4630      CONTINUE
      ENDIF
      GOTO 1000
C
 9000 CONTINUE
      END
