      SUBROUTINE M_PSMOO(RBUF,NDIMN,NWPPTI,NPNTI,NDIM
     + ,RBUG,NWPPTO,NPNTO)
C
C-----------------------------------------------------------------------
C
C     Smooths the input data using a spline curve
C
C     Called by MN_PLT
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnplt.inc"
C
      INTEGER MPNTMX
      PARAMETER (MPNTMX=2500)
      INTEGER MV
      PARAMETER (MV=1)
#include "mnscr.inc"
      DOUBLE PRECISION WX(0:MPNTMX),WY(0:MPNTMX,MV)
     + ,WA(MPNTMX,MV),WB(MPNTMX,MV),WC(MPNTMX,MV),WD(MPNTMX,MV)
      EQUIVALENCE(SCRATCH( 4*MPNTMX+1),WX(0))
      EQUIVALENCE(SCRATCH( 6*(MPNTMX+1)+1),WY(0,1))
      EQUIVALENCE(SCRATCH( 8*(MPNTMX+1)+1),WA(1,1))
      EQUIVALENCE(SCRATCH(10*(MPNTMX+1)+1),WB(1,1))
      EQUIVALENCE(SCRATCH(12*(MPNTMX+1)+1),WC(1,1))
      EQUIVALENCE(SCRATCH(14*(MPNTMX+1)+1),WD(1,1))
C
      REAL RBUF(*),RBUG(*)
      INTEGER NDIMN,NWPPTI,NPNTI,NDIM,NWPPTO,NPNTO
C
      INTEGER I,J,NPTR,NPPT,MODE
      DOUBLE PRECISION WXX,WYY,WDX
C
C     Get the data in the form I need
C
      NPTR = 0 - NWPPTI + 1
      DO I=1,NPNTI
          NPTR = NPTR + NWPPTI
          WX(I-1)   = DBLE(RBUF(NPTR))
          WY(I-1,1) = DBLE(RBUF(NPTR+1))
      ENDDO
C
C     Fix the number of points per interval
C
      NPPT = MAX0(1,NFPNT / NPNTI)
C
C     Calculate the spline curves
C
      MODE = 0
      CALL DCSPLN(NPNTI-1,WX,MV,WY,MPNTMX,MODE,WA,WB,WC,WD)
C
C     Now fill the output arrays
C
      NWPPTO = 2
      NPTR = 0 - NWPPTO + 1
      DO I=1,NPNTI-1
          WDX = (WX(I) - WX(I-1)) / DFLOAT(NPPT)
          DO J=1,NPPT
              WXX = WX(I-1) + DFLOAT(J-1)*WDX
              WYY = WA(I,1) + WB(I,1)*(WXX-WX(I-1)) +
     +                        WC(I,1)*(WXX-WX(I-1))**2 +
     +                        WD(I,1)*(WXX-WX(I-1))**3
              NPTR = NPTR + NWPPTO
              RBUG(NPTR+0) = SNGL(WXX)
              RBUG(NPTR+1) = SNGL(WYY)
          ENDDO
      ENDDO
      NPTR = NPTR + NWPPTO
      RBUG(NPTR+0) = SNGL(WX(NPNTI-1))
      RBUG(NPTR+1) = SNGL(WY(NPNTI-1,1))
C
      NPNTO = NPPT*(NPNTI-1) + 1
C
      END
