      SUBROUTINE M_EPRS(NMODE,NVAR,TVAR,IDELIM,IERR)
C
C-----------------------------------------------------------------------
C
C     Parses either an expression for a variable to project onto
C     or an expression for a cut or for a weight for projection.
C     The expression must either be in parentheses or contain no
C     blanks.
C     NMODE = -1 means the expression can have a condition following it
C     NMODE =  0 means just get the expression
C     NMODE =  1 means parse it as a variable
C     NMODE =  2 means parse it as a cut
C     NMODE =  3 means parse it as a weight
C
C     Called by MN_PRJ, MN_CUT, M_IFPRS
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mncmd.inc"
#include "mnprj.inc"
#include "mncut.inc"
#include "mnlun.inc"
C
      CHARACTER*(*) TVAR
C
      CHARACTER*255 TXT1,TXT2,TXTR
      LOGICAL QPASS
C
      IERR = 0
      NVAR = 0
      TVAR = ' '
      IF(NMODE.EQ.1 .AND. NVEXPR.GT.MVEXPR) THEN
          IERR = 1
          CALL MN_ERR('M_EPRS','No more room for expressions')
          GOTO 9000
      ELSEIF(NMODE.EQ.2 .AND. NCEXPR.GT.MCUTMX) THEN
          IERR = 1
          CALL MN_ERR('M_EPRS','No more room for cut expressions')
          GOTO 9000
      ELSEIF(NMODE.EQ.3 .AND. NWEXPR.GT.MWEXPR) THEN
          IERR = 1
          CALL MN_ERR('M_EPRS','No more room for weight expressions')
          GOTO 9000
      ENDIF
C
C     Get the rest of the typscn string and convert it to upper case
C
      TXTR = ' '
      CALL WAITYQ('Give expression: ')
      ISTR = ISTRNQ(.TRUE.,TXT1,NCHR1)
      IF(NCHR1.LE.0) GOTO 9000
      CALL CLTOU(TXT1)
C
C     If the string starts with ( then look for the matching end
C     Strip the string of parentheses as parser does not like them at start
C
      N1 = 1
      IF(TXT1(1:1).EQ.'(') THEN
C          N1 = 2
          NPAR = 0
          LENT = 0
          DO 1000 I=1,NCHR1
              IF(TXT1(I:I).EQ.'(') NPAR = NPAR + 1
              IF(TXT1(I:I).EQ.')') NPAR = NPAR - 1
              IF(NPAR.EQ.0) THEN
C                  LENT = I - 1
                  LENT = I
                  LENR = I + 1
                  GOTO 1010
              ELSEIF(NPAR.LT.0) THEN
                  TXTERR = 'Parentheses are not balanced: ' //
     +             TXT1(1:I)
                  CALL MN_ERR('M_EPRS',TXTERR)
                  IERR = 1
                  GOTO 9000
              ENDIF
1000      CONTINUE
          IF(NPAR.NE.0) THEN
              TXTERR = 'Parentheses are not balanced: ' //
     +         TXT1(1:NCHR1)
              CALL MN_ERR('M_EPRS',TXTERR)
              IERR = 1
              GOTO 9000
          ENDIF
1010      CONTINUE
C
          call m_lupc(txt1(n1:lent),txt2)
C
C     If we are parsing only, then this is a cut or an IF statement.
C     Locate a blank
C     Look for strings .GT., .LT., .GE., .LE., .EQ., .NE.
C     Look for <,>,=
C     Find the lowest non-zero value.
C     Pass back the string up to the start of these characters.
C
      ELSEIF(NMODE.EQ.-1) THEN
          IND1 = 0
*ICB          IND1 = INDEX(TXT1,' ')
          IF(IND1.LE.0) IND1 = NCHR1 + 1
          IND2 = NCHR1 + 1
          DO 2000 I=1,6
              IND = INDEX(TXT1,CUTNAM(I))
              IF(IND.GT.0) IND2 = MIN0(IND,IND2)
2000      CONTINUE
          IND3 = NCHR1 + 1
          DO 2100 I=1,6
              LEN2 = LENOCC(CUTNM2(I))
              IND = INDEX(TXT1,CUTNM2(I)(1:LEN2))
              IF(IND.GT.0) IND3 = MIN0(IND,IND3)
2100      CONTINUE
          LENT = MIN0(IND1,IND2,IND3) - 1
          LENR = LENT + 1
          if(lent.le.0) then
              txterr = 'WARNING - No expression given'
              call m_emsg('M_EPRS',txterr)
              txterr = 'The expression will be set to 0'
              call m_emsg('M_EPRS',txterr)
              txt2 = '0'
          else
              CALL M_LUPC(TXT1(N1:LENT),TXT2)
          endif
      ELSE
          IND = INDEX(TXT1,' ')
          IF(IND.GT.0) THEN
              LENT = IND - 1
          ELSE
              LENT = NCHR1
          ENDIF
          LENR = LENT + 1
          CALL M_LUPC(TXT1(N1:LENT),TXT2)
      ENDIF
      TVAR = TXT2
      IF(LENR.LT.NCHR1) TXTR = TXT1(LENR:)
C
C     Parse this expression
C
      IF(NMODE.EQ.1) THEN
          NV = NVEXPR + 1
          CALL M_PRSE(.FALSE.,LVEXPR(NV),TXT2
     +     ,IVETYP(1,NV),IVETP(1,NV),IVETF(1,NV),IVETV(1,1,NV),QPASS)
          IF(QPASS) THEN
              NVEXPR = NV
              TVEXPR(NVEXPR) = TXT2
              NVAR   = -NVEXPR
          ELSE
              IERR = 1
          ENDIF
      ELSEIF(NMODE.EQ.2) THEN
          NC = NCEXPR + 1
          CALL M_PRSE(.FALSE.,LCEXPR(NC),TXT2
     +     ,ICETYP(1,NC),ICETP(1,NC),ICETF(1,NC),ICETV(1,1,NC),QPASS)
          IF(QPASS) THEN
              NCEXPR = NC
              NVAR   = -NCEXPR
          ELSE
              IERR = 1
          ENDIF
      ELSEIF(NMODE.EQ.3) THEN
          NW = NWEXPR + 1
          CALL M_PRSE(.FALSE.,LWEXPR(NW),TXT2
     +     ,IWETYP(1,NW),IWETP(1,NW),IWETF(1,NW),IWETV(1,1,NW),QPASS)
          IF(QPASS) THEN
              NWEXPR = NW
              TWEXPR(NWEXPR) = TXT2
              NVAR   = -NWEXPR
          ELSE
              IERR = 1
          ENDIF
      ENDIF

9000  CONTINUE
C
C     Put the rest of the string back into the TYPSCN buffer
C     or clear it out if there is nothing left
C
      IF(IERR.EQ.0) THEN
          LENR = LENOCC(TXTR)
          IF(LENR.GT.0) THEN
              CALL QUOTYQ(TXTR(1:LENR))
              IDELIM = 0
          ELSE
              CALL ZERTYQ('.FALSE.')
              IDELIM = -1
          ENDIF
      ENDIF
C
      END
