# Monitor sets up an action that keeps the elements of
# the global array status updated from the mud. The pattern
# of the action is mud specific.
# It also sets up a trace on hp that calls hp_check.

proc monitor {args} {
    global status

    set syntax {
	on {}
	off {}
    }
    
    switch -exact -- [check -opts monitor $syntax $args] {
	on {

	    action set {^Hp: %d*Gp: %d*Xp: %d} {
		global status
    
		set status(hp) $1
		set status(gp) $2
		set status(xp) $3
	    }

	    #set status(hp) 0
	    trace variable status(hp) w hp_check
	} off {
	    action delete -exact -- {^Hp: %d Gp: %d Xp: %d}
	    trace vdelete status(hp) w hp_check
	}
    }

    return
}  

# Called when the variable hp is changed to determine if
# any action should be taken. Could be overwritten
# in a char init file to do something else.

proc hp_check {args} {
    global status

    # Bail out if hp is low.
    if {$status(hp) < 500} {
	write quit
    }
}

# Here's an example using the Tk toolkit.
# tk_monitor toggles a window that keeps track
# of your hp, gp, and xp using the monitor procedure
# defined above.

proc tk_monitor {} {
    loadTk

    if {[winfo exists .monitor]} {
	monitor off
	destroy .monitor
	return
    }

    monitor on
    toplevel .monitor
    wm title .monitor Monitor

    pack [label .monitor.lhp -text Hp:] \
	    [label .monitor.hp -textvariable status(hp)] \
	    [label .monitor.lgp -text Gp:] \
	    [label .monitor.gp -textvariable status(gp)] \
	    [label .monitor.lxp -text Xp:] \
	    [label .monitor.xp -textvariable status(xp)] -side left 
}
