// processfun.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "data.h"
#include "processfun.h"
#include "request.h"
#include "requester.h"
#include "range.h"
#include "valuerequester.h"

int
SimpleFunction::doApply(Data *data) {
	return data->apply(*this);
}

//********

SingleFactorFunction::SingleFactorFunction(Data* d, double defaultVal)
	: SimpleFunction(d), factor(defaultVal) {}

//**********

Scaler::Scaler(Data* d, double val) : SingleFactorFunction(d, val) {
	initialize();
}

Scaler::Scaler(Data* d) : SingleFactorFunction(d, 1.0) {}

Requester *
Scaler::createRequester() {
	return new ValueRequester<double>("Scale Values in Selected Region:",
	                                 "Amplitude Factor:", factor);
}

Modifier *
Scaler::create(DataEditor* de) {
	return nil;
}

Modifier *
Scaler::createUnDo() {
	return (factor != 0.0) ? new Offset(target(), 1.0/factor) : nil;
}

//**********

Offset::Offset(Data* d, double val) : SingleFactorFunction(d, val) {
	initialize();
}

Offset::Offset(Data* d) : SingleFactorFunction(d, 0.0) {}

Requester *
Offset::createRequester() {
	return new ValueRequester<double>("Offset Selected Region:",
	                                 "Offset By:", factor);
}

Modifier *
Offset::create(DataEditor* de) {
	return nil;
}

Modifier *
Offset::createUnDo() {
	return new Offset(target(), -factor);
}

//**********

Modifier *
Eraser::create(DataEditor* de) {
	return nil;
}

Modifier *
Eraser::createUnDo() {
	return nil;
}

