/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

/*
 * 2 Sequences aligned, fact storage
 * AlignedDualSeq manages the data produced by the alignement routines. Two
 *  sequences have been aligned and are stored in an ADS object.
 * 
 * The ADSFacts object is a smaller storage unit for the plain facts,
 *  smaller and therefore less memory consuming (454 data *sigh*)
 *
 */

// 	$Id$	

#ifndef lint
static char vcid[] = "$Id$";
#endif /* lint */

#include "adsfacts.H"

#include "errorhandling/errorhandling.H"

ostream & operator<<(ostream & ostr, const AlignedDualSeqFacts &adsf)
{
  (void) vcid;

  ostr << "ID1:" << adsf.ADSF_id1 << '\n';
  ostr << "ID2:" << adsf.ADSF_id2 << '\n';
  ostr << "Direction1: " << static_cast<int16>(adsf.getSequenceDirection(adsf.ADSF_id1)) << '\n';
  ostr << "Direction2: " << static_cast<int16>(adsf.getSequenceDirection(adsf.ADSF_id2)) << '\n';
  ostr << "Delta Seq2 to Seq1: " << adsf.ADSF_delta << '\n';
  ostr << "ID1 right delta: " << adsf.ADSF_id1_rightdelta << '\n';
  ostr << "ID2 right delta: " << adsf.ADSF_id2_rightdelta << '\n';
  ostr << "Overlap length: " << adsf.getOverlapLen() << '\n';
  ostr << "Total length: " << adsf.ADSF_total_len << '\n';
  ostr << "Score ratio: " << static_cast<uint16>(adsf.ADSF_score_ratio) << '\n';
  return ostr;
}

void AlignedDualSeqFacts::serialiseOut(ofstream & ostr)
{
  ostr << ADSF_id1;
  ostr << '\t' << ADSF_id2;
  ostr << '\t' << static_cast<int16>(getSequenceDirection(ADSF_id1));
  ostr << '\t' << static_cast<int16>(getSequenceDirection(ADSF_id2));
  ostr << '\t' << ADSF_delta;
  ostr << '\t' << ADSF_id1_rightdelta;
  ostr << '\t' << ADSF_id2_rightdelta;
  ostr << '\t' << getOverlapLen();
  ostr << '\t' << ADSF_total_len;
  ostr << '\t' << static_cast<uint16>(ADSF_score_ratio);

  return;
}

void AlignedDualSeqFacts::serialiseIn(ifstream & istr)
{
  istr >> ADSF_id1;
  istr >> ADSF_id2;

  ADSF_id1and2_directions=0;
  // no idea why I can't directly stream into an int8 *sigh*
  int16 tmp;
  istr >> tmp;
  if(tmp>0) ADSF_id1and2_directions=1;
  istr >> tmp;
  if(tmp>0) ADSF_id1and2_directions|=2;
  istr >> ADSF_delta;
  istr >> ADSF_id1_rightdelta;
  istr >> ADSF_id2_rightdelta;
  // ADSF_overlap_len has been thrown out as it
  //  can be computed
  //istr >> ADSF_overlap_len;
  istr >> tmp;
  istr >> ADSF_total_len;
  istr >> tmp;
  ADSF_score_ratio=static_cast<int8>(tmp);

  //cout << *this;
  return;
}


int8 AlignedDualSeqFacts::getSequenceDirection(int32 id) const
{
  FUNCSTART("int8 AlignedDualSeqFacts::getSequenceDirection(int32 id) const");
  if(id==ADSF_id1){
    FUNCEND();
    if(ADSF_id1and2_directions & 0x1) return 1;
    return -1;
  }else if(id==ADSF_id2){
    FUNCEND();
    if(ADSF_id1and2_directions & 0x2) return 1;
    return -1;
  }else{
    throw Notify(Notify::FATAL, THISFUNC, "ID not in alignment.");
  }
}

int32 AlignedDualSeqFacts::getOtherID(int32 id) const
{
  FUNCSTART("uint32 ADS::getOtherID(uint32 id)");
  //if(!ADS_valid){
  //  throw Notify(Notify::FATAL, THISFUNC, " Object not initialised.");
  //}
  if(id==ADSF_id1){
    FUNCEND();
    return ADSF_id2;
  }else if(id==ADSF_id2){
    FUNCEND();
    return ADSF_id1;
  }else{
    throw Notify(Notify::FATAL, THISFUNC, "ID not in alignment.");
  }
}


uint32 AlignedDualSeqFacts::getOffsetInAlignment(int32 id) const
{
  FUNCSTART("uint32 AlignedDualSeqFacts::getOffsetInAlignment(int32 id) const");
  //if(!ADS_valid){
  //  throw Notify(Notify::FATAL, THISFUNC, " Object not initialised.");
  //}
  if(id==ADSF_id1){
    FUNCEND();
    return 0;
  }else if(id==ADSF_id2){
    FUNCEND();
    return ADSF_delta;
  }else{
    throw Notify(Notify::FATAL, THISFUNC, "ID not in alignment.");
  }
}

uint32 AlignedDualSeqFacts::getRightOffsetInAlignment(int32 id) const
{
  FUNCSTART("uint32 ADS::getOffsetInAlignment(int32 id)");
  //if(!ADS_valid){
  //  throw Notify(Notify::FATAL, THISFUNC, " Object not initialised.");
  //}
  if(id==ADSF_id1){
    FUNCEND();
    return ADSF_id1_rightdelta;
  }else if(id==ADSF_id2){
    FUNCEND();
    return ADSF_id2_rightdelta;
  }else{
    throw Notify(Notify::FATAL, THISFUNC, "ID not in alignment.");
  }
}

void AlignedDualSeqFacts::publicinit(int32  id1, int32  id2, uint16 delta, uint16 id1_rightdelta, uint16 id2_rightdelta, uint16 total_len, int8 id1_direction, int8   id2_direction, int8 score_ratio)
{
  FUNCSTART("uint32ADS::getOffsetInAlignment(int32id)");
  ADSF_id1=id1;
  ADSF_id2=id2;
  ADSF_delta=delta;
  ADSF_id1_rightdelta=id1_rightdelta;
  ADSF_id2_rightdelta=id2_rightdelta;
  ADSF_total_len=total_len;
  
  ADSF_id1and2_directions=0;
  if(id1_direction>0) ADSF_id1and2_directions=1;
  if(id2_direction>0) ADSF_id1and2_directions|=2;
  ADSF_score_ratio=score_ratio;
  
  FUNCEND();
}


//uint32 AlignedDualSeqFacts::getOverlapLen() const
//{
//  if(ADSF_total_len-ADSF_delta-ADSF_id1_rightdelta-ADSF_id2_rightdelta != ADSF_overlap_len){
//    cout << "Argh, ADFS len violation.\n";
//    cout << ADSF_total_len 
//	 << " - " << ADSF_delta 
//	 << " - " << ADSF_id1_rightdelta 
//	 << " - " << ADSF_id2_rightdelta 
//	 << " != " << ADSF_overlap_len << " ???\n";
//    abort();
//  }
//  return ADSF_overlap_len;
//};
