; $Id: listrev.scm,v 1.4 2008/01/25 13:30:21 logik Exp $
(if (not (assoc "nat" ALGEBRAS))
    (myerror "First execute (libload \"nat.scm\")"))

(display "loading listrev.scm ...") (newline)

; Notice that listrev.scm and list.scm cannot be loaded together.
; Reason: In :0::1::2::3 the ":" is a prefix-op (for listrev.scm), but
; in 3::2::1::0: the ":" is a postfix-op (for list.scm).

(add-param-alg "list" 'prefix-typeop
	       '("Nil" "list")
	       '("Cons" "list=>alpha1=>list"))

; Infix notation allowed (and type parameters omitted) for binary 
; constructors, as follows.  This would also work for prefix notation.
; Example: :: for Cons.  :z::y::x
; Here : is prefix for z

(add-token
 "::" 'add-op ;hence left associative
 (lambda (xs x)
   (let ((type (term-to-type x))
	 (listtype (term-to-type xs)))
     (if (and (alg-form? listtype)
	      (string=? "list" (alg-form-to-name listtype))
	      (equal? type (car (alg-form-to-types listtype))))
	 (mk-term-in-app-form
	  (make-term-in-const-form
	   (let* ((constr (constr-name-to-constr "Cons"))
		  (tvars (const-to-tvars constr))
		  (subst (make-substitution tvars (list type))))
	     (const-substitute constr subst #f)))
	  xs x)
	 (myerror "parse error" "types do not fit for" listtype "::" type)))))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "Cons"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'add-op "::"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-token
 ":" 'prefix-op
 (lambda (x)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((constr (constr-name-to-constr "Cons"))
	    (tvars (const-to-tvars constr))
	    (subst (make-substitution tvars (list (term-to-type x)))))
       (const-substitute constr subst #f)))
    (make-term-in-const-form
     (let* ((constr (constr-name-to-constr "Nil"))
	    (tvars (const-to-tvars constr))
	    (subst (make-substitution tvars (list (term-to-type x)))))
       (const-substitute constr subst #f)))
    x)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let* ((op (term-in-app-form-to-final-op x))
	      (args (term-in-app-form-to-args x))
	      (revargs (reverse args)))
	 (if (and (term-in-const-form? op)
		  (string=? "Cons" (const-to-name
				    (term-in-const-form-to-const op)))
		  (= 2 (length args))
		  (term-in-const-form? (cadr revargs))
		  (string=? "Nil" (const-to-name
				   (term-in-const-form-to-const
				    (cadr revargs)))))
	     (list 'prefix-op ":" (term-to-token-tree (car revargs)))
	     #f))
       #f)))

(add-program-constant
 "ListAppend" (py "list alpha=>list alpha=>list alpha") t-deg-one)

(add-token
 ":+:" 'mul-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListAppend"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type x))
	    (type (car (alg-form-to-types listtype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListAppend"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'mul-op ":+:"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule
 (pt "(list alpha)_1:+:(Nil alpha)")
 (pt "(list alpha)_1"))

(add-computation-rule
 (pt "(list alpha)_1:+:((list alpha)_2::alpha_3)")
 (pt "(list alpha)_1:+:(list alpha)_2::alpha_3"))

; "ListAppendNil"
(set-goal (pf "all list alpha^.STotal list alpha^ ->
                Equal((Nil alpha):+:list alpha^)list alpha^"))
(ind)
(use "Eq-Refl")
(assume "list alpha^" "alpha^" "[STotal]" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "ListAppendNil")

(add-rewrite-rule
 (pt "(Nil alpha):+:list alpha")
 (pt "list alpha"))


(add-program-constant "ListLength" (py "list alpha=>nat") t-deg-one)

(add-token
 "Lh" 'prefix-op 
 (lambda (x) (make-term-in-app-form
	      (make-term-in-const-form
	       (let* ((const (pconst-name-to-pconst "ListLength"))
		      (tvars (const-to-tvars const))
		      (listtype (term-to-type x))
		      (type (car (alg-form-to-types listtype)))
		      (subst (make-substitution tvars (list type))))
		 (const-substitute const subst #f)))
	      x)))

(add-display
 (py "nat")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-op x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListLength"
			    (const-to-name (term-in-const-form-to-const op))))
	     (list 'prefix-op "Lh"
		   (term-to-token-tree (term-in-app-form-to-arg x)))
	     #f))
       #f)))

(add-computation-rule (pt "Lh(Nil alpha)") (pt "Zero"))
(add-computation-rule (pt "Lh(list alpha::alpha)") (pt "Succ Lh list alpha"))


; "LhAppend"
(set-goal (pf "all (list alpha)^1,(list alpha)^2.STotal (list alpha)^2 ->
                Equal(Lh((list alpha)^1:+:(list alpha)^2))
                     (Lh (list alpha)^1+Lh (list alpha)^2)"))
(assume "(list alpha)^1")
(ind)
(ng)
(use "Eq-Refl")
(assume "(list alpha)^2" "alpha^" "[STotal]" "IH")
(ng)
(assert
 (pf "all nat^1,nat^2.Equal nat^1 nat^2 -> Equal(Succ nat^1)(Succ nat^2)"))
 (assume "nat^1" "nat^2" "H1")
 (use-with "Eq-Compat"
	   (py "nat")
	   (make-cterm (pv "nat^") (pf "Equal(Succ nat^1)(Succ nat^)"))
	   (pt "nat^1") (pt "nat^2") "H1" "?")
 (use "Eq-Refl")
(assume "EqCompatSucc")
(use "EqCompatSucc")
(use "IH")
(save "LhAppend")

(add-rewrite-rule (pt "Lh((list alpha)^1:+:(list alpha)_2)")
		  (pt "Lh(list alpha)^1+Lh(list alpha)_2"))


; Now for projection, ListProj, which is partial.  We use Inhab for
; the rule (Nil alpha)__n -> (Inhab alpha)

(add-program-constant
 "ListProj" (py "list alpha=>nat=>alpha") t-deg-zero 'const 1)

(add-token
 "__" 'mul-op ;hence left associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListProj"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type x))
	    (type (car (alg-form-to-types listtype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListProj"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'mul-op "__"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-token
 "Proj" 'prefix-op
 (lambda (x) (make-term-in-app-form
	      (make-term-in-const-form
	       (let* ((const (pconst-name-to-pconst "ListProj"))
		      (tvars (const-to-tvars const))
		      (listtype (term-to-type x))
		      (type (car (alg-form-to-types listtype)))
		      (subst (make-substitution tvars (list type))))
		 (const-substitute const subst #f)))
	      x)))

(add-display
 (py "nat=>alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListProj"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 1 (length args)))
	     (list 'prefix-op "Proj"
		   (term-to-token-tree (car args)))
	     #f))
       #f)))

(add-computation-rule
 (pt "Proj(Nil alpha)")
 (pt "[nat](Inhab alpha)"))

(add-computation-rule
 (pt "Proj(list alpha::alpha)")
 (pt "[n][if (n<Lh list alpha)  (list alpha__n)
             [if (n=Lh list alpha) alpha (Inhab alpha)]]"))

; (pp (nt (pt "(:0::1::2::3)__1")))
; (pp (nt (pt "(:True::True::False::True)__1")))
; (pp (nt (pt "(Nil boole)__27")))


(add-program-constant
 "ListFBar" (py "(nat=>alpha)=>nat=>list alpha") t-deg-one)

(add-token
 "fbar" 'pair-op ;hence right associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListFBar"))
	    (tvars (const-to-tvars const))
	    (fcttype (term-to-type x))
	    (type (car (alg-form-to-types fcttype)))
	    (subst (make-substitution tvars (list type))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListFBar"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'pair-op "fbar"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule (pt "nat=>alpha fbar 0") (pt "(Nil alpha)"))

(add-computation-rule (pt "nat=>alpha fbar Succ nat")
		      (pt "(nat=>alpha fbar nat)::(nat=>alpha nat)"))

; (pp (nt (pt "Succ fbar 4")))
; (pp (nt (pt "([n]n+3)fbar 4")))

; We use (a bar n) as notation for ((Proj a)fbar n).  A consequence is
; that (a bar n) is not syntactically total.

(add-token
 "bar" 'add-op ;hence left associative
 (lambda (a n)
   (let* ((listtype (term-to-type a))
	  (type (car (alg-form-to-types listtype)))
	  (projconst (let* ((const (pconst-name-to-pconst "ListProj"))
			    (tvars (const-to-tvars const))
			    (subst (make-substitution tvars (list type))))
		       (const-substitute const subst #f)))
	  (fbarconst (let* ((const (pconst-name-to-pconst "ListFBar"))
			    (tvars (const-to-tvars const))
			    (subst (make-substitution tvars (list type))))
		       (const-substitute const subst #f))))
     (mk-term-in-app-form
      (make-term-in-const-form fbarconst)
      (make-term-in-app-form (make-term-in-const-form projconst)
			     a)
      n))))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if
	  (and (term-in-const-form? op)
	       (string=? "ListFBar" 
			 (const-to-name (term-in-const-form-to-const op)))
	       (= 2 (length args)))
	  (let* ((arg1 (car args))
		 (arg1op (term-in-app-form-to-final-op arg1))
		 (arg1args (term-in-app-form-to-args arg1)))
	    (if
	     (and (term-in-const-form? arg1op)
		  (string=? "ListProj"
			    (const-to-name
			     (term-in-const-form-to-const arg1op)))
		  (= 1 (length arg1args)))
	     (list 'add-op "bar"
		   (term-to-token-tree (car arg1args))
		   (term-to-token-tree (cadr args)))
	     #f))
	  #f))
       #f)))

; (pp (pt "list boole bar nat"))
; (pp (pt "Proj list boole"))

(quote (begin

(set-goal (pf "all nat=>alpha^,nat.Lh(nat=>alpha^ fbar nat)=nat"))
(assume "nat=>alpha^")
(ind)
(use "Truth-Axiom")
(assume "n" "IHn")
(use "IHn")

)) ;matches quote

(add-rewrite-rule (pt "Lh(nat=>alpha^ fbar nat)") (pt "nat"))


(add-program-constant
 "ListMap" (py "(alpha1=>alpha2)=>list alpha1=>list alpha2") t-deg-one)

(add-token
 "map" 'pair-op ;hence right associative
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form
     (let* ((const (pconst-name-to-pconst "ListMap"))
	    (tvars (const-to-tvars const))
	    (listtype (term-to-type y))
	    (type1 (car (alg-form-to-types listtype)))
	    (type2 (arrow-form-to-val-type (term-to-type x)))
	    (subst (make-substitution tvars (list type1 type2))))
       (const-substitute const subst #f)))
    x y)))

(add-display
 (py "list alpha")
 (lambda (x)
   (if (term-in-app-form? x)
       (let ((op (term-in-app-form-to-final-op x))
	     (args (term-in-app-form-to-args x)))
	 (if (and (term-in-const-form? op)
		  (string=? "ListMap"
			    (const-to-name (term-in-const-form-to-const op)))
		  (= 2 (length args)))
	     (list 'pair-op "map"
		   (term-to-token-tree (car args))
		   (term-to-token-tree (cadr args)))
	     #f))
       #f)))

(add-computation-rule
 (pt "alpha1=>alpha2 map(Nil alpha1)")
 (pt "(Nil alpha2)"))

(add-computation-rule
 (pt "alpha1=>alpha2 map (list alpha1)_1::alpha1")
 (pt "(alpha1=>alpha2 map(list alpha1)_1)::alpha1=>alpha2 alpha1"))

; (pp (nt (pt "Pred map:2::3::4")))

; "LhMap"
(set-goal (pf "all alpha1=>alpha2,list alpha1
                Lh(alpha1=>alpha2 map list alpha1)=Lh list alpha1"))
(assume "alpha1=>alpha2")
(ind)
(use "Truth-Axiom")
(assume "list alpha1" "alpha1" "IH")
(use "IH")
(save "LhMapPartial")

; "LhMapPartial"
(set-goal (pf "all alpha1=>alpha2^,list alpha1^.STotal list alpha1^ ->
                Lh(alpha1=>alpha2^ map list alpha1^)=Lh list alpha1^"))
(assume "alpha1=>alpha2^")
(ind)
(use "Truth-Axiom")
(assume "list alpha1^" "alpha1^" "[STotal]" "IH")
(use "IH")
(save "LhMap")

; "MapAppend"
(set-goal (pf "all alpha1=>alpha2,(list alpha1)_1,(list alpha1)_2
               Equal(alpha1=>alpha2 map ((list alpha1)_1:+:(list alpha1)_2))
               ((alpha1=>alpha2 map (list alpha1)_1):+:
                (alpha1=>alpha2 map (list alpha1)_2))"))
(assume "alpha1=>alpha2" "(list alpha1)_1")
(ind)
(ng)
(use-with "Eq-Refl" (py "list alpha2")
	  (pt "alpha1=>alpha2 map(list alpha1)_1"))
(assume "list alpha1" "alpha1" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "MapAppend")

; "MapAppendPartial"
(set-goal (pf "all alpha1=>alpha2^,(list alpha1)^1,(list alpha1)^2.
               STotal (list alpha1)^2 ->
               Equal(alpha1=>alpha2^ map ((list alpha1)^1:+:(list alpha1)^2))
               ((alpha1=>alpha2^ map (list alpha1)^1):+:
                (alpha1=>alpha2^ map (list alpha1)^2))"))
(assume "alpha1=>alpha2^" "(list alpha1)^1")
(ind)
(ng)
(use-with "Eq-Refl" (py "list alpha2")
	  (pt "alpha1=>alpha2^ map(list alpha1)^1"))
(assume "(list alpha1)^" "alpha1^" "[STotal]" "IH")
(ng)
(simp "IH")
(use "Eq-Refl")
(save "MapAppendpartial")

; "MapFbar"
(set-goal
 (pf "all nat=>alpha1^,alpha1=>alpha2^,nat 
       Equal(alpha1=>alpha2^ map nat=>alpha1^ fbar nat)
            (([nat]alpha1=>alpha2^(nat=>alpha1^ nat))fbar nat)"))
(assume "nat=>alpha1^" "alpha1=>alpha2^")
(ind)
(use "Eq-Refl")
(assume "nat" "IH")
(ng #t)
(simp "IH")
(use "Eq-Refl")
(save "MapFbar")

(add-rewrite-rule
 (pt "alpha1=>alpha2^ map nat=>alpha1^ fbar nat")
 (pt "([nat]alpha1=>alpha2^(nat=>alpha1^ nat))fbar nat"))


; We add a bounded universal quantifier

(add-program-constant
 "AllBList" (py "nat=>(list boole=>boole)=>boole") t-deg-one)

(add-computation-rule (pt "AllBList 0 list boole=>boole")
		      (pt "(list boole=>boole)(Nil boole)"))
(add-computation-rule
 (pt "AllBList(Succ nat)list boole=>boole")
 (pt "(AllBList nat([list boole]list boole=>boole(list boole::True)))andb
      (AllBList nat([list boole]list boole=>boole(list boole::False)))"))

; "ListLhZero"
(set-goal
 (pf "all list alpha^.STotal list alpha^ -> Lh list alpha^ =0 ->
                      Equal list alpha^(Nil alpha)"))
(cases)
(assume "H")
(use "Eq-Refl")
(assume "list alpha^" "alpha^" "H" "IH")
(use "Efq")
(use "IH")
(save "ListLhZero")

; "AllBListIntro"
(set-goal
 (pf "all nat,list boole=>boole^.
       (all list boole^.Lh list boole^ =nat -> 
                        list boole=>boole^ list boole^) -> 
       AllBList nat list boole=>boole^"))
(ind)
(assume "list boole=>boole^")
(ng)
(strip)
(use 1)
(use "Truth-Axiom")
(assume "nat" "IH" "list boole=>boole^" "H")
(ng)
(split)
(use "IH")
(ng)
(assume "list boole^" "Lh list boole^ =nat")
(use "H")
(use "Lh list boole^ =nat")
(use "IH")
(ng)
(assume "list boole^" "Lh list boole^ =nat")
(use "H")
(use "Lh list boole^ =nat")
(save "AllBListIntro")

; "AllBListElim"
(set-goal
 (pf "all nat,list boole=>boole^.
       AllBList nat list boole=>boole^ -> 
       all list boole.Lh list boole =nat -> list boole=>boole^list boole"))
(ind)
(assume "list boole=>boole^" "H1")
(cases)
(assume "Trivial")
(use "H1")
(assume "list boole" "boole" "Absurd")
(use "Efq")
(use "Absurd")
(assume "nat" "IH" "list boole=>boole^" "H1")
(cases)
(assume "Absurd")
(use "Efq")
(use "Absurd")
(assume "list boole")
(cases)
(use-with "IH" (pt "[list boole1]list boole=>boole^(list boole1::True)")
	  "?" (pt "list boole"))
(ng)
(use "H1")
(use-with "IH" (pt "[list boole1]list boole=>boole^(list boole1::False)")
	  "?" (pt "list boole"))
(ng)
(use "H1")
(save "AllBListElim")

