; The same problem as for tape_ver1.scm:
; this time the only change is in the first intermediate lemma
; to the point where A -> inf0 \/ inf1

;    Given :      A: all x. fx = 0 \/ fx = 1
;    Show  :      G: ex n,m. n<m & fn = fm
; Aditional information
;         inf0: all n. ex k. n <= k & fk = 0
;         inf1: all n. ex k. n <= k & fk = 1


(libload "nat.scm")
; load the natural numbers library

(add-var-name "f" (py "nat=>nat")) 
; define program constant f to represent the infinite tape

; define max for the maximum

(add-program-constant "NatMax" (py "nat=>nat=>nat") 1)

; (add-token
;  "max"
;  'mul-op
;  (lambda (x y)
;    (mk-term-in-app-form
;       (make-term-in-const-form (pconst-name-to-pconst "NatMax"))
;       x y)))

; ; computational rules

; (add-computation-rule (pt "0 max n") (pt "n"))
; (add-computation-rule (pt "Succ m max 0") (pt "Succ m"))
; (add-computation-rule (pt "Succ m max Succ n") (pt "Succ(m max n)"))
; (add-rewrite-rule (pt "m max 0") (pt "m"))


; a few properties for max

(set-goal 
  (pf "all n,m. n <= n max m"))

(ind) (ind) (prop)
(assume "n")
(prop)
(assume "n")
(assume "IH")
(ind) (prop)
(assume "m")
(assume "SH")
(use "IH")
(save "less_max")


(set-goal 
  (pf "all m,n. n <= n max m -> n <= m max n"))

(ind) (search)
(assume "m")
(assume "IH")
(ind) (search)
(assume "n")
(assume "SH")
(use "IH")
(save "commut_max")


; Additional results (lemmas), needed for the theorem

; First show that from the hypothesis A,
; with the help of maximum, one can infer that
; there are infinite 0s and 1s on the tape

; i.e. A -> inf0 \/ inf1
;     before:
; A -> not (info) -> inf1
;     now:
; A -> not (inf1) -> inf0

(set-goal
 (pf 
   "(all n. (f n = 0 -> bot) -> (f n = 1 -> bot) -> bot) ->
    ((all n. excl k. n <= k ! f k = 1) -> bot) ->
    all n. excl k. n <= k ! f k = 0"))

(assume "f")
(assume "A")
(assume "not_inf1")
(assume "n")
(assume "inf0")
(use "not_inf1")
(assume "m")
(assume "inf1")
(use "A" (pt "NatMax n m"))
(use "inf0")
(use "less_max")
(use "inf1" (pt "NatMax n m"))
(use "commut_max")
(use "less_max")
(save "either_inf1_or_inf0")


;other intermediate results

; S n <= m -> n < m

(set-goal 
 (pf "all n,m. Succ n <= m -> n < m"))

(ind) (ind) (prop)
(assume "m")
(prop)
(assume "n")
(assume "IH")
(ind) (prop)
(assume "m")
(assume "SH")
(use "IH")
(save "succ_lemma")


(aga "EqTrans" (pf "all k,n,m. n = m -> m = k -> n=k"))


; f(n) = k /\ f(m) = k -> f(m) = f(n)

(set-goal 
 (pf "all k,n,m. f n = k -> f m = k -> f m = f n"))

(assume "f" "k")
(assume "n" "m")
(assume "fn" "fm")
(use "EqTrans" (pt "k"))
(use "fm")
(simp-with "fn")
(prop)
(save "f_trans_lemma")


; Secondly, show now that from inf0 or from inf1, resp., 
; one can deduce the desider property of the tape

; i.e., inf0 -> G and inf1 -> G


; for inf0

(set-goal 
 (pf "(all n excl k. n <= k ! f k = 0) ->
      excl n,m. n < m ! f n = f m"))

(assume "f")
(assume "inf0")
(assume "negP")
(use "inf0" (pt "0"))
(assume "k")
(assume "T")
(drop "T")
(assume "fk0")
(use "inf0" (pt "Succ k"))
(assume "n" "LessEq" "fn0") 
(use "negP" (pt "k") (pt "n"))
(use "succ_lemma")
(use "LessEq")
(use "f_trans_lemma" (pt "0"))
(use "fn0")
(use "fk0")
(save "from_inf0_P")


; for inf1

(set-goal 
 (pf "(all n excl k. n <= k ! f k = 1) ->
      excl n,m. n < m ! f n = f m"))

(assume "f")
(assume "inf0")
(assume "negP")
(use "inf0" (pt "0"))
(assume "k")
(assume "T")
(drop "T")
(assume "fk0")
(use "inf0" (pt "Succ k"))
(assume "n" "LessEq" "fn0") 
; n is in fact the successor of k
(use "negP" (pt "k") (pt "n"))
(use "succ_lemma")
(use "LessEq")
(use "f_trans_lemma" (pt "1"))
(use "fn0")
(use "fk0")
(save "from_inf1_P")


; Now the Theorem: A->P
; i.e. If there are either 0s or 1s on an infinite tape
;      then there are 2 distinct indices for which 
;      the value is the same on the infinite tape

(set-goal 
 (pf "(all n. (f n = 0 -> bot) -> (f n = 1 -> bot) -> bot)
               -> excl n,m. n < m ! f n = f m"))

(assume "f")
(assume "A")

; we cut in the excluded middle changed accordinlgy 

(assert (pf 
 "((all n excl k. n <= k ! f k = 1) ->
                         excl n,m. n < m ! f n = f m) ->
  (((all n excl k. n <= k ! f k = 1) -> bot ) ->
      excl n,m. n < m ! f n = f m) ->
  excl n,m. n < m ! f n = f m"))

; proved by automatic search
(prop)

(assume "excl_middle_cut")
(use "excl_middle_cut")
(use "from_inf1_P")
(assume "not_inf1")
(use "from_inf0_P")
(use "either_inf1_or_inf0")
(use "A")
(use "not_inf1")
(save "tapeTheorem")

(dp) (dnp)

; expand the intermediate lemmas used
; and normalize the proof term
(define class-tape-proof (np (expand-theorems (current-proof))))

(dnp class-tape-proof)

; print again the theorem which had been proven
(formula-to-string (proof-to-formula class-tape-proof))
; "all f.(all n.
;     (f n=0 -> bot) -> 
;     (f n=1 -> bot) -> bot) -> 
;            (all n,m.n<m -> f n=f m -> bot) -> bot"

; print the lambda term of the proof
(proof-to-expr class-tape-proof)

(define min-excl-proof class-tape-proof)

; load the module implementing the a-translation
(mload "../modules/atr.scm")

; and apply a-translation to the classical proof above
; to extract the program

(define extr_term 
   (atr-min-excl-proof-to-structured-extracted-term  
      min-excl-proof))

; print the extracted algorithm
(term-to-string extr_term)

; normalize first, then print
;(term-to-string (nt extr_term))
(pp (nt extr_term))

; this is the result (yet another result):

; "[f0]
;   [if (f0 0=1) 
;    [if (f0 1=1) (0@1) 
;     [if (f0 1=0) 
;      [if (f0 2=1) 
;       [if (f0 3=1) (2@3) 
;        [if (f0 3=0) (1@3) (0@0)]] 
;      [if (f0 2=0) (1@2) (0@0)]] (0@0)]] 
;   [if (f0 0=0) 
;    [if (f0 1=1) 
;     [if (f0 2=1) (1@2) 
;      [if (f0 2=0) (0@2) (0@0)]] 
;     [if (f0 1=0) (0@1) (0@0)]] (0@0)]]"
