/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MacroParamEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef MacroParamEditor_H
#define MacroParamEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif


#include "UIParamEditor.h"

#ifndef Parameter_H
#include "Parameter.h"
#endif

#ifndef IconHolder_H
#include "IconHolder.h"
#endif

#ifndef TaskObserver_H
#include "TaskObserver.h"
#endif

#ifndef EditorObserver_H
#include "EditorObserver.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#include "MacroParamState.h"

class RequestPanel;
class MacroParamEditor;
class MacroParam;
 
class MacroDropArea : public IconHolder  
{
	MacroParamEditor* owner_;
public:
       MacroDropArea(MacroParamEditor*);
     		
	// From IconHolder
	virtual bool 		accept(IconObject*);
	virtual void add(IconObjectH);
	virtual void clear();
	virtual void openIcon(IconObject*);
	virtual void closeIcon(IconObject*);

	vector<IconObjectH> 	selection();
	vector<IconObjectH> 	icon();

	//from DragWindow
	virtual Widget menu();
	virtual bool dropCopy() { return true; }
	

	// From DropSite
	virtual void drop(Dropping&);


};

class MacroParamEditor : public XEditor<UIParamEditor_c>, 
	public IconObserver
{
public:

// -- Exceptions
	// None

// -- Contructors

	MacroParamEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~MacroParamEditor(); // Change to virtual if base class  

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	       
	Widget drag();
	Widget menu();
	void   editMacro(IconObjectH);
	IconObject* macro() const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MacroParamEditor(const MacroParamEditor&);
	MacroParamEditor& operator=(const MacroParamEditor&);

// -- Members

	RequestPanel*	   panel_;
	MacroDropArea	   macroArea_;
	MacroParamStateH   state_;
	IconObjectH        macro_;

// -- Methods

	MacroParam* macroParam() const;


// -- Overridden methods


	// From InternalEditor
	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void replace(IconObject*);
	virtual void merge(IconObject*);

	virtual IconObject* copy(const string&); 

	 // From UIParamEditor_c

	void removeCB(Widget, XtPointer);
	void editCB(Widget, XtPointer);
	
		
	// From IconObserver
	virtual void edited(IconObject*);
	virtual void closed(IconObject*);
	virtual void changed(IconObject*);
	virtual void destroyed(IconObject*);

// -- Class members
	// None

// -- Class methods
	// None


// -- Friends

	//friend ostream& operator<<(ostream& s,const MacroParamEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(MacroParamEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MacroParamEditor);
//#endif

#endif
