/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQWeatherRoomManager_H
#define MvQWeatherRoomManager_H

#include <QObject>

class QNetworkAccessManager;
class QNetworkReply;

using namespace std;

// ----------------------------------------------
// MvQVideoWallUploader
// Handles communication with a video wall server
// ----------------------------------------------

class MvQVideoWallUploader : public QObject
{
Q_OBJECT

public:
   MvQVideoWallUploader(QObject* parent=0);

   QString &URL()   {return URL_;}
   QString &token() {return token_;}

   void wrUpLoader(QString);

protected:
   QString getId( QString& );

protected slots:
   void slotFileUpload(QNetworkReply*);
   void slotWallUpdate(QNetworkReply*);

private:
   QString URL_;
   QString token_;
   QNetworkAccessManager* fileUploadManager_;
   QNetworkAccessManager* wallUpdateManager_;
};

#endif
