/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QComboBox>
#include <QDebug>

#include "MvQComboBoxLine.h"

#include "LineFactory.h"
#include "RequestPanel.h"

MvQComboBoxLine::MvQComboBoxLine(RequestPanel& owner,const Parameter& param) :
		   MvQRequestPanelLine(owner,param),
		   reportChange_(true)
{
	cbEdit_ = new QComboBox(parentWidget_);
	owner_.addWidget(cbEdit_,row_,3);

        param_.scan(*this);
	
	connect(cbEdit_,SIGNAL(currentIndexChanged(int)),
		this,SLOT(slotCurrentChanged(int)));
	
	//combo_->setCurrentIndex(dindex);
}
	

void MvQComboBoxLine::next(const Parameter&, const char* first,const char* second)
{
 	if(!first) return; 	
  	QString dataStr=(second)?QString(second):QString(first);	  	  
	cbEdit_->addItem(QString::fromStdString(param_.beautifiedName(first)),dataStr);	
}     	
	
void MvQComboBoxLine::refresh(const vector<string>& values)
{
	if(values.size() > 0)
	{
		for(int i=0; i < cbEdit_->count(); i++)
		{
		  	if(cbEdit_->itemData(i).toString().toStdString() == values[0])
			{
			  	reportChange_=false;
			  	cbEdit_->setCurrentIndex(i);
				reportChange_=true;
			}	
		}
	}	
			
	//changed_ = false;
}	

void MvQComboBoxLine::slotCurrentChanged(int index)
{
	if(reportChange_ && index >=0 && index < cbEdit_->count())
  		owner_.set(param_.name(),cbEdit_->itemData(index).toString().toStdString());
}	


static LineMaker<MvQComboBoxLine> maker1("menu");
static LineMaker<MvQComboBoxLine> maker2("option_menu");