/*
------------------------------------------------------------------------------
MetaCam - Extract EXIF information from digital camera files, with
support for Vendor specific blocks.
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)
Copyright (C) 2001, Jan Brittenson (bson@rockgarden.net)
Copyright (C) 2001, Patrick Tullmann (pat@tullmann.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------
*/

#include "dpyfuncs.h"

static const char *rcsid="";

// Initial Casio tag references from
//   http://www.ba.wakwak.com/~tsuruzoh/Computer/Digicams/exif-e.html
//   and
//   http://www.dicasoft.de/dicainfo.htm

knowntag casio_known[] = {
    { 0x1, tSHORT,	0, "              Recording Mode", dpyCasioRecMode},
    { 0x2, tSHORT,	0, "                     Quality", dpyCasioQuality},
    { 0x3, tSHORT,	0, "               Focusing Mode", dpyCasioFocusMode},
    { 0x4, tSHORT,	0, "                  Flash Mode", dpyCasioFlashMode},
    { 0x5, tSHORT,	0, "             Flash Intensity", dpyCasioFlashInten},
    { 0x6, tLONG,	0, "           Object Distance ~", dpyCasioDistance},
    { 0x7, tSHORT,	0, "               White Balance", dpyCasioWhiteBalance},
    // 0x8 is unknown tSHORT
    // 0x9 is unknown tSHORT
    { 0xa, tLONG,	0, "                Digital Zoom", dpyCasioDigitalZoom},
    { 0xb, tSHORT,	0, "                   Sharpness", dpyCasioSharpness},
    { 0xc, tSHORT,	0, "                    Contrast", dpyCasioContrast},
    { 0xd, tSHORT,	0, "                  Saturation", dpyCasioSaturation},
    // 0xe through 0x013 are unknown tSHORT
    { 0x14,tSHORT,	0, "             CCD Sensitivity", dpyCasioSensitivity},

    {0,0,0,0}
};


