/*
virus.c - MessageWall virus scanning definitions
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "messagewall.h"
#include "smtp.h"
#include "virus.h"

static const char tagstring[] = "$Id: virus.c,v 1.9 2002/07/11 03:10:38 ian Exp $";

static int hextoi(const char * const hexstring) {
	int out;
	/* return int value for 2 byte hex value (-1 if invalid) */
	switch (hexstring[0]) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			out = hexstring[0] - '0';
			break;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
			out = hexstring[0] - 'a' + 10;
			break;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
			out = hexstring[0] - 'A' + 10;
			break;
		default:
			return -1;
	}
	out <<= 4;
	switch (hexstring[1]) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			out += hexstring[1] - '0';
			break;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
			out += hexstring[1] - 'a' + 10;
			break;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
			out += hexstring[1] - 'A' + 10;
			break;
		default:
			return -1;
	}
	return out;
}

static unsigned int virus_checksum(struct firestring_estr_t *pattern) {
	static char s[4];
	
	memset(s,0,4);
	memcpy(s,pattern->s,min(4,pattern->l));

	return (
		( (s[0] & 0x0f) << 4 ) |
		( (s[1] & 0x0f) )
	       ) * 256 + (
		( (s[2] & 0x0f) << 4 ) |
		( (s[3] & 0x0f) )
	       );
}

static int virus_free_database(struct messagewall_virus_database_t *database) {
	unsigned int u;
	struct messagewall_virus_identity_t *identity, *identity2;

	for (u = 0; u < 65536; u++) {
		identity = database->database[u];
		while (identity != NULL) {
			identity2 = identity->next;
			firestring_estr_free(&identity->name);
			firestring_estr_free(&identity->pattern);
			free(identity);
			identity = identity2;
		}
		database->database[u] = NULL;
	}

	return 0;
}

static int virus_load_database(struct messagewall_virus_database_t *database) {
	struct messagewall_virus_identity_t *identity;
	static char line[65536];
	char *tempchr;
	int i,o;
	unsigned int u;
	FILE *f;
	unsigned char *l2 = (unsigned char *)line;

	/*
	 * file is inside the chroot, this should be safe
	 */
	f = fopen(database->filename.s,"r"); /* ITS4: ignore fopen */
	if (f == NULL)
		return 1;
	
	while (fgets(line,65536,f) != NULL) {
		tempchr = strchr(line,'\n');
		if (tempchr == NULL)
			continue;

		tempchr = strchr(line,'=');
		if (tempchr == NULL)
			continue;

		*(tempchr++) = '\0';

		identity = messagewall_malloc(struct messagewall_virus_identity_t);
		firestring_estr_alloc(&identity->name,strlen(line));
		firestring_estr_strcpy(&identity->name,line);

		/*
		 * now we have to decode hex
		 */
		o = 0;
		while ((i = hextoi(tempchr)) != -1) {
			l2[o++] = i;
			tempchr += 2;
		}
		firestring_estr_alloc(&identity->pattern,o);
		identity->pattern.l = o;
		memcpy(identity->pattern.s,line,o);

		u = virus_checksum(&identity->pattern);
		identity->next = database->database[u];
		database->database[u] = identity;
	}

	fclose(f);

	return 0;
}

int virus_reload() {
	struct messagewall_virus_database_t *database;

	database = virus_head;
	while (database != NULL) {
		virus_free_database(database);
		virus_load_database(database);
		database = database->next;
	}
	return 0;
}

struct messagewall_virus_database_t *virus_get_database(const char *filename) {
	struct messagewall_virus_database_t *database;
	int i;

	/*
	 * check that we haven't already loaded this
	 */
	database = virus_head;
	while (database != NULL) {
		if (firestring_estr_strcmp(&database->filename,filename) == 0)
			return database;
		database = database->next;
	}
	
	database = messagewall_malloc(struct messagewall_virus_database_t);
	firestring_estr_alloc(&database->filename,strlen(filename));
	firestring_estr_strcpy(&database->filename,filename);
	firestring_estr_0(&database->filename);
	for (i = 0; i < 65536; i++)
		database->database[i] = NULL;
	database->next = virus_head;
	virus_head = database;

	return database;
}

static int virus_database_scan(int client, struct messagewall_virus_profile_t *virus_profile, struct firestring_estr_t *chunk) {
	int i;
	unsigned int u;
	struct firestring_estr_t hashinput;
	struct messagewall_virus_identity_t *identity;

	hashinput.l = hashinput.a = 4;

	for (i = 0; i < chunk->l - 4; i++) {
		hashinput.s = &chunk->s[i];
		u = virus_checksum(&hashinput);
		identity = virus_profile->global->database[u];
		while (identity != NULL) {
			if (chunk->l - i < identity->pattern.l) {
				identity = identity->next;
				continue;
			}
			firestring_estr_0(&identity->name);
			if (memcmp(identity->pattern.s,&chunk->s[i],identity->pattern.l) == 0)
				if (smtp_reject(client,"VIRUS","message body matches pattern for '%e' virus",SMTP_VIRUS,virus_profile->score,0,&identity->name,NULL) != 0)
					return 1;
			identity = identity->next;
		}
	}
	return 0;
}

int virus_check(int client, struct firestring_estr_t *chunk) {
	struct messagewall_virus_profile_t *virus_profile;

	virus_profile = clients[client].profile->virus_scan;
	while (virus_profile != NULL) {
		if (virus_database_scan(client,virus_profile,chunk) != 0)
			return 1;
		virus_profile = virus_profile->next;
	}

	return 0;
}
