/*
rdns.c - MessageWall reverse DNS definitions
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <time.h>
#include <firestring.h>
#include <firedns.h>
#include "messagewall.h"
#include "smtp.h"
#include "rmx.h"

static const char tagstring[] = "$Id: rmx.c,v 1.13.2.1 2002/09/30 01:21:48 ian Exp $";

int rmx_send_queries(int client) {
	clients[client].resent_rmx = 0;
	
	time(&clients[client].rmx_request);

	if (clients[client].fromdomain.l == 0) {
		clients[client].rmx_fd = -1;
		clients[client].rmx_a_fd = -1;
		return 0;
	}

	clients[client].rmx_fd = firedns_getmx(clients[client].fromdomain.s);
	clients[client].rmx_a_fd = firedns_getip4(clients[client].fromdomain.s);

	return 0;
}

int rmx_resend_queries(int client) {

	if (clients[client].rmx_fd < 0)
		goto a;

	firedns_getresult(clients[client].rmx_fd);
	clients[client].rmx_fd = firedns_getmx(clients[client].fromdomain.s);

a:
	if (clients[client].rmx_a_fd < 0)
		return 0;

	firedns_getresult(clients[client].rmx_a_fd);
	clients[client].rmx_a_fd = firedns_getip4(clients[client].fromdomain.s);

	return 0;
}

int rmx_response(int client, int fd) {
	char *ret;

	ret = firedns_getresult(fd);
	if (fd == clients[client].rmx_fd) {
		if (ret == NULL)
			clients[client].rmx_fd = -2;
		else
			clients[client].rmx_fd = -1;
			
	} else {
		if (ret == NULL)
			clients[client].rmx_a_fd = -2;
		else
			clients[client].rmx_a_fd = -1;
	}

	return 0;
}

int rmx_check_profile(int client) {
	if (clients[client].profile->rmx_required == 1) {
		if (clients[client].rmx_fd == -1 || clients[client].rmx_a_fd == -1)
			return 0;
		if (clients[client].rmx_fd == -2 && clients[client].rmx_a_fd == -2)
			return 1;
		return -1;
	}

	return 0;
}
