/****************************************************************************
* MeshLab                                                           o o     *
* A versatile mesh processing toolbox                             o     o   *
*                                                                _   O  _   *
* Copyright(C) 2005                                                \/)\/    *
* Visual Computing Lab                                            /\/|      *
* ISTI - Italian National Research Council                           |      *
*                                                                    \      *
* All rights reserved.                                                      *
*                                                                           *
* This program is free software; you can redistribute it and/or modify      *   
* it under the terms of the GNU General Public License as published by      *
* the Free Software Foundation; either version 2 of the License, or         *
* (at your option) any later version.                                       *
*                                                                           *
* This program is distributed in the hope that it will be useful,           *
* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
* GNU General Public License (http://www.gnu.org/licenses/gpl.txt)          *
* for more details.                                                         *
*                                                                           *
****************************************************************************/
#ifndef UVFACETEXTURE_H_
#define UVFACETEXTURE_H_

#include <src/QuadTree/QuadTreeLeaf.h>

/*
 * The UVFaceTexture class stores UV texture information of a face.
 * It also ofers functions to check if a uv point lies inside the 
 * 2D triangle generated by the 3 uv coordinates.
 */

class UVFaceTexture: public QuadTreeLeaf{
public:

	
	int type;					//0 = camera; 1 = program
	double faceAngleToCamera;	//angle of the face to the camera
	double u[3];				
	double v[3];
	int faceIndex;				//index of the 3D face of the MeshModel
	int textureindex;			//index of the corresponding texture

	UVFaceTexture(){
	}
	~UVFaceTexture(){
		
	}
	/*
	 * Calculates the barycentric coordinate (a,b,c) of the uv triangle for the uv 
	 * coordinate (eu,ev). If d is 0.0 the uv coordinate liese inside the uv triangle.
	 * If not d is equal 1.0. 
	 */
	void getBarycentricCoordsForUV(double eu,double ev,double& a,double& b,double& c,double& d);
	
	/*
	 * Gets the uv (eu,ev) coordinates of the triangle for a given barycentric
	 * cordinate (a,b,c). 
	 */
	void getUVatBarycentricCoords(double &eu,double &ev,double a,double b,double c);
	
	/*
	 * Checks if a part of the uv triangle lies in the rectangle spanned by the 
	 * starting point (x,y) the width w and the height h.
	 */
	virtual bool isInside(double x, double y, double w, double h);
	
	/*
	 * Checks if the 2D point (x,y) lies inside the uv triangle  
	 */
	virtual bool isInside(double x, double y);

private: 
	/*
	 * Checks if the 2D line segment from p1 to p2 intersects with
	 * one of the sides of the 2D trinagle generated by the 3 uv coordinates.
	 */
	bool intersection(double *p1,double *p2);
	
	/*
	 * Checks if there is an intersection of the two 2D line segments p1->p2 and p3->p4.
	 */
	bool intersectionOfTwoLines(double *p1,double *p2,double *p3, double *p4);
};

#endif /*UVFACETEXTURE_H_*/
