#include <ctype.h>
#include "adstring.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>
#include "regex.h"
#include <stdlib.h>
#include <strstream.h>
#include <iomanip.h>
#include <list.h>
#include <algo.h>

// ************* String.h replacement code:
int min(int i, int j){return i<j ? i : j;}

Regex::Regex(const char *s){
  patt=(struct re_pattern_buffer*)
    malloc(sizeof(struct re_pattern_buffer));
  patt->translate=0;
  patt->fastmap=0;
  patt->buffer=0;
  patt->allocated=0;
  re_compile_pattern(s,strlen(s),patt);
}

String upcase(const String &x){
  String s;
  for(string::size_type i=0;i< (string::size_type)x.length(); i++)
    s+=char(toupper(x[i]));
  return s;
}

#if 0
const char* String::chrstr() const{
  //This assumes vector doesn't free the memory for the last element.
  //I believe (but am not sure) that this is true.

  ((vector<char> &)buf).push_back('\0');
  ((vector<char> &)buf).pop_back();
  return &(buf[0]);
}
#endif

int readline(istream& s, String& x, 
	     char terminator = '\n'){
  char buf[MAX_LINE*2];
  bool ret;

  ret=s.get(buf,sizeof(buf), terminator);
  x=String(buf);
  s.get(terminator);
  return ret;
}

// ************* "own" string handling code:


except_pi::except_pi(parsestream *p){
  pi=p;
}

except_pi_String::except_pi_String(parsestream *p, String s):except_pi(p){
  msg=s;
}

parseinfo::~parseinfo(void){
}

void except_pi::report(){
  string::size_type i;
  string::size_type startpos=0;

  if(pi){
    fprintf(stderr, 
	    _("In file \"%s\", at (or in the definition that ends at) line %i:\n"),
	    pi->filename().c_str(),
	    pi->linenumber());
    
    if(pi->pos > 50)
      startpos=pi->pos - 50;
    
    if(startpos)
      cerr<<"[...]";
    cerr<<pi->buffer.substr(startpos)<<endl;
    
    if(startpos)
      cerr<<"[...]";
    for(i=1+startpos;i<pi->pos;i++)
      cerr<<" ";
    cerr<<"^"<<endl;
  } else {
    fprintf(stderr, 
	    _("Somewhere in input file:\n"));
  }
  cerr<<message()<<endl;
}
void parsestream::preprocess(String &s){
  //disregards lines that start with a #
  //set filename if line starts with "!F"
  string::size_type i;
  String compat;

  i=0;
  while((i<s.length())&&isspace(s[i]))
    i++;
  if(i)
    s=s.after(i);

  if(!s.length())
    return;

  switch(s[0]){
  case '#':
    s=""; 
    return;
  case '!':
    if(s.length()>1){
	switch(s[1]){
	case 'F': 
	  set_linenumber(0);
	  set_filename(s.after(3));
	  //cerr<<"filename="<<filename()<<", s.after="<<s.after(2)<<endl;
	  s="";
	  return;
	case 'L': 
	  set_linenumber(Stringtoi(s.after(2))-1);
	  //cerr<<"filename="<<filename()<<", s.after="<<s.after(2)<<endl;
	  s="";
	  return;
	case 'C':
	  compat=s.after(3);
	  if(compat == "menu-1")
	    seteolmode(eol_newline);
	  else if(compat == "menu-2")
	    seteolmode(eol_semicolon);
	  else 
	    throw unknown_compat(this, compat);
	  s="";
	  return;
	default:
	  if(s.contains("!include",0)){
	    String t(s.after(strlen("!include ")));
	    //cerr<<"HOI, t="<<t<<", filename()[0]="<<filename()[0]<<endl;
	    if((t[0]=='/')|| 
	       (fname.size()==0))
	      new_file(t);
	    else {
	      String name=String_parent(filename()) + "/" + t;
	      if(ifstream(name.c_str()))
		new_file(name);
	      else{
		new_file(otherdir+'/'+t);
	      }
	    }
	  }
	  //(s==buffer now!) s="";
	  return;
	}
    }
    return;
  default:;
  }
}
void parsestream::close_file(){
  //should delete i.back(), but only if !=stdin!
  
  int nu=i.size()-1;
  if(nu || !stdin_file)
    delete i[nu];
  i[nu]=NULL;
  if(i.size()>1){
    i.pop_back();
    lineno.pop_back();
    fname.pop_back();
  } else {
    throw endoffile(this);
  }
}
void parsestream::new_file(const String &s){
  ifstream *f=new ifstream(s.c_str());
  
  init(f,s,false);
  //??? 
}
void parsestream::new_line(){
  while(i.size()){
    if(!current_istr()||current_istr()->eof()){
      close_file();
      continue;
    }
    buffer="";
    pos=0;
    while(current_istr()->good()&&
	  !(current_istr()->eof())&&
	  !buffer.length()){
      readline(*current_istr(),buffer);
      set_linenumber(linenumber()+1);
      preprocess(buffer);
      buffer=rmtrailingspace(buffer);
    }
    while(current_istr()->good()&&
	  !(current_istr()->eof())&&
	  (((eolmode==eol_newline)&&(buffer[buffer.length()-1]=='\\'))||
	   ((eolmode==eol_semicolon)&&(buffer[buffer.length()-1]!=';')))){
      String s;
      readline(*current_istr(),s);
      set_linenumber(linenumber()+1);
      switch(eolmode){
      case eol_newline:
	buffer=buffer.substr(0,buffer.length()-1)+" "+rmtrailingspace(s);
	break;
      case eol_semicolon:
	buffer=buffer+" "+rmtrailingspace(s);
	break;
      }
    }
    if(!buffer.length()){
      close_file();
      continue;
    }
    if(current_istr()->eof()&&
       buffer.length()&&
       (((eolmode==eol_newline)&&(buffer[buffer.length()-1]=='\\'))||
	((eolmode==eol_semicolon)&&(buffer[buffer.length()-1]!=';')))){
      //a "\" at the end of a file: unconditional error (don't unwind etc)
      //(or no ; at eof, when eolmode=; . Same unconditional error.
      throw endoffile(this);
    }
    if(eolmode==eol_semicolon)
      if(buffer[buffer.length()-1]==';')
	buffer.erase(buffer.length()-1, 1);
    return;
  }
  if(in_constructor){
    return;
  } else
    throw endoffile(this);
}

char parsestream::get_char(){
  if(!buffer.length())
    throw endoffile(this);
  if(pos>=buffer.length())
    throw endofline(this);
  
  return buffer[pos++];
}

char parsestream::put_back(char c){
  if (c){
    if(pos){
      pos--;
      // buffer.at(pos,1)=String(c);
      buffer.replace(pos,1,c);
    } else
      buffer=c+buffer;
    
  }
  return c;
}

String parsestream::get_line(){
  String s;
  s=buffer.after(pos);
  if(s==String(""))
    throw endofline(this);
  buffer="";
  try{
    skip_line();
  }
  catch(endoffile){};
  return s;
}

String parsestream::get_name(){
  char c;
  String s;
  skip_space();
  try{
    while((c=get_char())&&
	  (isalnum(c)||(c=='_')||(c=='-')||(c=='+')||(c=='.')))
      s+=c;
    if(c)
      put_back(c);
  } catch(endofline d){};
  return s;
}

String parsestream::get_name(const Regex &r){
  char str[2]={0,0};
  char &c=str[0];
  String s;
  skip_space();
  try{
    while((c=get_char())){
      if(re_match(r.pattern(), str, 1, 0, 0) > 0)
	s+=c;
      else
	break;
    }
    if(c)
      put_back(c);
  } catch(endofline){};
  return s;
}
String parsestream::get_eq_name(){
  char c;
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, "=");
  return get_name();
}


String parsestream::get_Stringconst(){
  char c;
  String s;
  skip_space();
  c=get_char();
  try{
    if(c=='\"'){
      while((c=get_char())&&(c!='\"')){
	if(c=='\\'){
	  c=get_char();
	  switch(c){
	  case 't': c='\t'; break;
	  case 'b': c='\b'; break;
	  case 'n': c='\n'; break;
	  default:; break;
	  }
	}
	s+=c;
      }
      if(c!='\"')
	throw char_expected(this, "\"");
    } else{ //no " at begining
      s=String("") + c;
      while((c=get_char())&&!isspace(c))
	s+=c;
    }
  }catch(endofline p){};
  
  return s;
}
String parsestream::get_eq_Stringconst(){
  char c;
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, "=");
  return get_Stringconst();
}

bool parsestream::get_boolean(){
  String s;
  s=get_name();

  if(s==String("true"))
    return true;
  else if(s==String("false"))
    return false;
  else
    throw boolean_expected(this, s);
}
bool parsestream::get_eq_boolean(){
  char c;
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this,"=");
  return get_boolean();
}
int parsestream::get_integer(){
  char c;
  String s;

  try{
    skip_space();
    while((c=get_char())&&((isdigit(c)||(c=='-'))))
      s+=c;
  } catch(endofline d){};

  return atoi(s.c_str());
}

int parsestream::get_eq_integer(){
  char c;

  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, "=");
  return get_integer();
}

double parsestream::get_double(){
  char c;
  String s;
  
  skip_space();
  try{
    while((c=get_char())&&
	 (isdigit(c)||
	  (c=='.')||(c=='E')||(c=='e')||(c=='+')||(c=='-')))
      s+=c;
  } catch(endofline d){};

  return atof(s.c_str());	
}
double parsestream::get_eq_double(){
  char c;
  
  skip_space();
  c=get_char();
  if(c!='=')
    throw char_expected(this, "=");

  return get_double();
}
void parsestream::skip_line(){
  buffer="";
  try{
    new_line();
  }
  catch(endoffile d){};
}
void parsestream::skip_space(){
  char c;
  while(isspace(c=get_char()));  
  if(c)
    put_back(c);
}
void parsestream::skip_char(char expect){
  char buf[2]="a";
  char c=get_char();
  if(c!=expect){
    put_back(c);
    buf[0]=c;
    throw char_expected(this, buf);
  }
}
void parsestream::seteolmode(eol_type mode){
  eolmode=mode;
}

String rmtrailingspace(String &s){
  while(s.length()&&(isspace(s[s.length()-1])))
    s.erase(s.length()-1,1);
  return s;
}



String escape_doublequotes(const String &s){
  String t;
  string::size_type i;
  for(i=0;i!=s.length();i++){
    if(s[i]=='\"')
      t+='\\';
    t+=s[i];
  }
  return t;
}

String escapewith_String(const String &s, const String &esc,
			 const String &with){
  // call with: escape_String("hello $world, %dir", "$%", "\\")
  // returns:   "hello \$world, \%dir"
  String t;
  string::size_type i;
  for(i=0;i!=s.length();i++){
    if(esc.find(s[i])!=string::npos)
      t+=with;
    t+=s[i];
  }
  return t;
}

String escape_String(const String &s, const String &esc){
  // call with: escape_String("hello $world, %dir", "$%")
  // returns:   "hello \$world, \%dir"
  return escapewith_String(s,esc,"\\");
}
String cppesc_String(const String &s){
  String t;
  string::size_type i;
  for(i=0;i!=s.length();i++){
    if(!(isalnum(s[i])||(s[i]=='_')))
      t+='$'+itohexString(int(s[i]));
    else
      t+=s[i];
  }
  return t;
}
String tolower_String(const String &s){
  String t;
  for(string::size_type i=0; i<s.length(); i++)
    t+=char(tolower(s[i]));
  return t;
}
String toupper_String(const String &s){
  String t;
  for(string::size_type i=0; i<s.length(); i++)
    t+=char(toupper(s[i]));
  return t;
}
String replacewith_String(const String &s, const String &replace,
			  const String &with){
  // call with: replacewith_String("hello $world, %dir", "$% ", "123")
  // returns:   "hello31world,32dir"
  String t;
  string::size_type i,j;
  for(i=0;i!=s.length();i++){
    if((string::size_type)(j=replace.find(s[i]))!=string::npos)
      t+=with[j % with.length()];
    else
      t+=s[i];
  }
  return t;
}

String replace(String s,char match, char replace){
  string::size_type i;
  for(i=0;i!=s.length();i++)
    if(s[i]==match)
      s.replace(i,i+1,replace);
  return s;
}
String sort_hotkey(String str){
  String t;
  string::size_type i;
  string::size_type l=str.length();
  char *s=strdup(str.c_str());

  if(!l)
    return t;

  t=String("")+s[0];
  s[0]='\0';
  for(i=1;i!=l;i++)
    if((isspace(s[i-1])||ispunct(s[i-1]))&&isupper(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=l;i++)
    if((isspace(s[i-1])||ispunct(s[i-1]))&&isalnum(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=l;i++)
    if(isupper(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=l;i++)
    if(isalpha(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=l;i++)
    if(isalnum(s[i])){
      t+=s[i];
      s[i]='\0';
    }
  for(i=1;i!=l;i++)
    if(s[i]){
      t+=s[i];
      s[i]='\0';
    }
  free(s);
  return t;
}

int Stringtoi(const String &s){
  return atoi(s.c_str());
}

String itoString(int i){
  char s[MAX_LINE];
  ostrstream str(s,sizeof(s));
  str<<i<<ends;
  return s;
}

String itohexString(int i){
  char s[MAX_LINE];
  ostrstream str(s,sizeof(s));
  str<<setbase(16)<<i<<ends;
  return s;
}


String String_parent(String s){
  // String_parent("/Debian/Apps/Editors/Emacs") = "/Debian/Apps/Editors
  string::size_type  i,p;
  
  for(i=0,p=string::npos;(string::size_type)i!=s.length();i++)
    if(s[i]=='/')
      p=i;
  if(p==string::npos)
    return "";
  else
    return s.substr(0,p);
}

String String_basename(String s){
  String t;
  string::size_type i; 
  string::size_type p; //points to last encountered '/'
  string::size_type q; //points to last-but-one encountered '/'.
  
  for(i=0,p=string::npos,q=0;i!=s.length();i++)
    if(s[i]=='/'){
      q=p;
      p=i;
    }
  if(p==string::npos)
    return "";
  else
    return s.substr(q+1,p);
}
String String_stripdir(String s){
  String t;
  string::size_type i; 
  string::size_type p; //points to last encountered '/'
  
  for(i=0,p=string::npos;(string::size_type)i!=s.length();i++)
    if(s[i]=='/')
      p=i;
  if(p==string::npos)
    return s;
  else
    return s.substr(p+1,s.length());
}

String String_lastname(String s){
  //what `basename' in the shell returns...
  String t;
  string::size_type  i; 
  string::size_type  p; //points at last encountered '/'

  if(!s.size())
    return "";

  if(s[s.size()-1] == '/')
    s.erase(s.size()+1,1);
  
  for(i=0,p=string::npos;(string::size_type)i!=s.length();i++)
    if(s[i]=='/')
      p=i;
  if(p==string::npos)
    return "";
  else
    return s.substr(p+1);
}

void break_char(const String &sec,
		      StrVec &sec_vec,
		      char breakchar){
  String s;
  string::size_type i,j;

  if(!sec.size())
    return;

  if(sec[0]==breakchar) /* ignore first occurence of breachar */
    i=1;
  else
    i=0;
  while(true){
    while((i<sec.size())&&(isspace(sec[i])))
      i++;
    j=sec.find(breakchar,i);
    if(j!=string::npos)
      sec_vec.push_back(sec.substr(i,j-i));
    else{
      if(i!=sec.size())
	sec_vec.push_back(sec.substr(i));
      break;
    }
    i=j+1;
  }
}


void break_slashes(const String &sec,
		         StrVec &sec_vec){
  break_char(sec,sec_vec,'/');
}
void break_commas(const String &sec,
		         StrVec &sec_vec){
  break_char(sec,sec_vec,',');
}


String Sprintf(const char *s, String &str){
  char buf[MAX_LINE];
  snprintf(buf, sizeof(buf), s, str.c_str());
  return buf;
}

const char *ldgettext(const char *language,
		      const char *domain,
		      const char *msgid){
  /* this code comes from the gettext info page. It looks
     very inefficient (as though for every language change a new
     catalog file is opened), but tests show adding a language
     change like this doesn't get performance down very much
     (runtime goes `only' about 70% up, if switching between 2 
     languages, as compared to no swiching at all).
  */
  /* Change language.  */
  setenv ("LANGUAGE", language, 1);
  /* Make change known.  */
  {
    extern int  _nl_msg_cat_cntr;
    ++_nl_msg_cat_cntr;
  }
  return dgettext(domain, msgid);
}
