
'\"
'\" Generated from file 'memchan.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools
.so man.macros
.TH "memchan" n 2.2  "Memory channels"
.BS
.SH "NAME"
memchan \- Create and manipulate memory channels
.SH "SYNOPSIS"
package require \fBTcl \fR
.sp
package require \fBmemchan \fR
.sp
\fBmemchan\fR ?-initial-size \fIlen\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
This manpage documents both the overall package and the command
\fBmemchan\fR. The package itself provides a number of in-memory
channels which can utilized to
.IP \(bu
capture stream-like information in a natural way instead of using
\fBset\fR and \fBappend\fR to manipulate strings
.IP \(bu
or to transfer data between interpreters, in the same thread or not.
.SH "COMMAND"
.PP
.TP
\fBmemchan\fR ?-initial-size \fIlen\fR?\fR
creates a chunk-oriented in-memory channel and returns its handle. If
an initial size is specified the system will pre-allocate \fIlen\fR
bytes of buffer space for the contents. This is no restriction on the
ultimate size of the channel, it will always grow as much as is
necessary to accomodate the data written into it.
.sp
The channels created here can be transfered between interpreters in
the same thread and between threads, but only as a whole. It is not
possible to use them to create a bi- or unidirectional connection
between two interpreters.
.PP
Memory channels created by \fBmemchan\fR provide two read-only options
which can be queried via the standard \fBfconfigure\fR command. These
are
.TP
-length
The value of this option is the number of bytes currently
stored in the queried memory channel.
.TP
-allocated
The value of this option is the number of bytes currently
allocated by the queried memory channel. This number is at
least as big as the value of \fI-length\fR.
.PP
As the channels generated by \fBmemchan\fR grow as necessary they are
always writable. This means that a writable \fBfileevent\fR-handler
will fire continuously.
.PP
The channels are also readable if they contain more than zero bytes
and the seek location is not and the end of the channel. Under these
conditions a readable \fBfileevent\fR-handler will fire continuously.
.PP
Note that writing to such a channel usually occurs at the end, thus
supressing readable events. This also means that users have to take
care to \fBseek\fR the channel to a location before the end before
trying to read data back.
.SH "SEE ALSO"
fifo, fifo2, null, zero, random
.SH "KEYWORDS"
memchan, chunk, in-memory channel, channel, i/o
.SH "COPYRIGHT"
.nf
Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
.fi
