/* gtk.c -- misc Gtk wrappers 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "melon.h"

//extern int pixmap_width, pixmap_height;

void dialog_message (gchar *message)
{
	GtkWidget *dialog, *label, *button;
   
	dialog = gtk_dialog_new();
	label = gtk_label_new (message);
	button = gtk_button_new_with_label("Ok");

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		label, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button, FALSE, FALSE, 0);

	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(dialog));
	gtk_widget_show_all (dialog);
}

void set_style(void)
{
	GtkStyle *style;

	style = gtk_style_new();
	if((strcmp(cfg_data.color_style, "gtk_default")) == 0) {
		cfg_data.bgcolor = style->bg[0];
		cfg_data.fgcolor = style->fg[0];
		cfg_data.abgcolor = style->bg[GTK_STATE_ACTIVE];
		cfg_data.afgcolor = style->fg[GTK_STATE_ACTIVE];
	} else {
		style->bg[0] = cfg_data.bgcolor;
		style->bg[GTK_STATE_ACTIVE] = cfg_data.abgcolor;
		style->bg[GTK_STATE_PRELIGHT] = cfg_data.abgcolor;
		style->bg[GTK_STATE_SELECTED] = cfg_data.fgcolor;
		style->fg[0] = cfg_data.fgcolor;
		style->fg[GTK_STATE_ACTIVE] = cfg_data.afgcolor;
		style->fg[GTK_STATE_PRELIGHT] = cfg_data.afgcolor;
		style->fg[GTK_STATE_SELECTED] = cfg_data.bgcolor;
		style->text[0] = cfg_data.fgcolor;
		style->text[GTK_STATE_ACTIVE] = cfg_data.afgcolor;
		style->text[GTK_STATE_PRELIGHT] = cfg_data.afgcolor;
		style->text[GTK_STATE_SELECTED] = cfg_data.bgcolor;
		style->base[0] = cfg_data.abgcolor;
	}
	gtk_widget_set_default_style( style );
	gtk_style_unref (style);
}

void pidfile_action_dialog (void)
{
	GtkWidget *window;
	GtkWidget *vbox, *hbox;
	GtkWidget *button, *label;

	/* window */
	window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (window), 200, 300);
	gtk_window_set_title(GTK_WINDOW (window), "Another melon is running...");
	gtk_widget_show(window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );

	/* label */
	label = gtk_label_new ("A melon pidfile was found\n. Maybe another melon"
				"is already running.");
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 2);
	gtk_widget_show(label);

	/* hbox2 */
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox);
	gtk_widget_show( hbox );

	/* Ignore button */
	button = gtk_button_new_with_label ("Ignore");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(NULL), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* Overwrite button */
	button = gtk_button_new_with_label ("Overwrite");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(NULL), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* Quit button */
	button = gtk_button_new_with_label ("Quit");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(close_application), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);
}

void set_melon_position (void) {
	int pixmap_width, pixmap_height;
	int x = 0, y = 0;
	int cfg_xpos = atoi(cfg_data.xposition);
	int cfg_ypos = atoi(cfg_data.yposition);

	/* get the pixmap size */
	gdk_window_get_size (w_data.gdk_pixmap, &pixmap_width, &pixmap_height); 

	if((strcmp(cfg_data.xposition, "-0")) == 0) 
		x = gdk_screen_width() - pixmap_width;
	else if (cfg_xpos < 0) 
		x = gdk_screen_width() - pixmap_width + cfg_xpos;
	else
		x = cfg_xpos;

	if((strcmp(cfg_data.yposition, "-0")) == 0)
		y = gdk_screen_height() - pixmap_height;
	else if (cfg_ypos < 0)
		y = gdk_screen_height() - pixmap_height + cfg_ypos;
	else
		y = cfg_ypos;

	gtk_widget_set_usize( w_data.window, pixmap_width, pixmap_height );
	gtk_widget_set_uposition( w_data.window, x, y );
}



