!*************************************************************************
! COPYRIGHT (C) 1999 - 2003  EDF R&D
! THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
! AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
! EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
! ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
! INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
!
!**************************************************************************

! ******************************************************************************
! * - Nom du fichier : test17.f90
! *
! * - Description : lecture d'elements de maillages MED ecrits par test16
! *                 via les routines de niveau 2
! *                 - equivalent a test17.f90
! *
! ******************************************************************************

program test17
  
  implicit none
  include 'med.hf'

  integer      :: cret,ret, fid, nse2, mdim 
  integer,     allocatable, dimension(:) ::se2
  character*16, allocatable, dimension(:) ::nomse2
  integer,     allocatable, dimension(:) ::numse2,nufase2 
  integer      ntr3
  integer,     allocatable, dimension(:) ::tr3
  character*16, allocatable, dimension(:) ::nomtr3
  integer,     allocatable, dimension(:) ::numtr3
  integer,     allocatable, dimension(:) ::nufatr3
  character*32  :: maa = "maa1"
  character*200 :: desc
  logical      :: inoele1,inuele1,inoele2,inuele2
  integer      tse2,ttr3
  integer i,type

  !   ** Ouverture du fichier test16.med en lecture seule **
  call efouvr(fid,'test16.med',MED_LECTURE, cret)
  print *,cret

  !   ** Lecture des informations sur le 1er maillage **
  if (cret.eq.0) then
     call efmaai(fid,1,maa,mdim,type,desc,cret)
     print *,"Maillage de nom : ",maa," et de dimension ",mdim
  endif
  print *,cret

   !  ** Lecture du nombre de triangles et de segments **
  if (cret.eq.0) then
     call efnema(fid,maa,MED_CONN,MED_ARETE,MED_SEG2,MED_DESC,nse2,cret)
  endif
  print *,cret

  if (cret.eq.0) then
     call efnema(fid,maa,MED_CONN,MED_MAILLE,MED_TRIA3,MED_DESC,ntr3,cret)
  endif
  print *,cret

  print *,"Nombre de MED_SEG2 : ",nse2," - nombre de MED_TRIA3 : ",ntr3

  !  ** Allocations memoire ** 
  tse2 = 2;  
  allocate(se2(tse2*nse2),nomse2(nse2),numse2(nse2),nufase2(nse2),STAT=ret)
  ttr3 = 3;
  allocate(tr3(ntr3*ttr3),nomtr3(ntr3),numtr3(ntr3),nufatr3(ntr3),STAT=ret)
 
  !  ** Lecture des aretes segments MED_SEG2 : 
  !     - Connectivite,
  !     - Noms (optionnel)
  !     - Numeros (optionnel)
  !     - Numeros de familles **
  if (cret.eq.0) then
     call efelel(fid,maa,mdim,se2,MED_NO_INTERLACE,nomse2,inoele1,numse2,inuele1,    &
          &			  nufase2,nse2,MED_ARETE,MED_SEG2,MED_DESC,cret)
  endif
  print *,cret
        
  
  !  ** lecture des mailles triangles MED_TRIA3 : 
  !     - Connectivite,
  !     - Noms (optionnel)
  !     - Numeros (optionnel)
  !     - Numeros de familles **
  if (cret.eq.0) then
     call efelel(fid,maa,mdim,tr3,MED_NO_INTERLACE,nomtr3,inoele2,numtr3,inuele2,  &
          &			  nufatr3,ntr3,MED_MAILLE,MED_TRIA3,MED_DESC,cret)
  endif
  print *,cret
 
  ! ** Fermeture du fichier **
  call efferm (fid,cret)
  print *,cret
	
  ! ** Affichage **
  if (cret.eq.0) then
      print *,"Connectivite des segments : ",nse2
     
      if (inoele1) then
         print *,"Noms des segments : ",nomse2
      endif

      if (inuele1) then
         print *,"Numeros des segments : ",numse2
      endif

      print *,"Numeros des familles des segments : ",nufase2
  
      
      print *,"Connectivite des triangles : ",tr3
      
      if (inoele2) then
         print *,"Noms des triangles :", nomtr3
      endif

      if (inuele2) then
	  print *,"Numeros des triangles :", numtr3
      endif

      print *,"Numeros des familles des triangles :", nufatr3
      
   end if

   
   ! ** Nettoyage memoire **
   deallocate(se2,nomse2,numse2,nufase2);
   deallocate(tr3,nomtr3,numtr3,nufatr3);

   ! ** Code retour
   call efexit(cret)
   
 end program test17
