AC_DEFUN([MED_CHECK_HDF5],dnl
[

## Guess where as hdf5 is located by the HDF5HOME environement varaible
## or by the --with-hdf5 option

AC_ARG_WITH([hdf5],
            AC_HELP_STRING([--with-hdf5=<path>],
	                   [Use <path> for HDF5 path]),
	    [],
	    [withval=yes])

if test ! "x$withval" = "xno"
then

## If user hasn't provided hdf5 path try using "$HDF5HOME" or /usr if "$HDF5HOME" is empty 
    test "x$withval" = "xyes" && hdf5home=${HDF5HOME} || hdf5home=$withval
    test -z "$hdf5home" &&  hdf5home="/usr"
				       
    if test -n "$hdf5home" && test -d "$hdf5home" ; then
   
      LDFLAGS="-L$hdf5home/lib $LDFLAGS"
      CPPFLAGS="$CPPFLAGS -I$hdf5home/include"
    
      AC_CHECK_LIB([hdf5],[H5open],[],AC_MSG_ERROR([either use HDF5HOME env. var. or --with-hdf5=<path>]),[])
      AC_CHECK_PROG([H5DUMP],[h5dump],[$hdf5home/bin/h5dump],[no],[$hdf5home/bin],[])

      if test "X$H5DUMP" = "Xno"; then
         AC_MSG_ERROR([Can't find h5dump, please verify your env. var. PATH])
      fi

    else

      AC_MSG_WARN([bad directory for HDF5 : $hdf5home])
      AC_MSG_ERROR([either use HDF5HOME env. var. or --with-hdf5=<path>])

    fi

else
## In case user explicitly ask to not use hdf5 !
    AC_MSG_WARN([Can't compile MED without hdf5])
    AC_MSG_ERROR([either use HDF5HOME env. var. or --with-hdf5=<path>])
fi
])

