/*************************************************************************
* COPYRIGHT (C) 1999 - 2005  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>

#include <stdlib.h>
#include <string.h>

med_err
MEDstructureCoordEcr(med_idt fid,char *maillage,med_int mdim,med_int *structure)
{
  med_idt maaid, noeid, dataset;
  med_err ret;
  med_size dimd[1];
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  char nom_dataset[MED_TAILLE_NOM_ENTITE+1];
  char nom_attribut[MED_TAILLE_NOM_ENTITE+1];
  med_int att;
  med_maillage maillage_type;
  med_type_grille type;
  med_int i;

  /*
   * On inhibe le gestionnaire d'erreur HDF
   */
  _MEDmodeErreurVerrouiller();

  /*
   * Si le maillage n'existe pas => erreur
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maillage);
  if ((maaid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
      return -1;

  /*
   * Si le maillage est de type MED_NON_STRUCTURE => erreur 
   */
  if ((ret = _MEDattrEntierLire(maaid,MED_NOM_TYP,&att)) < 0)
    return -1;
  maillage_type = (med_int) att;
  if (maillage_type == MED_NON_STRUCTURE)
    return -1;

  /*
   * Si la grille n'est pas de type MED_GRILLE_STANDARD  
   * => erreur
   */
  if ((ret = _MEDattrEntierLire(maaid,MED_NOM_GTY,&att)) < 0)
    return -1;
  type = (med_type_grille) att;
  if (type != MED_GRILLE_STANDARD)
    return -1;

  /*
   * Si le groupe HDF "NOE" n'existe pas on le cree
   */
  if ((noeid = _MEDdatagroupOuvrir(maaid,MED_NOM_NOE)) < 0)
    if ((noeid = _MEDdatagroupCreer(maaid,MED_NOM_NOE)) < 0)
      return -1;
  
  /*
   * On ouvre le dataset HDF pour y placer les attributs
   * (taille de chaque dimension)
   */
  strcpy(nom_dataset,MED_NOM_COO);
  if ((dataset = _MEDdatasetOuvrir(noeid,nom_dataset)) < 0)
    return -1;

  
  /*
   * Attribut NBR (taille du tableau d'indices)
   */
  for (i=0;i<mdim;i++) {

    switch(i) {
    case 0 :
      strcpy(nom_attribut,MED_NOM_IN1);
      break;
      
    case 1 :
      strcpy(nom_attribut,MED_NOM_IN2);
      break;

    case 2 :
      strcpy(nom_attribut,MED_NOM_IN3);
      break;

    default :
      return -1;
    }

    att = *(structure+i);
    if ((ret = _MEDattrEntierEcrire(dataset,nom_attribut,&att)) < 0)
      return -1;
  }

  /*
   * On ferme tout
   */
  if ((ret = _MEDdatasetFermer(dataset)) < 0)
    return -1;
  if ((ret = _MEDdatagroupFermer(noeid)) < 0)
    return -1;
  if ((ret = _MEDdatagroupFermer(maaid)) < 0)
    return -1;

  return 0; 
}
