C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************


C       ******************************************************************************
C       * - Nom du fichier : test16.f
C       *
C       * - Description : ecriture d'elements d'un maillage MED
C       *                 via les routines de niveau 2
C       *                 - equivalent a test6.f
C       *
C       ******************************************************************************
	program test16         
C       
	implicit none             
	include 'med.hf'
C	
C
	integer      cret, fid, mdim, nse2, ntr3
	character*32 maa
	parameter    (mdim = 2,nse2 = 5,maa = "maa1", ntr3 = 2)
	integer      se2   (2*nse2)
	character*16  nomse2(nse2)
	integer      numse2(nse2),nufase2(nse2)
	integer      tr3   (3*ntr3)
	character*16  nomtr3(ntr3)
	integer      numtr3(ntr3), nufatr3(ntr3) 
	data se2    /1,2,1,3,2,4,3,4,2,3/
	data nomse2 /"se1","se2","se3","se4","se5"/
	data numse2 /1,2,3,4,5/, nufase2 /-1,-1,0,-2,-3/
	data tr3    /1,2,-5,-5,3,-4/
	data nomtr3 /"tr1","tr2"/,numtr3/4,5/,nufatr3/0,-1/
	
C       ** Creation du fichier test16.med **
	call efouvr(fid,'test16.med',MED_CREATION, cret)
	print *,cret
	
C       ** Creation du maillage **
	if (cret .eq. 0) then
	   call efmaac(fid,maa,mdim,MED_NON_STRUCTURE,
     C                  'Un maillage pour test16',cret)
	endif
	print *,cret  
	
C       ** Ecriture des aretes segments MED_SEG2 :
C       - Connectivite
C       - Noms (optionnel) 
C       - Numeros (optionnel)
C       - Numeros des familles **
	if (cret .eq. 0) then
	   call efelee(fid,maa,mdim,se2,MED_NO_INTERLACE,
     C         nomse2,MED_VRAI,numse2,MED_VRAI,
     C         nufase2,nse2,MED_ARETE,MED_SEG2,MED_DESC,cret)
	endif
	print *,cret  

C       ** Ecriture des mailles MED_TRIA3 :
C     - Connectivite
C     - Noms (optionnel) 
C     - Numeros (optionnel)
C     - Numeros des familles **
	if (cret .eq. 0) then
	   call efelee(fid,maa,mdim,tr3,MED_NO_INTERLACE,
     C      nomtr3,MED_VRAI,numtr3,MED_VRAI,
     C      nufatr3,ntr3,MED_MAILLE,MED_TRIA3,MED_DESC,cret)
	endif
	print *,cret  
	
C       ** Fermeture du fichier **
	
	call efferm (fid,cret)
	print *,cret
	
	end 

