/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test16.c
 *
 * - Description : ecriture d'elements de maillages MED
 *                 via les routines de niveau 2
 *                 - equivalent a test6.c
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
  med_idt fid;
  med_int nse2 = 5;
  med_int se2[10] = {1,2,1,3,2,4,3,4,2,3};
  char nomse2[MED_TAILLE_PNOM*5+1]="se1     se2     se3     se4     se5     ";
  med_int numse2[5] = {1,2,3,4,5};
  med_int nufase2[5] = {-1,-1,0,-2,-3}; 
  med_int ntr3 = 2;
  med_int tr3[6] = {1,2,-5,-5,3,-4};
  char nomtr3[MED_TAILLE_PNOM*2+1] = "tr1     tr2     ";
  med_int numtr3[2] = {4,5};
  med_int nufatr3[2] = {0,-1};
  char maa[MED_TAILLE_NOM+1] = "maa1";
  med_int mdim = 2;

  /* Creation du fichier test16.med */
  if ( (fid = MEDouvrir("test16.med",MED_CREATION) ) < 0) {
    MESSAGE("Impossible de creer le fichier test16.med : ");
    return -1;
  }

  /* Creation du maillage */
  if ( MEDmaaCr(fid,maa,mdim,MED_NON_STRUCTURE,
		   "un maillage pour test16") < 0 ) {
    MESSAGE("Impossible de creer le maillage : ");
    return -1;
  }

  /* Ecriture des aretes segments MED_SEG2 :
     - connectivite
     - noms (optionnel) 
     - numeros (optionnel)
     - numeros des familles */
  if ( MEDelementsEcr(fid,maa,mdim,se2,MED_NO_INTERLACE,nomse2,MED_VRAI,numse2,MED_VRAI,
			 nufase2,nse2,MED_ARETE,MED_SEG2,MED_DESC)< 0 ) {
    MESSAGE("Impossible d'ecrire la connectivit des aretes : ");
    return -1;
  }

  /* Ecriture des mailles MED_TRIA3 :
     - Connectivite
     - Noms (optionnel) 
     - Numeros (optionnel)
     - Numeros des familles */
  if ( MEDelementsEcr(fid,maa,mdim,tr3,MED_NO_INTERLACE,nomtr3,MED_VRAI,numtr3,MED_VRAI,
			 nufatr3,ntr3,MED_MAILLE,MED_TRIA3,MED_DESC) < 0 ) {
    MESSAGE("Impossible d'ecrire les lments triangles : ");
    return -1;
  }

  /* Fermeture du fichier */
  if (  MEDfermer(fid) < 0) {
    MESSAGE("Impossible de fermerle fichier : ");
    return -1;
  }

  return 0;
  
}






