""" The absolute filenames of the plugin definitions used in the application.

The only reason that we put this in a separate module is that it often entails
lots of path and filename manipulation code that tends to clutter up 'run.py'.

The important thing to realise is that all we are doing is defining a list of
strings which are the absolute filenames of the plugin definition used in the
application!

"""

from os.path import abspath, dirname, join

# Enthought library imports.
from enthought.envisage.api import find_definition

envisage_examples_dir = dirname(dirname(dirname(abspath(__file__))))

# The plugin definitions required by the application.
PLUGIN_DEFINITIONS = [
    # Envisage plugins.
    find_definition('enthought.envisage.core.core_plugin_definition'),
    
    # Application plugins.
    join(envisage_examples_dir, 'plugin','message','plugin_definition.py'),
    join(envisage_examples_dir, 'plugin','hello_world','plugin_definition.py')
]

#### EOF ######################################################################
