""" The resource type for Python classs. """


# Standard library imports.
import inspect

# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType

# Local imports.
from class_node_type import ClassNodeType


class ClassResourceType(ObjectResourceType):
    """ The resource type for Python classs. """

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return ClassNodeType(resource_type=self)

    #### Methods ##############################################################

    def is_type_for(self, obj): 
        """ Returns True if the resource type 'recognizes' an object. """

        return inspect.isclass(obj)

##### EOF #####################################################################
