""" A simple test plugin. """


# Enthought library imports.
from enthought.envisage import Plugin
from enthought.traits.api import Bool


class SimplePlugin(Plugin):
    """ A simple test plugin. """

    # The shared plugin instance.
    instance = None

    # Has the plugin been started.
    started = Bool(False)
    
    ###########################################################################
    # 'object' interface.
    ###########################################################################

    def __init__(self, **kw):
        """ Creates a new plugin. """

        # Base-class constructor.
        super(SimplePlugin, self).__init__(**kw)

        # Set the shared instance.
        SimplePlugin.instance = self
        
        return

    ###########################################################################
    # 'Plugin' interface.
    ###########################################################################

    def start(self, application):
        """ Starts the plugin.

        Can be called manually, but is usually called exactly once when the
        plugin is first required.

        """

        self.started = True

        # fixme: Hmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
        self.preferences.defaults
        
        return
    
    def stop(self, application):
        """ Stops the plugin.

        Can be called manually, but is usually called exactly once when the
        application exits.

        """

        self.started = False
        
        return

#### EOF ######################################################################
