""" Definition of the Additions plugin. 

    This plugin assumes that the (deprecated) UI plugin is used to create the 
    GUI. Do not extend this plugin if you are using the (recommended) Workbench
    plugin.
"""

# Plugin extension-point imports.
from enthought.envisage.core.core_plugin_definition \
     import PluginDefinition

from enthought.envisage.ui.preference.preference_plugin_definition \
     import PreferencePages, Page

from enthought.envisage.resource.resource_plugin_definition \
     import ResourceType, ResourceManager, FILE_RESOURCE_TYPE

from enthought.envisage.resource.resource_ui_plugin_definition \
     import CookieImplementation, CookieImplementations

# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = 'enthought.envisage.additions'

###############################################################################
# Extensions.
###############################################################################

#### Preference pages #########################################################

# UI pages for setting this plugin's preferences.
preference_pages = PreferencePages(
    pages = [
        Page(
            id         = ID + "AdditionsPreferencePage",
            class_name = ID + \
                       ".ui.additions_preference_page.AdditionsPreferencePage",
            name       = "Additions",
            category   = "",
        )
    ]
)

#### Resource types ###########################################################

# ID prefix for the PluginResourceType.
PLUGIN_RESOURCE_TYPE = ID + \
               '.resource_type.plugin_resource_type.PluginResourceType'

# Resource types for this plugin.
resource_types = ResourceManager(
    resource_types = [
        ResourceType(
            class_name = PLUGIN_RESOURCE_TYPE,
            precedes = [FILE_RESOURCE_TYPE]
        ),
        ]
    )

#### Cookie implementations ###################################################

# ID prefix for the Project plugin.
PROJECT = 'enthought.envisage.project'

# Implementations of cookies used by this plugin.
cookie_implementations = CookieImplementations(
    implementations = [
        CookieImplementation(
            cookie_interface = PROJECT + '.action.open_cookie.OpenCookie',
            resource_type = PLUGIN_RESOURCE_TYPE, 
            cookie_implementation = ID + \
                       '.cookie.open_plugin_cookie.OpenPluginCookie'
        ),
        ]
    )
###############################################################################
# The plugin definition!
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = ID,

    # General information about the plugin.
    name          = "Additions Plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = True,

    # The Id's of the plugins that this plugin requires.
    requires = [
        "enthought.envisage.core",
        "enthought.envisage.ui",
        "enthought.envisage.ui.preference",
        "enthought.envisage.resource",
        "enthought.envisage.resource_ui",
    ],

    # The extension points offered by this plugin,
    extension_points = [],
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [
                  resource_types,
                  cookie_implementations,
                  preference_pages,
                  ],
)

#### EOF ######################################################################
