"""

Warps the geometry using the vtkWarpVector filter.  vtkWarpVector is a
filter that modifies point coordinates by moving points along vector
times the scale factor.  Useful for showing flow profiles or
mechanical deformation.

This code is distributed under the conditions of the GPL (GNU General
Public License).  Look at the file LICENSE included with the
distribution for details.

Copyright (C) 2001, Prabhu Ramachandran.
"""

__author__ = "Prabhu Ramachandran <prabhu@aero.iitm.ernet.in>"
__version__ = "$Revision: 1.2 $"
__date__ = "$Date: 2001/11/03 09:23:34 $"
__credits__ = """Many thanks to Jose Paulo <moitinho@civil.ist.utl.pt>
for providing an initial version of this Filter."""

import PolyDataNormals, Base.Objects
import Common
import Tkinter
import vtkpython
import vtkPipeline.vtkMethodParser

debug = Common.debug

class WarpVector (PolyDataNormals.PolyDataNormals):

    """ Warps the geometry using the vtkWarpVector filter.
    vtkWarpVector is a filter that modifies point coordinates by
    moving points along vector times the scale factor. Useful for
    showing flow profiles or mechanical deformation."""
    
    def initialize (self):
        debug ("In WarpVector::initialize ()")
        self.fil = vtkpython.vtkWarpVector ()
        self._set_input ()
        self.scale_var = Tkinter.DoubleVar ()
        self.scale_var.set (1.)
        self.fil.SetScaleFactor (self.scale_var.get ()) # Default setting
        self.fil.Update ()

    configure = Base.Objects.Filter.configure

    def make_custom_gui (self):
        debug ("In WarpVector::make_custom_gui()")
        self.make_main_gui ()
        self.make_close_button ()

    def _get_ranges (self, val):
        debug ("In WarpVector::_get_ranges ()")
        if val == 0.0:
            res, min_v, max_v = 0.1, -1.0, 1.0
        elif val > 0:
            res = val/10.0
            min_v = val - 50*res
            max_v = val + 50*res
            #min_v = max (0, min_v)
        else:
            res = abs (val)/10.0
            min_v = val - 50*res
            max_v = val + 50*res
            #max_v = min (0, max_v)
        return res, min_v, max_v

    def make_main_gui (self):
        debug ("In WarpVector::make_main_gui()")
        frame = Tkinter.Frame (self.root, relief='ridge', bd=2)
        frame.pack (side='top', fill='both', expand=1)

        cur_scale = self.fil.GetScaleFactor ()
        res, min_v, max_v = self._get_ranges (cur_scale)
        
        self.scale_res_var = Tkinter.DoubleVar ()
        self.scale_res_var.set (res)
        self.min_scale_var = Tkinter.DoubleVar ()
        self.min_scale_var.set (min_v)
        self.max_scale_var = Tkinter.DoubleVar ()
        self.max_scale_var.set (max_v)

        rw = 0
        sl = Tkinter.Scale (frame, label="Set Scale Factor", 
                            from_= self.min_scale_var.get (),
                            to = self.max_scale_var.get (),
                            length="5c", orient='horizontal', 
                            resolution=self.scale_res_var.get ())
        sl.set (cur_scale)
        sl.grid (row=rw, column=0, columnspan=2, sticky='ew')
        rw = rw + 1
        sl.bind ("<ButtonRelease>", self.change_scale)
        self.scale_slider = sl
        lab = Tkinter.Label (frame, text="Scale resolution: ")
        lab.grid (row=rw, column=0, sticky='w')
        entr = Tkinter.Entry (frame, width=5, relief='sunken',
                              textvariable=self.scale_res_var)
        entr.grid (row=rw, column=1, sticky='ew')
        entr.bind ("<Return>", self.set_scale_resolution)
        rw = rw+1

        lab = Tkinter.Label (frame, text="Minimum scale:")
        lab.grid (row=rw, column=0, sticky='w')
        entry = Tkinter.Entry (frame, width=10, relief='sunken', 
                               textvariable=self.min_scale_var)
        entry.grid (row=rw, column=1, sticky='we')
        entry.bind ("<Return>", self.change_scale_limits)
        rw = rw+1

        lab = Tkinter.Label (frame, text="Maximum scale:")
        lab.grid (row=rw, column=0, sticky='w')
        entry = Tkinter.Entry (frame, width=10, relief='sunken', 
                               textvariable=self.max_scale_var)
        entry.grid (row=rw, column=1, sticky='we')
        entry.bind ("<Return>", self.change_scale_limits)

    def set_scale_resolution (self, event=None):
        """ Called when the scale slider resolution is changed. """
        debug ("In WarpVector::set_scale_resolution()")
        self.scale_slider.config (resolution=self.scale_res_var.get ())

    def change_scale (self, event=None):
        debug ("In WarpVector::change_scale()")
        Common.state.busy ()
        self.fil.SetScaleFactor (self.scale_slider.get())
        self.mod_m.Update ()
        Common.state.idle ()

    def change_scale_limits (self, event=None):
        debug ("In WarpVector::change_scale_limits()")
        self.scale_slider.config (from_ = self.min_scale_var.get(),
                                  to = self.max_scale_var.get())

 
