#!/usr/bin/perl
# @(#) chr_update.pl	2005-05-20	Falko Flessner
#
# Changeroot-Archive mit dem "Muttersystem" abgleichen.
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#
BEGIN {
	if ($^O =~ /win32/i)
	{
		print "No Windows";
		exit(1);
	} else {
		unshift @INC, (	"/devtool/TOOL/tool/lib/perl5", 
				"/devtool/TOOL/tool/lib/Perl", 
				"/devtool/TOOL/tool/bin", 
				"/SAP_DB/TESTDB", 
				"/SAP_DB/TESTDB/lib");
	}
}
	

use strict;
use IO::Handle;
use Sys::Hostname;
use QAConnect;
use Getopt::Long;
use Net::HTTP;

#
# Basiscs b4 Rock'nRoll
#
print "\n\nchr_update v0.1a (c)2005, SAP AG\n\n";

my %opts;

unless (GetOptions(\%opts, , 'debug', 'dry'))
{
	print <<HELP_END;
Usage:	chr_update.pl [-debug] 
			
 We are doing all automatically, you may give me a -debug

 -dry does not copy any files, links or direcotries
 
HELP_END
	exit(1);
}



#
# Init
#
my $arch_base = "/SAP_DB/chr/arch";
my $root_base = "/";

# Statistics
my $files_processed = 0;
my $direc_processed = 0;
my $links_processed = 0;
my $files_updated   = 0;
my $files_ignored   = 0;
my $files_inform    = 0;
my $files_unmatched = 0;
my $direc_updated   = 0;

my $rc;
my $href;
my $listhref;


# Hostname
my $archive_changed = 0;
my $host  = lc(hostname());

# Idserver

my $stmt = "select ID from SERVERS  where HOST = '$host'";
($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", $stmt, 1);
		
unless ($href->{'Rows'}->{'Row'}[0]->{'ID'}) {
	&errout("Could not get the IDSERVER ". $href->{'Rows'}->{'Row'}[0]->{'ID'});
	exit 1;
}
my $idserver = $href->{'Rows'}->{'Row'}[0]->{'ID'};

($rc, $listhref) = QAConnect::httpsql_request("QADB_HTTPSQL", 
		"SELECT idfiltertype, regex " .
		" FROM chr_upd_filters " .
		" WHERE idserver = $idserver " .
		" ORDER BY prio DESC", 1);

unless (ref($listhref)) {
	&errout("Could not recive a filterlist\n");
	return 1;
}

#
# Clean up in the Database
#

($rc, $href)  = QAConnect::httpsql_request("QADB_HTTPSQL", 
		"delete from CHR_UPD_FILELISTS where IDSERVER = $idserver", 0);

&cmp_dir($arch_base, $root_base);

&send_statistic();

print
"\n\n##### FINISHED, NOW SERVING STATISTICS ############################\n\n";
printf "     %6d total files processed\n", $files_processed;
printf "     %6d total directories processed\n", $direc_processed;
printf "     %6d total links processed\n", $links_processed;
printf "     %6d files updated\n", $files_updated;
printf "     %6d files ignored\n", $files_ignored;
printf "     %6d files unmatched\n", $files_unmatched;
printf "     %6d files for information\n", $files_inform;
printf "     %6d directories updated\n", $direc_updated;
print "\n Good bye.\n";




sub cmp_dir {
	my $arch_dir  = shift;
	my $root_dir = shift;
	
	my @arch_inode;
	my @root_inode;
	
	my $bufsize = 1019200;
	my $io_buf;
	
	if ((not defined $arch_dir) or (not defined $root_dir)) {
		return 0;
	}
	
	
	if (not(-d $arch_dir)) {
		return 0;
	}
	
	$direc_processed++;
	my $src_hdl = new IO::Handle;
	
	opendir ($src_hdl, $arch_dir);
	
	while (my $curfile = readdir($src_hdl)) {
		if ($curfile =~ /^\./) {
			next;
		}
		$files_processed++;
		
		my $arch_file = $arch_dir . "/" . $curfile;
		my $root_file = $root_dir . "/" . $curfile;
		
		$arch_file =~ s/^\/\//\//;
		$root_file =~ s/^\/\//\//;
		
		if (-l $arch_file) {
			&cmp_link($arch_file, $root_file);
			next;
		} elsif (-d $arch_file)  {
			&cmp_dir($arch_file, $root_file);
			next;
		} elsif (not (-f $arch_file))  {
			next;
		} elsif (not (-e $root_file)) {
			&insert_in_filelist(6, $root_file);
			next;
		}
		
		
		@arch_inode = stat ($arch_file);
		@root_inode = stat ($root_file);
		
		if ($root_inode[9] > $arch_inode[9]) {
			&process_new($root_file);
		}
	}
	closedir($src_hdl);
	return 1;
}

sub process_new {
	my $filename = shift;
	
	my $round = 0;
	
	foreach my $entry (@{$listhref->{'Rows'}->{'Row'}}) {
		$round++;
		if ($filename =~ /$entry->{'REGEX'}/ ) {
			if      ($entry->{'IDFILTERTYPE'} == 1) { # Ignore
				$files_ignored++;
				# Nothing else to do here 
				# Just make sure we don't hit the else-clause
			} elsif ($entry->{'IDFILTERTYPE'} == 2) { # Automatic Update
				&update_chr_arch($filename);
				$files_updated++;
			} elsif ($entry->{'IDFILTERTYPE'} == 3) { # Inform
				&inform_new_file($filename);
				$files_inform++;
			} elsif ($entry->{'IDFILTERTYPE'} == 4) { # Update the whole directory
				&update_directory($filename);
				$direc_updated++;
			}
			return 0;
		}
		
	}
	&register_new_file($filename);
}

sub cmp_link {
	my $src_link = shift;
	my $dest_link = shift;
	
	if (readlink($src_link) ne readlink($dest_link)) {
		&insert_in_filelist(7, $dest_link);
	}
	$links_processed++;
	return 0;
}

sub update_chr_arch {
	my $filename = shift;
	
	&dbgout("Updating $filename");
	&cp_file($filename, $arch_base . "/" . $filename);
	&insert_in_filelist(2, $filename);
}

sub inform_new_file {
	my $filename = shift;
	
	&dbgout("Informing $filename");
	&insert_in_filelist(3, $filename);
}

sub update_directory {
	my $filename = shift;
	
	my $dirname = substr($filename, 0, rindex($filename, '/'));
	
	&dbgout("Update directory $dirname from $filename");
	&cp_dir($dirname, $arch_base . $dirname);
	&insert_in_filelist(4, $filename);
}

sub register_new_file {
	my $filename = shift;
	
	&dbgout("Will register $filename");
	&insert_in_filelist(5, $filename);
}


sub insert_in_filelist {
	my $filtertype = shift;
	my $filename   = shift;
	
	my $rc;
	my $href;
	
	my $stmt =      "insert into CHR_UPD_FILELISTS "  . 
			" (IDFILTERTYPE, IDSERVER, PATH) " .
			" values " . 
			" ($filtertype, $idserver, '$filename')";
			
	($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", $stmt, 1);
}		



sub cp_dir {
	my $src_dir  = shift;
	my $dest_dir = shift;
	
	my $bufsize = 1019200;
	my $io_buf;
	
	my $src_file;
	my $dest_file;
	
	if ((not defined $src_dir) or (not defined $dest_dir)) {
		return 0;
	}
	
	my @dir_list = split('/', $dest_dir);
	my @create_list = ();
	
	while (scalar(@dir_list) > 0) {
		if (-d join('/', @dir_list)) {
			last;
		}
		push(@create_list, pop(@dir_list));
	}
	
	while (scalar(@create_list) > 0) {
		push(@dir_list, pop(@create_list));
		mkdir (join('/', @dir_list), 0777);
	}
	
	if (not (-w $dest_dir)) {
		return 0;
	}
	
	if (not(-d $src_dir)) {
		return 0;
	}
	
	my $src_hdl = new IO::Handle;
	
	opendir ($src_hdl, $src_dir);
	
	while (my $cp_name = readdir($src_hdl)) {
		if ($cp_name =~ /^\./) {
			next;
		}
		
		$src_file  = $src_dir  . "/" . $cp_name;
		$dest_file = $dest_dir . "/" . $cp_name;
		
		if (-l ($src_file)) {
			&set_link(readlink($src_file), $dest_file);
		} elsif (-f ($src_file))  {
			&cp_file($src_file, $dest_file);
		} 
	}
	closedir($src_hdl);
	return 1;
}

sub set_link {
	my $link_name = shift;
	my $link_to = shift;
	
	# Do not copy if "-dry"
	if ($opts{'dry'}) {
		return 0;
	}
	
	if (-e $link_name) {
		unlink $link_name;
	}
	
	link $link_to, $link_name;
}
	
	

sub cp_file {
	my $src_file = shift;
	my $dest_file = shift;
	
	# Do not copy if "-dry"
	if ($opts{'dry'}) {
		return 0;
	}
	
	my $bufsize = 1019200;
	my $io_buf;
	
	if (-d $dest_file) {
		$dest_file .= (split('/', $src_file))[-1];
	} 
	
	if (-l $src_file) {
		return 1;
	}
	
			
	open (I_HDL,       $src_file)  or return 1;
	open (O_HDL, ">" . $dest_file) or return 1;
	
	while (read(I_HDL, $io_buf, $bufsize)) {
		print O_HDL $io_buf;
	}
	
	close I_HDL;
	close O_HDL;

	# Set rights and ownder
	my @src_stat = stat($src_file);
	chmod ($src_stat[2], ($dest_file));
	chown $src_stat[4], $src_stat[5], ($dest_file);
	&dbgout("Copied $src_file to $dest_file");
	return 0;
}

sub dbgout {
	my $str = shift;
	print ">>DEBUG: $str\n" if ($opts{'debug'});
}

sub errout {
	my $str = shift;
	print ">>ERROR: $str\n";
}

sub send_statistic {
	my $rc;
	my $href;
	my $stmt = "insert into CHR_UPD_STAT (" . 
	  "IDSERVER, FILES_PROCESSED, DIREC_PROCESSED, LINKS_PROCESSED, " .
	  "FILES_UPDATED, FILES_IGNORED, FILES_INFORM, FILES_UNMATCHED, " .
	  " DIREC_UPDATED) VALUES (" .
	  "$idserver, $files_processed, $direc_processed, $links_processed, " .
	  "$files_updated, $files_ignored, $files_inform, $files_unmatched, " .
	  "$direc_updated)";

	($rc, $href)  = QAConnect::httpsql_request("QADB_HTTPSQL", "$stmt", 0);
}

