
BEGIN {
	unshift @INC, "$ENV{'TOOL'}/lib/perl5";
}

use strict;
use Base::Module;
use Getopt::Long;

my %opts;

if(!GetOptions(\%opts, 'm', 'quiet', 'f', 'h') || !@ARGV || $opts{'h'}) {
	print "\nUsage: killpstree [-m] [-quiet] <PID> [<PID> ...]\n\n";
	print "Where:     -m     shows verbose module loading information\n";
	print "           -quiet suppresses any console output\n";
	print "           -f     force a hard kill instead of soft terminate\n\n";
	print "NOTE: The return code corresponds to the number of processes failed to kill!\n\n";
	exit(0);
}

print "Killpstree v1.00a, (c)2004 SAP AG\n\n" unless ($opts{'quiet'});

$Module::Verbose = 1 if ($opts{'m'} && !$opts{'quiet'});

my ($useKillTree, $err) = Module::Use('Process::Tree');
print STDERR "Error:$err" if ($err);

$Process::Tree::Verbose = 1 unless ($opts{'quiet'});

my ($killed, $found) = (0,0);

foreach my $pid (@ARGV) {
	my $proctree = Process::Tree->new();

	if ($proctree) {
		print "\n" unless ($opts{'quiet'});
	} else {
		print STDERR "Error building process tree!\n\nExiting...\n";
		exit(1);
	}

	print ($opts{'f'} ? "Killing tree for PID $pid:\n\n" : "Terminating tree for PID $pid:\n\n") unless ($opts{'quiet'});
	if ($opts{'f'}) {
		my ($tmpkilled, $tmpfound) = $proctree->KillGroup($pid);
		$killed += $tmpkilled;
		$found += $tmpfound;
	} else {
		my ($tmpkilled, $tmpfound) = $proctree->TerminateGroup($pid);
		$killed += $tmpkilled;
		$found += $tmpfound;
	}

}

print "\nFound Processes: $found\n" unless($opts{'quiet'});
print "Successfully " . ($opts{'f'} ? "killed" : "terminated") . ": $killed\n\n" unless($opts{'quiet'});

exit($found - $killed);

