/*

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
#define PREPSTMT
#include <string.h>
#include <stdio.h>
#include "vpc13.h"
#include "vpc31.h"

/* constants for universal ((non)Unicode) delimter of strings*/
#define STRING_LIT_BEG	"sqlctoR(\""            /* sqlctoR("  */
#define STRING_LIT_END  "\")"                    /*        ") */

void p13intcat (char *buf, const char *cast, int npar, const tsp00_Int4 par [])
{
	int i;
	long p;
	
	strcat (buf, cast);
	sprintf (buf + strlen (buf), "%ld", p = par [0]);
	for (i = 1; i < npar; i++)
	{
		strcat (buf, ",");
		strcat (buf, cast);
		sprintf (buf + strlen (buf), "%ld", p = par [i]);
	}
}

void p13dynparameter (void (*outstmt) (tpc_globals*),
	void (*outcnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode)
{
	static const int src1 = 0, src2 = 2, src3 = 3, src4 = 22, src5 = 23;
	char **code = scode->dynparameter;
	tsp00_Int4  *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	tsp00_Int4 par [19];
	int i, j;
	
	par [ 0] = pc->pcPa;
	par [ 1] = pc->pcSa;
	par [ 2] = pc->pcKa;
	par [ 3] = pc->pcPr;
	par [ 4] = pc->pcSt + pc->pcStstm;
	par [ 5] = pc->pcSt;
	par [ 6] = pc->pcDi;
	par [ 7] = pc->pcNa;
	par [ 8] = pc->pcOp;
	par [ 9] = (pc->sqlca.sqldbmode == CPR_KIND_DB2) ? 0 : pc->pcDa;
	par [10] = pc->pcSqlva.va1cnt;
	par [11] = pc->pcSqlva.va2cnt;
	par [12] = pc->pcSqlva.va3cnt;
	par [13] = 0;
	par [14] = 0;
	par [15] = pc->pcFa;
	par [16] = pc->pcFn;
	par [17] = pc->pcAt;
	par [18] = pc->pcCu;
	for (i = 0; i <= 18; i++)
		if (i != 5 && (pc->sqlca.sqlrap->ralang != CPR_LA_C || i < 6 ||
			(i > 9 && i != 16)))
			if (par [i] == 0)
				par [i] = 1;
	for (i = src1; i <= src2; i++)
	{
		*syposacc = 1;
		strcpy (partbuf, code [i]);
		*part1len = strlen (partbuf) + *syposacc;
		if (i == src1)
			outstmt (pc);
		else
			outcnt (pc);
	}
	for (i = src3; i <= src4; i++)
	{
		if (strcmp (code [i], "") == 0)
			continue;
		*syposacc = 1;
		strcpy (partbuf, code [i]);
		j = i - src3 - 1;
		if (j >= 0)
			p13intcat (partbuf, "", 1, &par [j]);
		*part1len = strlen (partbuf) + *syposacc;
		if (i == src3)
			outstmt (pc);
		else
			outcnt (pc);
	}
	*syposacc = 1;
	strcpy (partbuf, code [src5]);
	*part1len = strlen (partbuf) + *syposacc;
	outcnt (pc);
	outstmt (pc);
}

void p13bsqlstart (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	const char *cast = "(long)";
	char **code = scode->bsqlstart;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	typedef int SEQ [8];
	int i, j, jseq = 0;
	SEQ src1, src2, npar;
	tsp00_Int4 par [2];
	
	par [0] = pc->pcOpts.variant.C_sp4co_sql_precompiler.opt_extern_F;
	par [1] = pc->pccmdpart.partsizlen;
	src1 [jseq] = 0;
	src2 [jseq] = 0;
	npar [jseq++] = 0;
	src1 [jseq] = 1;
	src2 [jseq] = 1;
	npar [jseq++] = 2;
	src1 [jseq] = 2;
	src2 [jseq] = 14;
	npar [jseq++] = 0;
	if (pc->pcDi > 0)
	{
		src1 [jseq] = 15;
		src2 [jseq] = 15;
		npar [jseq++] = 0;
	}
	if (pc->pcNa > 0)
	{
		src1 [jseq] = 16;
		src2 [jseq] = 16;
		npar [jseq++] = 0;
	}
	if (pc->pcOp > 0)
	{
		src1 [jseq] = 17;
		src2 [jseq] = 17;
		npar [jseq++] = 0;
	}
	if (pc->pcDa > 0)
	{
		src1 [jseq] = 18;
		src2 [jseq] = 18;
		npar [jseq++] = 0;
	}
	if (pc->pcFn > 0)
	{
		src1 [jseq] = 19;
		src2 [jseq] = 19;
		npar [jseq++] = 0;
	}
	src1 [jseq] = 20;
	src2 [jseq] = 22;
	npar [jseq++] = 0;
	for (j = 0; j < jseq; j++)
		for (i = src1 [j]; i <= src2 [j]; i++)
		{
			*syposacc = 1;
			strcpy (partbuf, code [i]);
			if (npar [j] > 0)
			{
				p13intcat (partbuf, cast, npar [j], par);
				strcat (partbuf, ");");
			}
			*part1len = strlen (partbuf) + *syposacc;
			outstmt (pc);
		}
	outstmt (pc);
}

void p13esqlstart (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src1 = 0, src2 = 1, src3 = 2;
	char **code = scode->esqlstart;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	tsp00_Int4 par [1];
	tsp00_C40 vers;

	if (pc->sqlca.sqlgap->gamodisolation >= 0)
	{
		par [0] = pc->sqlca.sqlgap->gamodisolation;
		*syposacc = 1;
		strcpy (partbuf, code [src1]);
		p13intcat (partbuf, "", 1, par);
		strcat (partbuf, ");");
		*part1len = strlen (partbuf) + *syposacc;
		outstmt (pc);
	}

	*syposacc = 1;
	strcpy (partbuf, code [src2]);
	p07version(&vers);
	strncat (partbuf, (const char *) vers, sizeof(vers));
	strcat (partbuf, "\")");
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);

	*syposacc = 1;
	strcpy (partbuf, code [src3]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13start (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	char **code = scode->sqlstart;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tpc_wheneverentry *whe = pc->pcWhe + 4;
	tsp00_Int4 savlen = *part1len;
	
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	if (whe->whlen > 0)
	{
		*syposacc = savlen + 1;
		strcpy (partbuf, "");
		strncat (partbuf, whe->whstr, whe->whlen);
		strcat (partbuf, ";");
		*part1len = strlen (partbuf) + *syposacc;
		outstmt (pc);
	}
	outstmt (pc);
	*part1len = savlen;
}

void p13whenever (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int srcelse = 0, src1 = 1, src2 = 2, src3 = 9;
	char **code = scode->whenever;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tpc_wheneverentry *whe = pc->pcWhe + 5;
	tsp00_Int4 savlen = *part1len;
	int cont, i, j;
	int whind [4], src [7], srcind [4][4];

	whind [0] = 0;
	whind [1] = 3;
	whind [2] = 2;
	whind [3] = 1;
	src [0] = 3;
	src [1] = 4;
	src [2] = 5;
	src [3] = 5;
	src [4] = 6;
	src [5] = 7;
	src [6] = 8;
	srcind [0][0] = 0;
	srcind [0][1] = 1;
	srcind [0][2] = 2;
	srcind [0][3] = 3;
	for (i = 1; i < 4; i++)
	{
		srcind [i][0] = i + 3;
		srcind [i][1] = srcind [i][0];
		srcind [i][2] = 2;
		srcind [i][3] = 2;
	}
	cont = 0;
	*syposacc = savlen + 1;
	strcpy (partbuf, "");
	if (whe->whlen > 0)
	{
		strncat (partbuf, whe->whstr, whe->whlen);
		strcat (partbuf, ";");
		*part1len = strlen (partbuf) + *syposacc;
		outstmt (pc);
	}
	*syposacc = savlen + 1;
	strcpy (partbuf, "");
	for (i = 0; i < 4; i++)
	{
		whe = pc->pcWhe + whind [i];
		if (whe->whlen > 0)
		{
			*syposacc = savlen + 1;
			strcpy (partbuf, "");
			if (cont)
				strcat (partbuf, code [srcelse]);
			for (j = srcind [i][0]; j <= srcind [i][1]; j++)
			{
				strcat (partbuf, code [src [j]]);
				*part1len = strlen (partbuf) + *syposacc;
				outstmt (pc);
				*syposacc = savlen + 1;
				strcpy (partbuf, "");
			}
			if (whe->whact == cpc_i_stop)
			{
				strcpy (partbuf, code [src1]);
				*part1len = strlen (partbuf) + *syposacc;
				outstmt (pc);
				*syposacc = savlen + 1;
				strcpy (partbuf, code [src2]);
				*part1len = strlen (partbuf) + *syposacc;
			}
			else
			{
				strncat (partbuf, whe->whstr, whe->whlen);
				strcat (partbuf, ";");
				*part1len = strlen (partbuf) + *syposacc;
			}
			for (j = srcind [i][2]; j <= srcind [i][3]; j++)
			{
				outstmt (pc);
				*syposacc = savlen + 1;
				strcpy (partbuf, code [src [j]]);
				*part1len = strlen (partbuf) + *syposacc;
			}
			cont = 1;
		}
	}
	strcat (partbuf, code [src3]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13va2bind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int va2no)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->va2bind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlva2en *va = pc->sqlxa.sqlv2p + va2no;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [6];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = va2no;
	par [1] = va->va2typ;
	par [2] = va->va2size;
	par [3] = va->va2digit;
	par [4] = va->va2frac;
	par [5] = va->va2const;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13va3bind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int va3no)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->va3bind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlva3en *va = pc->sqlxa.sqlv3p + va3no;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = va3no;
	par [1] = va->va3naml;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	strncat (partbuf, (const char *) va->va3name, va->va3naml);
	strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13cabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->cabind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlcatype *ca = &pc->sqlca;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [3];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = ca->sqldbmode;
	par [1] = ca->sqldatetime;
	par [2] = pc->sqlca.sqlrap->rasqlansi;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13xabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->xabind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	struct  tsp4_args_options_sp4co_sql_precompiler *op =
	  &pc->pcOpts.variant.C_sp4co_sql_precompiler;
	int i, j;
	tsp00_Int4 par [3];
	static const int npar = sizeof (par) / sizeof (par [0]);
	char *cpar [2];
	static const int ncpar = sizeof (cpar) / sizeof (cpar [0]);
	
	par [0] = pc->sqlca.sqlrap->ralang;
	par [1] = op->opt_prognamel_F;
	par [2] = op->opt_modulenamel_F;
	cpar [0] = (char*)op->opt_progname_F;
	cpar [1] = (char*)op->opt_modulename_F;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	for (i = 0; i < ncpar; i++)
	{
		strcat (partbuf, ",");
		strcat (partbuf, STRING_LIT_BEG);
		if (par [j = i + 1] > 0)
			strncat (partbuf, cpar [i], par [j]);
		else
			strcat (partbuf, " ");
		strcat (partbuf, STRING_LIT_END);
	}
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13pabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int pano)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->pabind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	sqlparentry *pa = pc->sqlxa.sqlpap + pano;
	tsp00_Int4 par [5];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pano;
	par [1] = pa->el.pakind;
	switch (par [1])
	{
	case SQLPARLO:
		par [2] = pa->lo.pava1index;
		par [3] = pa->lo.paloopcnt;
		par [4] = pa->lo.paloopmin;
		break;
	case SQLPARST:
		par [2] = pa->st.pavarst;
		par [3] = pa->st.paindst;
		par [4] = pa->st.paelcnt;
		break;
	case SQLPAREL:
		par [2] = pa->el.pavarno;
		par [3] = pa->el.paindno;
		par [4] = 0;
		break;
	}
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13kabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int kano)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->kabind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	sqlkaentry *ka = pc->sqlxa.sqlkap + kano;
	tsp00_Int4 par [15];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [ 0] = kano;
	par [ 1] = ka->katyp;
	par [ 2] = ka->kastate;
	par [ 3] = ka->kapacount;
	par [ 4] = ka->kapaindex;
	par [ 5] = ka->kaStcount;
	par [ 6] = (ka->kaversion == 0) ? pc->pcSt + 1 : ka->kaStindex;
	par [ 7] = ka->kamacro;
	par [ 8] = ka->kaprindex;
	par [ 9] = ka->kadiindex;
	par [10] = ka->kalineno;
	par [11] = ka->kafaindex;
	par [12] = ka->kaatindex;
	par [13] = ka->kacuindex;
	par [14] = ka->kamode;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13prbind (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int prno)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->prbind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	sqlprentry *pr = pc->sqlxa.sqlprp + prno;
	int i, j;
	tsp00_Int4 par [12];
	static const int npar = sizeof (par) / sizeof (par [0]);
	char *cpar [2];
	static const int ncpar = sizeof (cpar) / sizeof (cpar [0]);
	
	par [0] = prno;
	par [1] = pr->prStmtNameIndex;
	par [2] = pr->prCursorNameIndex;
	par [3] = pr->prstate;
	par [4] = pr->prkaindex;
	par [5] = pr->prarea;
	par [6] = pr->prDescribe;
	par [7] = pr->prstcount;
	par [8] = pr->prstindex;
	par [9] = pr->prcuindex;
	par [10] = sizeof (pr->prStmtName);
	par [11] = sizeof (pr->prCursorName);
	cpar [0] = (char *) pr->prStmtName;
	cpar [1] = (char *) pr->prCursorName;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = 1;
	strcpy (partbuf, "");
	for (i = 0; i < ncpar; i++)
	{
		strcat (partbuf, ",");
		strcat (partbuf, STRING_LIT_BEG);
		if (par [j = i + 10] > 0)
		{
			*part1len = strlen (partbuf) + *syposacc;
			outcnt (pc);
			*syposacc = 1;
			strcpy (partbuf, "");
			strncat (partbuf, cpar [i], par [j]);
			*part1len = strlen (partbuf) + *syposacc;
			quocnt (pc);
			*syposacc = 1;
			strcpy (partbuf, "");
		}
		else
			strcat (partbuf, " ");
		strcat (partbuf, STRING_LIT_END);
	}
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outcnt (pc);
	outstmt (pc);
}

void p13stbind (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int stno, int rstno, tpr01_SQLStatementOptionEnum fOption)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->stbind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlstentry *st = pc->sqlxa.sqlstp + stno;
	int src = (rstno >= 0) ? src2 : (rstno = stno, src1);
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [4];
	static int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = st->stkano;
	par [1] = fOption;
	par [2] = pc->sqlca.sqlrap->raactsession;
	par [3] = st->stllen;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",   ");
	strcat (partbuf, STRING_LIT_BEG);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, "");
	if (st->stllen > 0)
		strncat (partbuf, (const char *) st->stline, st->stllen);
	else
		strcat (partbuf, "");
	*part1len = strlen (partbuf) + *syposacc;
	quocnt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outcnt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13atbind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int atno)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->atbind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	sqlatentry *at = pc->sqlxa.sqlatp + atno;
	tsp00_Int4 par [3];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [ 0] = atno;
 	par [ 1] = at->atdbindex;
 	par [ 2] = at->atdbnamix;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	strncat (partbuf, (const char *) at->atdbname, sizeof (at->atdbname));
	strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	strncat (partbuf, (const char *) at->atdbstring, sizeof (at->atdbstring));
	strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13cancel (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->cancel;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [ 0] = pc->sqlxa.xakano;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13version (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->version;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [ 0] = pc->sqlxa.xakano;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13fnbind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int fnno)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->fnbind;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp;
	sqlfnentry *fn = pc->sqlxa.sqlfnp + fnno;
	tsp00_Int4 par [4];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [ 0] = fnno;
 	par [ 1] = fn->fnkanomin;
 	par [ 2] = fn->fnkanomax;
 	par [ 3] = fn->fnincllno;
	*syposacc = 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	strncat (partbuf, (const char *) fn->fnfilen, sizeof (fn->fnfilen));
	strcat (partbuf, STRING_LIT_END);
    strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
}

void p13daaddr (void (*outstmt) (tpc_globals*),
	void (*outcnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode)
{
	static const int src1 = 0, src2 = 1;
	char **code = scode->daaddr;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	int src = (pc->sqlxa.xadescpos > 0) ? src2 : src1;
	
	if (pc->sqlxa.xadescpos == 0)
		return;
	
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	if (pc->sqlxa.xadescpos > 0)
	{
		*syposacc = pc->sqlxa.xadescpos;
		*part1len = pc->sqlxa.xadescpos + pc->sqlxa.xadesclen;
		outcnt (pc);
		*syposacc = savlen + 1;
		strcpy (partbuf, ");");
		*part1len = strlen (partbuf) + *syposacc;
		outcnt (pc);
	}
	outstmt (pc);
	*part1len = savlen;
}

void p13sqlstm (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode)
{
	static const int src1 = 0, src2 = 1, src3 = 2, src4 = 3, src5 = 4;
	const char *cast = "(long)";
	char **code = scode->sqlstm;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlkaentry *ka = pc->sqlxa.sqlkap + pc->sqlxa.xakano - 1;
	tsp00_Int4 savlen = *part1len;
	int i;
	int bindst;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->sqlxa.xakano;
	par [1] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src3]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	bindst = 0;
	if (bindst == 0) {
	  tpr01_SQLStatementOptionEnum fOption = First_epr01;
	  for (i = 0; i < ka->kaStcount; i++) {
	    p13stbind (outstmt, outcnt, quocnt, pc, scode, ka->kaStindex + i - 1, i, fOption);
	    fOption = Append_epr01;
	  }
	}
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src4]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");}");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src5]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13option (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->Option;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->pcKa;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13trace (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->trace;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqloatype *oa = pc->sqlca.sqloap;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = oa->oamodsettrty;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13trcline (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->trcline;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->pcKa;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13modtrace (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->modtrace;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	struct  tsp4_args_options_sp4co_sql_precompiler *op =
	  &pc->pcOpts.variant.C_sp4co_sql_precompiler;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	if (op->opt_trace_F == CPR_TRACE_EMPTY)
		return;
	
	par [0] = op->opt_trace_F;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, "");
	strncat (partbuf, (const char *) op->opt_tracefile_F, 
		 sizeof (op->opt_tracefile_F));
	*part1len = strlen (partbuf) + *syposacc;
	quocnt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outcnt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13macro (void (*outstmt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int macno)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->macro;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	mavalue *ma = pc->sqlca.sqlmap->maentry + macno - 1;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = macno;
	par [1] = ma->malen;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	strcat (partbuf, STRING_LIT_BEG);
	strncat (partbuf, (const char *) ma->maval, (ma->malen > 0) ? ma->malen : 1);
	strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13prepare (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->prepare;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
#ifdef PREPSTMT
	par [0] = pc->pcKa;
#else
	par [0] = pc->sqlxa.sqlkap[pc->pcKa-1].kaprindex;  /**BF 20.6.96**/
#endif
	par [1] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13describe (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->describe;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->sqlxa.xakano;
	par [1] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13nolog (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->nolog;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->sqlca.sqlrap->raactsession;;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13open (void (*outstmt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int openno)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->open;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = openno;
	par [1] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13declare (void (*outstmt) (tpc_globals*), 
		 tpc_globals *pc, 
		 tpcCode *scode,
		 int prno)
{
#ifdef PREPSTMT
  p14ifstbind (pc, pc->sqlxa.xakano);
  p13sqlstm (p31outstmt, p31outcnt, p31quocnt, pc,
	     &p31code);
#else
  static const int src = 0;
  const char *cast = "(long)";
  char **code = scode->declare;
  tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
  tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
  char *partbuf = pc->pccmdpart.partbufp + *part1len;
  tsp00_Int4 savlen = *part1len;
  tsp00_Int4 par [2];
  static const int npar = sizeof (par) / sizeof (par [0]);
  
  par [0] = prno;
  par [1] = pc->sqlca.sqlrap->raactsession;
  *syposacc = savlen + 1;
  strcpy (partbuf, code [src]);
  p13intcat (partbuf, cast, npar, par);
  strcat (partbuf, ");");
  *part1len = strlen (partbuf) + *syposacc;
  outstmt (pc);
  outstmt (pc);
  *part1len = savlen;
#endif
}

void p13immediateexecute (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int statemno)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->immediateexecute;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [2];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = statemno;
	par [1] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13command (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->command;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->pcKa;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13dbsname (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int gano, int dbpos, int dblen, int nodepos, int nodelen)
{
	static const int src1 = 0, src2 = 1;
	const char *cast = "(long)";
	char **code = scode->dbsname;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	sqlgaentry *ga = pc->sqlca.sqlgap->gaentry [gano - 1];
	sqlparpointer pad = pc->sqlxa.sqlpap + ga->gavaindex - 1;
	sqlparpointer pan = pc->sqlxa.sqlpap + ga->ganodeindex - 1;
	sqlv1pointer va1;
	sqlv2pointer va2;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [3];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->sqlca.sqlrap->raactsession;
	if (ga->gavaindex == 0)
		par [1] =  dblen;
	else
	{
		if (pad->st.pakind == SQLPARST)
			pad++;
		va1 = pc->sqlxa.sqlv1p + pad->el.pavarno - 1;
		if (va1->pt.va1indi == SQLVAPT)
			va1 = pc->sqlxa.sqlv1p + va1->pt.va1ix - 1;
		va2 = pc->sqlxa.sqlv2p + va1->sc.va1indva2 - 1;
		par [1] = va2->va2size;
	}
	if (ga->ganodeindex == 0)
		par [2] = nodelen;
	else
	{
		if (pan->st.pakind == SQLPARST)
			pan++;
		va1 = pc->sqlxa.sqlv1p + pan->el.pavarno - 1;
		if (va1->pt.va1indi == SQLVAPT)
			va1 = pc->sqlxa.sqlv1p + va1->pt.va1ix - 1;
		va2 = pc->sqlxa.sqlv2p + va1->sc.va1indva2 - 1;
		par [2] = va2->va2size;
	}
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src1]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ",");
	if (ga->gavaindex == 0)
		strcat (partbuf, STRING_LIT_BEG);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	*syposacc = dbpos;
	*part1len = dbpos + dblen;
	if (ga->gavaindex == 0)
		quocnt (pc);
	else
		outcnt (pc);
	*syposacc = savlen + 1;
	strcpy (partbuf, "");
	if (ga->gavaindex == 0)
		strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ",");
	if (ga->ganodeindex == 0)
		strcat (partbuf, STRING_LIT_BEG);
	if (nodelen > 0)
	{
		*part1len = strlen (partbuf) + *syposacc;
		outcnt (pc);
		*syposacc = nodepos;
		*part1len = nodepos + nodelen;
		if (ga->ganodeindex == 0)
			quocnt (pc);
		else
			outcnt (pc);
		*syposacc = savlen + 1;
		strcpy (partbuf, "");
	}
	else
		strcat (partbuf, " ");
	if (ga->ganodeindex == 0)
		strcat (partbuf, STRING_LIT_END);
	strcat (partbuf, ");");
	strcat (partbuf, code [src2]);
	*part1len = strlen (partbuf) + *syposacc;
	outcnt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13reconnect (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	const char *cast = "(long)";
	char **code = scode->reconnect;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	tsp00_Int4 par [1];
	static const int npar = sizeof (par) / sizeof (par [0]);
	
	par [0] = pc->sqlca.sqlrap->raactsession;
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	p13intcat (partbuf, cast, npar, par);
	strcat (partbuf, ");");
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}

void p13exit (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode)
{
	static const int src = 0;
	char **code = scode->exit;
	tsp00_Int4 *syposacc = &pc->pcScan.syposacc;
	tsp00_Int4 *part1len = &pc->pccmdpart.part1len;
	char *partbuf = pc->pccmdpart.partbufp + *part1len;
	tsp00_Int4 savlen = *part1len;
	
	*syposacc = savlen + 1;
	strcpy (partbuf, code [src]);
	*part1len = strlen (partbuf) + *syposacc;
	outstmt (pc);
	outstmt (pc);
	*part1len = savlen;
}
