/*!******************************************************************************

  @file         hkb57.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_restart_record

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HKB57_H
#define HKB57_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x84\x41\x21\x16\xd3\x83\x89\x12\xee\x8c\x8b\xd2\xbb\x48\x5c\x01'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "gkb00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void k57adjust_table_key (
    tgg00_MessBlock       VAR_VALUE_REF  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57allocate (
    tgg00_TransContext    VAR_VALUE_REF  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 k57calc_checksum (
    tkb00_Page            VAR_VALUE_REF  logpage);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57create_restartrecord (
    tgg00_TransContext    VAR_VALUE_REF  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57currval (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tsp00_MoveObjPtr                     buf_addr,
    tsp00_Int4                           buf_size,
    integer                              firstpos,
    tsp00_MoveObjPtr                     resultbuf_addr,
    tsp00_Int4                           resultbuf_size,
    integer                              resultpos,
    tsp00_Int4            VAR_VALUE_REF  res_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57overall_currval (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tsp00_MoveObjPtr                     buf_addr,
    tsp00_Int4                           buf_size,
    integer                              firstpos,
    tsp00_MoveObjPtr                     resultbuf_addr,
    tsp00_Int4                           resultbuf_size,
    integer                              resultpos,
    tsp00_Int4            VAR_VALUE_REF  res_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57dump_restartrec (
    tgg00_VfFileref       VAR_VALUE_REF  hostfile,
    tsp00_Page            VAR_ARRAY_REF  buf,
    tsp00_Int4            VAR_VALUE_REF  out_pno,
    integer               VAR_VALUE_REF  out_pos,
    tsp00_VfReturn        VAR_VALUE_REF  host_err,
    tsp00_ErrText         VAR_ARRAY_REF  errtext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57end_flush_sequences (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57flush_sequences (
    tgg00_TransContext    VAR_VALUE_REF  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57info_seq_cache (
    tsp00_TaskId                         process_id,
    tsp00_8ByteCounter    VAR_VALUE_REF  cache_total,
    tsp00_8ByteCounter    VAR_VALUE_REF  cache_hit,
    tsp00_8ByteCounter    VAR_VALUE_REF  cache_miss);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57init_restartrec_handling (
    tgg00_TransContext    VAR_VALUE_REF  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57new_session (
    tsp00_TaskId                         TaskId,
    tgg91_SessionNo       VAR_VALUE_REF  SessionId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57new_write_trans (
    tsp00_TaskId                         TaskId,
    tgg91_TransNo         VAR_VALUE_REF  WriteTransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57nextval (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tsp00_MoveObjPtr                     buf_addr,
    tsp00_Int4                           buf_size,
    tsp00_Int4                           firstpos,
    tsp00_MoveObjPtr                     resultbuf_addr,
    tsp00_Int4                           resultbuf_size,
    tsp00_Int4                           resultpos,
    tsp00_Int4            VAR_VALUE_REF  res_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57put_sequence_value (
    tgg00_TransContext    VAR_VALUE_REF  t,
    tgg00_Surrogate       VAR_ARRAY_REF  seq_surrogate,
    void                  *  val_buf,
    tsp00_Int4                           val_buf_size,
    tsp00_Int4                           val_buf_pos,
    tsp00_Int4                           val_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57RedoTransNoIncrement (
    tsp00_TaskId                         TaskId,
    tgg91_TransNo                        RedoTransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57RefreshSequence (
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_Surrogate  VAR_ARRAY_REF  SeqSurrogate,
    const tsp00_Number    VAR_ARRAY_REF  SeqValue);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57RefreshSurrogate (
    tgg00_TransContext    VAR_VALUE_REF  TransContext,
    const tgg00_Surrogate  VAR_ARRAY_REF  Surrogate,
    const tgg00_Surrogate  VAR_ARRAY_REF  SysKey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57save_restartrecord (
    tsp00_TaskId                         TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57select_restartrec (
    tsp00_TaskId                         TaskId,
    tsp00_Addr                           pAcv,
    tsp00_Addr                           pA41v);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57select_log_info (
    tsp00_TaskId                         TaskId,
    tsp00_Addr                           pAcv,
    tsp00_Addr                           pA41v);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57sequence_no (
    tgg00_MessBlock       VAR_VALUE_REF  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57set_not_generated ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57stamp (
    tgg00_MessBlock       VAR_VALUE_REF  m);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57statistics_reset (
    tsp00_TaskId                         process_id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57surrogates_to_log (
    tgg00_TransContext    VAR_VALUE_REF  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k57table_key_get (
    tsp00_TaskId                         pid,
    tgg00_TransState      VAR_ARRAY_REF  trans_state,
    tgg00_Lkey            VAR_VALUE_REF  syskey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_BytePtr k57DBIdentifier ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb57AnyOpenTransactionsExist ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo kb57GetFdir ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo kb57GetLongFdir ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 kb57GetOldConverterVersion (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo kb57GetUSMRoot (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_PageNo kb57GetMaxDataPageNo (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb57MigrateRestartRecord (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb57IsMigrationFlagSet (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57InspectRestartRecordForRestore (
    tkb00_PagePtr                        pRestart,
    pasbool                              bIsRestoreData,
    pasbool               VAR_VALUE_REF  bRestorePossible,
    pasbool               VAR_VALUE_REF  bMigrationNeeded);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57RestoreRestartRecord (
    tsp00_TaskId                         TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57RestoreRestartRecordAfterMigration (
    tsp00_PageAddr                       pOldRestart);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57SetRootBlockAddr (
    tsp00_Int4                           PackedRootBlockAddr);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57SetMaxDynamicPageNo (
    tsp00_PageNo                         MaxDynamicPageNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb57SetMaxStaticPageNo (
    tsp00_PageNo                         MaxStaticPageNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

