
/*******************************************************************************
*
* module:       hbd35.h
*
* ------------------------------------------------------------------------------
*
* responsible:  J.Primsch
*
* lastChanged:  1999-07-13
*
* purpose:      entryhandling
*
* generatedBy:  $TOOL/bin/ptocProto.py
*
* ------------------------------------------------------------------------------
*
* Copyright (c) 1999-2005 SAP AG
*


    ========== licence begin  GPL
    Copyright (c) 1999-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


********************************************************************************/

#ifndef HBD35_H
#define HBD35_H



/*****************************************************
 *     MD5: 'mB\2740\235\344\317\332\240\3411\\\202\323\212\315'
 *****************************************************/



/*****************************************************
 *     I N C L U D E S                               *
 *****************************************************/

#include "geo00.h"
#include "gsp00_0.h"
#include "gsp00_2.h"
#include "gsp00.h"
#include "gsp00_1.h"
#include "geo47.h"
#include "ggg90.h"
#include "ggg90.h"
#include "ggg91.h"
#include "ggg00.h"
#include "gbd00.h"
#include "SAPDB/SAPDBCommon/SAPDB_RangeCode.hpp"
#include "hgg10.h"


/*****************************************************
 *     P R O T O T Y P E S                           *
 *****************************************************/

inline void 
bd35LkeyAssign ( tsp00_Int4        SourceKeyLen,
				 tsp00_Key        *pSourceKey,
                 tgg00_Lkey       &TargetLKey,
				 tgg00_BasisError &BasisError)
{
	TargetLKey.keyLen_gg00() = SourceKeyLen;

    g10mv( __FILE__,   2,
              sizeof (*pSourceKey), sizeof (TargetLKey.keyVal_gg00 ()),
              *pSourceKey,               POS_OFF_DIFF_BD00,
			  TargetLKey.keyVal_gg00 (), POS_OFF_DIFF_BD00, 
			  SourceKeyLen , BasisError);
}

/*---------------------------------------------------------------------------*/

inline void 
bd35LkeyAssign ( tsp00_Int4        SourceKeyLen,
				 tsp00_KeyPtr      pSourceKey,
                 tgg00_Lkey       &TargetLKey,
				 tgg00_BasisError &BasisError)
{
	TargetLKey.keyLen_gg00() = SourceKeyLen;

    g10mv( __FILE__,   2,
              sizeof (tsp00_Key), sizeof (TargetLKey.keyVal_gg00 ()),
              pSourceKey,               POS_OFF_DIFF_BD00,
			  TargetLKey.keyVal_gg00 (), POS_OFF_DIFF_BD00, 
			  SourceKeyLen , BasisError);
}

/*---------------------------------------------------------------------------*/

inline void 
bd35LkeyAssign ( tgg00_Lkey       &SourceLKey,
                 tgg00_Lkey       &TargetLKey,
				 tgg00_BasisError &BasisError)
{
	bd35LkeyAssign (SourceLKey.keyLen_gg00(), &SourceLKey.keyVal_gg00 (), TargetLKey, BasisError);
}

/*---------------------------------------------------------------------------*/

externPascal void b35add_space (
    tbd_nodeptr           &  nptr,
    tsp00_Int4               pos,
    tsp00_Int4               plus,
    tgg00_TransContextPtr     t);

externPascal void b35del_space (
    tbd_nodeptr           &  nptr,
    tsp00_Int4               pos,
    tsp00_Int4               minus,
    tgg00_TransContextPtr     t);

externPascal void b35get_entrykey (
    tbd_nodeptr           &  nptr,
    integer                  index,
    tgg00_Lkey            &  sep,
    tgg00_TransContextPtr     t);

externPascal void b35lkey_assign (
    tgg00_Lkey            &  source_key,
    tgg00_Lkey            &  target_key,
    tgg00_BasisError      &  e);

externPascal void b35next_entry (
    tbd_nodeptr           &  nptr,
    integer               &  index,
    pasbool               &  last);


#endif

