/****************************************************************************/
/*!

  @file        SysView_Transactions.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "Transactions" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "hak07.h"
#include "hgg01.h"
#include "ggg91.h"
#include "ggg92.h"
#include "hgg06.h"
#include "vkb522.hpp"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_Transactions.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_Transactions::Create(void)
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Transactions::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_FIXED, SV_SESSIONID, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_TRANSACTIONID, 15);
	m_Table->AppendCol (ITOCT_TIMESTAMP, SV_STARTDATE, 0);
	m_Table->AppendCol (ITOCT_FIXED, SV_WRITETRANSACTIONID, 15);
	m_Table->AppendCol (ITOCT_FIXED, SV_SQLLOCKREQUESTTIMEOUT, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_OMSLOCKREQUESTTIMEOUT, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_LASTWRITE, 10);
	m_Table->AppendCol (ITOCT_CHAR, SV_SQLLOCKMODE, 14);
	m_Table->AppendCol (ITOCT_CHAR, SV_OMSLOCKMODE, 14);
	m_Table->AppendCol (ITOCT_CHAR, SV_REQUESTMODE, 14);
	m_Table->AppendCol (ITOCT_FIXED, SV_HISTORYROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_HISTORYLAST, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_HISTORYPAGECOUNT, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_LASTHISTORYSEQUENCE, 10);
	m_Table->AppendCol (ITOCT_FIXED, SV_CONSISTENTVIEWID, 15);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Transactions::GetColCount(void)
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Transactions::GetColCount", SysView_Trace, 5);

	return SV_CC_TRANSACTIONS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Transactions::EstimateRows(void)
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Transactions::EstimateRows", SysView_Trace, 5);

	return SV_ER_TRANSACTIONS;
}

/*---------------------------------------------------------------------------*/

void SysView_Transactions::Execute(void)
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Transactions::Execute", SysView_Trace, 5);

	ckb522_TransReader                  reader (m_Context.GetAllocator(), m_Context.TransContext());
    ckb522_TransReader::TransElement    *elem;
    SAPDB_Int4                          sessionID;


    m_Table->GetCatalogTable();

    if (m_Context.IsOk())
    {
                
        if (reader.Begin())
        {
            while (NULL != (elem = reader.Next()))
            {
                sessionID = gg06SessionGetInt4(elem->teSessionID_kb522);
                m_Table->MoveToCol (ITOVT_INT4, &sessionID, 0);
                m_Table->MoveToCol (ITOVT_TRANSNO, &elem->teTransID_kb522, 0);
                m_Table->MoveToCol (ITOVT_CHARPTR, elem->teStartDate_kb522.asCharp(), elem->teStartDate_kb522.length());
                m_Table->MoveToCol (ITOVT_TRANSNO, &elem->teWriteTransID_kb522, 0);

                if(elem->teSQLLockReqTimeout_kb522 != tlmFree_ekb05)
                {
                    m_Table->MoveToCol(ITOVT_INT4, &elem->teSQLLockReqTimeout_kb522, 0);
                }
                else
                {
                    m_Table->MoveToCol(ITOVT_NULL, NULL, 0);
                }

                m_Table->MoveToCol(ITOVT_NULL, NULL, 0); // teOMSLockReqTimeout_kb522 - DUMMY!

                if (elem->teSQLLockMode_kb522 == tlmEotExcl_ekb05)
                {
                    m_Table->MoveToCol(ITOVT_INT4, &elem->teLastWrite_kb522, 0);
                }
                else
                {
                    m_Table->MoveToCol(ITOVT_NULL, NULL, 0);
                }

                m_Table->MoveToCol (ITOVT_TRANSLOCKMODE, &elem->teSQLLockMode_kb522, 0);
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0); // teOMSLockMode_kb522 - DUMMY!
                m_Table->MoveToCol (ITOVT_TRANSLOCKMODE, &elem->teRequestMode_kb522, 0);
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0); // teHistoryRoot_kb522 - DUMMY!
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0); // teHistoryLast_kb522 - DUMMY!
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0); // teHistoryPageCount_kb522 - DUMMY!
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0); // teLastHistorySeq_kb522 - DUMMY!
                m_Table->MoveToCol (ITOVT_TRANSNO, &elem->teConsistentViewID_kb522, 0);
            }
        }
    }

}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
