/****************************************************************************/
/*!

  @file        SysView_SysViewBase.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "DataCache" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "gak40.h"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"
#include "SAPDBCommon/MemoryManagement/SAPDBMem_NewDestroy.hpp"
#include "SystemViews/SysView_SysViewBase.hpp"
#include "SystemViews/SysView_PascalTableObj.hpp"
#include "RunTime/System/RTESys_Time.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/

/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/

/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

SysView_SysViewBase::SysView_SysViewBase( SQLMan_Context	&context,
                                          tak40_show_glob   &a41v)
: m_Context(context)
, AsTimestamp(1)
{
    m_Table = new(context.GetAllocator()) SysView_PascalTableObj( context, a41v );
}

SysView_SysViewBase::~SysView_SysViewBase()
{
    if (m_Table)
    {
        destroy (m_Table, m_Context.GetAllocator());
        m_Table = NULL;
    }

}

void SysView_SysViewBase::AddColumn(SAPDB_UInt8 timeStamp, const SAPDB_Int4)
{
    if ( 0 == timeStamp )
    {
        /* Add column with NIL value */
        AddColumn();
    }
    else
    {
        /* convert timestamp into readable string */
        RTESys_SQLTimestamp date;

        AddColumn(RTESys_BuildSQLTimeStamp(timeStamp, date), sizeof(RTESys_SQLTimestamp));
    }
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
