/*!---------------------------------------------------------------------
  @file           RTE_SpeedInfo.hpp
  @author         JoergM, RobinW
  @brief          DBM Support: SAPDB Instance and Database Registration and Management Interfaces
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
---------------------------------------------------------------------*/


#ifndef RTE_SPEEDINFO_HPP
#define RTE_SPEEDINFO_HPP

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "RunTime/RTE_Types.h"
#include "Container/Container_List.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

 /*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/

class RTE_SpeedInfo
{
    const SAPDB_UTF8 *m_speedName;
    SAPDB_Int4        m_speedId;
    bool              m_exists;
    const SAPDB_Char *m_ExecutableName;
public:
    RTE_SpeedInfo(const SAPDB_UTF8 *speedName,SAPDB_Int4 speedId,bool exists,const SAPDB_Char *executableName)
        : 
        m_speedName(speedName),
        m_speedId(speedId),
        m_exists(exists),
        m_ExecutableName(executableName)
    {
    }
    
    const SAPDB_UTF8 *Name(void)
    {
        return m_speedName;
    }

    const SAPDB_Char *ExecutableName(void)
    {
        return m_ExecutableName;
    }

    void SetExists(bool exists)
    {
        m_exists = exists;
    }

    bool Exists(void)
    {
        return m_exists;
    }

    inline bool operator == (const RTE_SpeedInfo &other) const
    {
        return m_speedId == other.m_speedId;
    }
};

extern RTE_SpeedInfo speedNone;
extern RTE_SpeedInfo speedFast;
extern RTE_SpeedInfo speedQuick;
extern RTE_SpeedInfo speedSlow;
extern RTE_SpeedInfo speedTest;

typedef Container_List<RTE_SpeedInfo> RTE_SpeedList;

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/

#endif
