/*!
  @file           FBM_IDataVolume.hpp
  @author         Henrik
  @ingroup        FBM

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/

#ifndef FBM_IDATAVOLUME_H
#define FBM_IDATAVOLUME_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "FreeBlockManagement/FBM_Types.hpp"
#include "KernelCommon/Kernel_Common.hpp"
#include "KernelCommon/Kernel_Dump.hpp"
#include "RunTime/RTE_Types.h"

/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/*!
  @class          FBM_IDataVolume
  @brief          representation of one data volume
 */
class FBM_IDataVolume 
{
public:

    virtual void InitVolume() = 0;
    
    virtual FBM_BlockState GetBlockState(SAPDB_Int4 BlockNo) const = 0;

    virtual void SetBlockStateToFree (SAPDB_Int4 BlockNo) = 0;
    
    virtual void SetBlockStateToOccupied (SAPDB_Int4 BlockNo) = 0;
    
    virtual SAPDB_Int4 GetNumBlocksFree() const = 0;

    virtual SAPDB_Int4 GetNumBlocksUsed() const = 0;

    virtual RTE_VolumeAccessMode VolMode() const = 0;

    virtual SAPDB_Int4 GetMultFreeBlocks (
        const SAPDB_Int4  NumBlocksWanted,
        SAPDB_Int4       &NumBlocksSupplied) = 0;

    virtual SAPDB_Int4 GetFreeBlock () = 0;

    virtual void Verify () = 0;
    
    virtual void GetDeviceStatistics (SAPDB_Int4 &NumBlocks,
        SAPDB_Int4 &NumBlocksFree,
        SAPDB_Int4 &NumBlockFreeAfterSVP) const = 0;

    /*--------------------------------------------------------------------------
    function:     Dump()
    description:  insert all state information of a data devspace into the 
                  kernel dump file
    arguments:    dump [in/out] kernel dump file
                  devNo [in] logical identifier for a data devspace
    return value: none
    --------------------------------------------------------------------------*/

    virtual void Dump(Kernel_Dump &dump, const SAPDB_Int4 devNo) const = 0;
};

#endif //FBM_IDATAVOLUME_H
