/*!
  @file     FrameCtrl_ILog.hpp
  @author   TorstenS
  @ingroup  FrameControl
  @brief    Interface to access io capable memory for the log component.

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/



#ifndef FRAMECTRL_ILOG_HPP
#define FRAMECTRL_ILOG_HPP



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"   // PASCAL: SP_basic_constants_and_types

#include "KernelCommon/Kernel_IPage.hpp"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/* -----------------------------------------------------------------------*/
/*!
   @interface  FrameCtrl_ILog
   @brief      This interface is used to allocate and deallocate io capable
               memory for the component log. The size of the memory
               frames is given by the data base coniguration parameter
               page size.
*/
/* -----------------------------------------------------------------------*/

class FrameCtrl_ILog
{
public:

    /* -----------------------------------------------------------------------*/
    /*!
        @brief  This method returns the access to the FrameCtrl_ILog 
                interface of component FrameControl. It is assumed that the 
                FrameControl singleton is available! No CreateInstance call 
                will be done.
        @return Access to the FrameCtrl_ILog interface
     */
    /* -----------------------------------------------------------------------*/

    static FrameCtrl_ILog& GetInstance();

    /* -----------------------------------------------------------------------*/
    /*!
       @brief   This method is used to provide a log page frame.
                page. If no more memory is available the component frame control 
                executes an emergency shutdown.
       @param   taskId [in] Identification of calling task
       @return  (Kernel_IPage::PageFrame) New page frame handle
     */
    /* -----------------------------------------------------------------------*/

    virtual Kernel_IPage::PageFrame NewLogFrame( tsp00_TaskId taskId ) = 0;

    /* -----------------------------------------------------------------------*/
    /*!
        @brief  This method is used to release a log page frame.
        @param  taskId [in] Identification of calling task
        @param  frame  [in] Handle of the page frame to release
     */
    /* -----------------------------------------------------------------------*/

    virtual void FreeLogFrame(
        tsp00_TaskId            taskId,
        Kernel_IPage::PageFrame &frame ) = 0;
};

#endif  /* FRAMECTRL_ILOG_HPP */
