/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.Authentication;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;

public class DBM {
    public static final String hostKeyC = "host";
    private static final String hostDefaultC = "";
    public static final String dbnameKeyC = "dbname";
    private static final String dbnameDefaultC = "";
    public static final String dbrootKeyC = "dbroot";
    private static final String dbrootDefaultC = "";
    public static final String userKeyC = "user";
    private static final String pgmNameC = "dbmsrv";
    private static final String transportC = "transport";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private JdbcCommunication connection;
    private boolean inCommunication;

    public DBM(Properties properties) throws RTEException {
        String string = properties.getProperty(hostKeyC, "");
        String string2 = properties.getProperty(dbnameKeyC, "");
        String string3 = properties.getProperty(dbrootKeyC, "");
        JdbcCommFactory jdbcCommFactory = null;
        try {
            try {
                jdbcCommFactory = DriverSapDB.loadNativeCommunication() == 2 ? NativeComm.factory : SocketComm.factory;
                DriverSapDB.openTrace("", properties);
                Tracer.print("new DBM Connection ", properties);
                this.connection = jdbcCommFactory.xopen(string, string2, string3, pgmNameC, properties);
            }
            catch (Error error) {
                jdbcCommFactory = SocketComm.factory;
                this.connection = jdbcCommFactory.xopen(string, string2, string3, pgmNameC, properties);
            }
        }
        catch (RTEException rTEException) {
            Tracer.println("using " + jdbcCommFactory);
            Tracer.println("=> FAILED");
            throw rTEException;
        }
        Tracer.println("using " + this.connection);
        Tracer.println("=> " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        Tracer.println(this + "->release ()");
        if (this.connection != null) {
            try {
                try {
                    this.cmd("release");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    private String userLogon(String string) throws RTEException, DBMException {
        Authentication authentication;
        try {
            authentication = new Authentication();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return this.cmd("USER_LOGON " + string, false);
        }
        int n = string.indexOf(44);
        if (-1 == n) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [password not set]");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1).toUpperCase();
        String string4 = null;
        try {
            string4 = this.cmd("USER_GETCHALLENGE " + string2 + " METHODS " + "SCRAMMD5" + " " + Tracer.Hex2String(authentication.getClientchallenge()).toUpperCase(), false);
        }
        catch (DBMException dBMException) {
            if (dBMException.getErrorID().equalsIgnoreCase("ERR_COMMAND") && dBMException.getErrorCode() == -24977) {
                return this.cmd("USER_LOGON " + string, false);
            }
            throw dBMException;
        }
        if (!string4.startsWith("SCRAMMD5")) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [unknown authentication algorithm received]");
        }
        n = string4.indexOf(10);
        if (-1 == n) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [wrong format of server challenge]");
        }
        string4 = string4.substring(n + 1, string4.length() - 1);
        try {
            authentication.parseServerChallenge(Tracer.String2Hex(string4));
            string4 = this.cmd("USER_RESPONSE " + Tracer.Hex2String(authentication.getClientProof(string3.getBytes())).toUpperCase(), false);
            return string4;
        }
        catch (SQLExceptionSapDB sQLExceptionSapDB) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [" + sQLExceptionSapDB.toString() + "]");
        }
    }

    public String cmd(String string) throws RTEException, DBMException {
        try {
            Tracer.println(this + "->cmd (" + string + ")");
            String string2 = this.cmd(string, true);
            Tracer.println("=> " + string2);
            return string2;
        }
        catch (DBMException dBMException) {
            Tracer.println(" <-!");
            Tracer.traceException(dBMException);
            throw dBMException;
        }
        catch (RTEException rTEException) {
            Tracer.println(" <-!");
            Tracer.traceException(rTEException);
            throw rTEException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cmd(String string, boolean bl) throws RTEException, DBMException {
        Tracer.println(this + "->cmd (" + string + ")");
        if (bl && (string = string.trim()).toUpperCase().startsWith("USER_LOGON")) {
            string = string.substring("USER_LOGON".length()).trim();
            return this.userLogon(string);
        }
        StructuredMem structuredMem = this.connection.getRequestPacket();
        int n = (string.length() + 8 - 1) / 8 * 8;
        structuredMem.putString(string, 0);
        this.connection.request(structuredMem, n);
        try {
            this.inCommunication = true;
            StructuredMem structuredMem2 = this.connection.receive();
            this.inCommunication = false;
            String string2 = structuredMem2.getString(0, Math.min(4, structuredMem2.size()));
            if (!string2.startsWith("OK")) {
                throw DBMException.create(structuredMem2);
            }
            int n2 = string2.indexOf(10) + 1;
            String string3 = structuredMem2.getString(n2, structuredMem2.size() - n2);
            String string4 = string3;
            return string4;
        }
        finally {
            this.inCommunication = false;
        }
    }

    public void cancel() throws SQLException {
        if (this.inCommunication) {
            this.connection.cancel();
        }
    }

    public static DBM dbDBM(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        if (string2 != null) {
            properties.put(dbnameKeyC, string2);
        }
        return new DBM(properties);
    }

    public static DBM dbrootDBM(String string, String string2) throws RTEException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put(hostKeyC, string);
        }
        properties.put(dbrootKeyC, string2);
        return new DBM(properties);
    }
}

