/*!
  @file           ven79.c
  @author         JoergM
  @brief          Kernel RunTime: Read XParam File
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

#define MOD__ "ven79.c:"

#include "gen00.h"
#include "heo00.h"
#include "heo11.h"

#include <ctype.h>
#include "heo46.h"

/* exported functions */

#include "gen79.h"

/* imported functions */

#include "geo79.h"
#include "geo007_1.h"

#include "RunTime/Configuration/RTEConf_ParameterAccessKernelInterface.h"
/*===================== new globals =======================================*/
tsp00_Int2 e79_maxactive ;
/*==========================================================================*/

/* local functions */

static  int                             e79_check_params ();
#ifdef  DEBUG_RTE
static  void                            e79_print_params ();
static  void                            e79_deb_devsp_descr () ;
#endif

/* exported data */

tsp00_Int4                                e79_max_temp_cache ;
tsp00_Int2                                e79_maxserver ;
tsp00_Int4                                e79_kernel_alloc_pool=0;

/* imported data */

extern tsp00_DbNamec			en81_dbname;

/* local data */

/*
 * ===========================================================================
 */

int e79_read_params ( 
RTE_XPARAM_REC                  *XParam)
{
    SAPDB_Char *errText;
    DBG1 (( MF__,"e79_read_params: called \n" ));

    if(!RTEConf_ReadAndAnalyzeParam ( en81_dbname, XParam, &errText))
    {
        MSGALL (( ERR_OPEN_PARAM_FILE_FAILED, errText)) ;
        return ( 1 );
    }

/*********************************************/
    e79_maxactive       = XParam->ulMaxUser  ;
    e79_maxserver       = XParam->ulMaxServer  ;
/*********************************************/

    if ( e79_check_params ( XParam ) ) return ( 1 );

#ifdef  DEBUG_RTE
    e79_print_params ( XParam );
#endif

    return ( 0 );
}

/*
 * ===========================================================================
 */

static  int     e79_check_params ( RTE_XPARAM_REC *XParam)
{
    if ( *XParam->szDumpFilename == '\0' )
    {
        MSGCD(( ERR_XP_ENTRYXX_INCOMPLETE, PAN_KERNELDUMPFILE ));
        return ( 1 );
    }

    if ( *XParam->szTraceDevspace == '\0' )
    {
        MSGCD(( ERR_XP_ENTRYXX_INCOMPLETE, PAN_KERNELTRACEFILE ));
        return ( 1 );
    }

    return (0) ;
}

/*
 * ===========================================================================
 */

#ifdef  DEBUG_RTE
static  void    e79_print_params ( 
RTE_XPARAM_REC                  *XParam)

{
int i ;

DBG1 (( MF__,"e79: ParamKernelVersion       '%s' \n", XParam->szKernelVersion ))
DBG1 (( MF__,"e79: PageSize                 '%d' \n", XParam->ulDBPageSize ))

DBG1 (( MF__,"e79: MirrData                 '%d' \n", XParam->fMirrData))
DBG1 (( MF__,"e79: ControlUserId            '%s' \n", XParam->szControlUser ))

DBG1 (( MF__,"e79: NoOfBackupDevs           %d   \n", XParam->lNoOfBackupDevs ))

DBG1 (( MF__,"e79: MaxDataPages             %d   \n", XParam->lMaxDataPages ))
DBG1 (( MF__,"e79: MaxTrans                 %d   \n", XParam->lMaxTrans       ))
DBG1 (( MF__,"e79: DataCachePages           %d   \n", XParam->lDataCachePages ))
DBG1 (( MF__,"e79: SequenceCache            %d   \n", XParam->lSequenceCache ))
DBG1 (( MF__,"e79: DataCacheRegions         %d   \n", XParam->ulNumDataCacheReg))
DBG1 (( MF__,"e79: Tree / Splitt Regions    %d   \n", XParam->ulNumTreeReg))
DBG1 (( MF__,"e79: RowRegions               %d   \n", XParam->ulNumRowReg))
DBG1 (( MF__,"e79: TransRegions             %d   \n", XParam->ulNumTransReg))
DBG1 (( MF__,"e79: TabRegions               %d   \n", XParam->ulNumTabReg))
DBG1 (( MF__,"e79: CatalogCachePages        %d   \n", XParam->lCatalogCachePages ))
DBG1 (( MF__,"e79: DistribDescCache         %d   \n", XParam->lDistribDescCache ))
DBG1 (( MF__,"e79: ServerCmdCache           %d   \n", XParam->lServerCmdCache ))
DBG1 (( MF__,"e79: MaxActive                %d   \n", XParam->ulMaxUser      ))
DBG1 (( MF__,"e79: e79_maxserver            %d   \n", e79_maxserver           ))
DBG1 (( MF__,"e79: LogQueuePages            %d   \n", XParam->lLogQueuePages ))
DBG1 (( MF__,"e79: MaxLocks                 %d   \n", XParam->lMaxLocks ))
DBG1 (( MF__,"e79: DeadlockDetection        %d   \n", XParam->ulDeadlockDetection))
DBG1 (( MF__,"e79: ConvCachePages           %d   \n", XParam->lConvCachePages ))
DBG1 (( MF__,"e79: UsmCachePages            %d   \n", XParam->lUsmCachePages ))
DBG1 (( MF__,"e79: FbmCachePages            %d   \n", XParam->lFbmCachePages ))
DBG1 (( MF__,"e79: FbmCompression           %d   \n", XParam->lFbmCompression ))
DBG1 (( MF__,"e79: FbmBalance               %d   \n", XParam->lFbmBalance     ))
DBG1 (( MF__,"e79: FbmLowIORate             %d   \n", XParam->lFbmLowIORate   ))
DBG1 (( MF__,"e79: BackUpBlockCount         %d   \n", XParam->lBackUpBlockCount))
DBG1 (( MF__,"e79: DefaultLru               %d   \n", XParam->fDefaultLRU ))
DBG1 (( MF__,"e79: JoinPrefetchPercent      %d   \n", XParam->lJoinPrefetchPercent))
DBG1 (( MF__,"e79: MaxMerge                 %d   \n", XParam->lMaxMerge))

DBG1 (( MF__,"e79: ShmChunk                 %d   \n", XParam->lShmChunk  ))
DBG1 (( MF__,"e79: ShmKernel                %d   \n", XParam->lShmKernel ))
DBG1 (( MF__,"e79: SharedDynData            %d   \n", XParam->lSharedDynData  ))
DBG1 (( MF__,"e79: SharedDynPool            %d   \n", XParam->lSharedDynPool  ))

DBG1 (( MF__,"e79: OpMsg1                   '%s' \n", XParam->szOpMsg1        ))
DBG1 (( MF__,"e79: szOpMsg2                 '%s' \n", XParam->szOpMsg2        ))

DBG1 (( MF__,"e79: RunDirectory             '%s' \n", XParam->szRunDirectory ))

DBG1 (( MF__,"e79: DeviPerDevspace          %d   \n", XParam->lDeviPerDevspace ))
DBG1 (( MF__,"e79: DevQueue                 %d   \n", XParam->lDevQueue       ))
DBG1 (( MF__,"e79: MaxDataDevspaces         %d   \n", XParam->lMaxDataDevspaces ))
DBG1 (( MF__,"e79: MaxDevspaces             %d   \n", XParam->lMaxDevspaces ))

DBG1 (( MF__,"e79: e79_dumpfilename         '%s' \n", XParam->szDumpFilename  ))
DBG1 (( MF__,"e79: RTEDumpFilename          '%s' \n", XParam->szRTEDumpFilename ))
DBG1 (( MF__,"e79: e79_tracedevspace        '%s' \n", XParam->szTraceDevspace ))
DBG1 (( MF__,"e79: e79_tracedevsize         %d   \n", XParam->lTraceDevspaceSize ))
DBG1 (( MF__,"e79: BackupHistFile           '%s' \n", XParam->szBackupHistFile))
DBG1 (( MF__,"e79: UtilityProtFile          '%s' \n", XParam->szUtilityProtFile))
DBG1 (( MF__,"e79: UtilityProtSize          %d   \n", XParam->ulUtilityProtSize))
DBG1 (( MF__,"e79: e79_maxcpu               %d   \n", XParam->ulMaxCPU        ))
DBG1 (( MF__,"e79: DispLoopsBeforeSemop     %d   \n", XParam->ulDispLoopsBefSemop ))
DBG1 (( MF__,"e79: BegExclDirtyRead         %d   \n", XParam->fBegExclDirtyRead ))
DBG1 (( MF__,"e79: LoopRegionColl           %d   \n", XParam->ulRegionCollisionLoop ))
DBG1 (( MF__,"e79: ExclQueue                %d   \n", XParam->fExclQueue ))
DBG1 (( MF__,"e79: DynDispQueueSrch         %d   \n", XParam->fDynDispQueSrch ))
DBG1 (( MF__,"e79: RegLockSlice             %d   \n", XParam->ulRegLockSlice  ))
DBG1 (( MF__,"e79: BegExclQueueWhenPrio     %d   \n", XParam->fBegExclQueWhenPrio ))
DBG1 (( MF__,"e79: EndExclBusyWait          %d   \n", XParam->fEndExclBusyWait))
DBG1 (( MF__,"e79: DelayLW                  %d   \n", XParam->lDelayLW        ))
DBG1 (( MF__,"e79: DelayCommit              %d   \n", XParam->fDelayCommit    ))
DBG1 (( MF__,"e79: Unicode                  %d   \n", XParam->fUnicode ))
DBG1 (( MF__,"e79: Subtree                  %d   \n", XParam->fSubtree ))
DBG1 (( MF__,"e79: AllowSingleIO            %d   \n", XParam->fAllowSingleIO  ))
DBG1 (( MF__,"e79: PrioBaseU2U              %d   \n", XParam->lPrioBaseU2U    ))
DBG1 (( MF__,"e79: PrioBaseRAV              %d   \n", XParam->lPrioBaseRAV    ))
DBG1 (( MF__,"e79: PrioBaseIOC              %d   \n", XParam->lPrioBaseIOC    ))
DBG1 (( MF__,"e79: PrioBaseCOM              %d   \n", XParam->lPrioBaseCOM    ))
DBG1 (( MF__,"e79: PrioBaseREX              %d   \n", XParam->lPrioBaseREX    ))
DBG1 (( MF__,"e79: PrioFactor               %d   \n", XParam->lPrioFactor     ))
DBG1 (( MF__,"e79: PacketSize               %d   \n", XParam->ulPacketSize    ))
DBG1 (( MF__,"e79: MinReplySize             %d   \n", XParam->ulMinReplySize  ))
DBG1 (( MF__,"e79: PnoPoolSize              %d   \n", XParam->ulPnoPoolSize   ))
DBG1 (( MF__,"e79: MaxUsUtStack             %d   \n", XParam->ulMaxUsUtStack  ))
DBG1 (( MF__,"e79: StackStack               %d   \n", XParam->fStackStack     ))
DBG1 (( MF__,"e79: e79_kernel_alloc_pool    %d   \n", e79_kernel_alloc_pool   ))
DBG1 (( MF__,"e79: LogMode                  %d   \n", XParam->lLogMode        ))
DBG1 (( MF__,"e79: LogSegmentSize           %d   \n", XParam->lLogSegmentSize ))
DBG1 (( MF__,"e79: SessionTimeout           %d   \n", XParam->lSessionTimeout ))
DBG1 (( MF__,"e79: LockTimeout              %d   \n", XParam->lLockTimeout    ))
DBG1 (( MF__,"e79: RequestTimeout           %d   \n", XParam->lRequestTimeout ))
DBG1 (( MF__,"e79: NetTimeout               %d   \n", XParam->lNetTimeout ))
DBG1 (( MF__,"e79: RestartTime              %d   \n", XParam->lRestartTime    ))
DBG1 (( MF__,"e79: DefaultCode             '%s'  \n", XParam->szDefaultCode   ))
DBG1 (( MF__,"e79: DateTimeFormat          '%s'  \n", XParam->szDateTimeFormat))
DBG1 (( MF__,"e79: MBDataSize              '%d'  \n", XParam->ulMBDataSize     ))
DBG1 (( MF__,"e79: MBQualSize              '%d'  \n", XParam->ulMBQualSize     ))
DBG1 (( MF__,"e79: MBStackSize             '%d'  \n", XParam->ulMBStackSize    ))
DBG1 (( MF__,"e79: KBWorkStSize            '%d'  \n", XParam->ulKBWorkStSize   ))
DBG1 (( MF__,"e79: KBWorkBufSize           '%d'  \n", XParam->ulKBWorkBufSize  ))
DBG1 (( MF__,"e79: CatalogCacheSize        '%d'  \n", XParam->ulCatalogCacheSize ))
DBG1 (( MF__,"e79: MultIOBlockCount        '%d'  \n", XParam->ulMultIOBlockCount ))
DBG1 (( MF__,"e79: MaxDatawriter           '%d'  \n", XParam->ulMaxDataWriter))
DBG1 (( MF__,"e79: DwCopyBoundaty          '%d'  \n", XParam->lDwCopyBoundary ))
DBG1 (( MF__,"e79: DwIOAreaSize            '%d'  \n", XParam->lDwIOAreaSize   ))
DBG1 (( MF__,"e79: DwIOAreaFlush           '%d'  \n", XParam->lDwIOAreaFlush  ))
DBG1 (( MF__,"e79: DwLRUTailFlush          '%d'  \n", XParam->lDwLRUTailFlush ))
DBG1 (( MF__,"e79: DwIOBufSize             '%d'  \n", XParam->ulDwIOBufSize ))
DBG1 (( MF__,"e79: SvpFstConvFlush         '%d'  \n", XParam->fSvpFstConvFlush))

for ( i=0; i<8; i++ )
  e79_deb_devsp_descr ( XParam, i ) ;

 }

/*
 * ===========================================================================
 */

static  void    e79_deb_devsp_descr ( 
RTE_XPARAM_REC                  *XParam,
LONG                            lDevspType ) 
{
int i ;
DEV_DESCR *ActDevsp ;
int NumDevs = XParam->DevspDescr [ lDevspType ].ulNumDevs ; 

DBG1 (( MF__,"e79: NumDevs of DevspaceType %d = '%d'\n", 
             XParam->DevspDescr[lDevspType].Devspaces[0].lDevspaceType, NumDevs )) ;
for ( i=0; i < NumDevs ; i++ )
  {   
  ActDevsp = XParam->DevspDescr [ lDevspType ].Devspaces + i ; 
  if ( ActDevsp->lDevspaceType == DEVSPACE_UNUSED ) 
    {
    DBG1 (( MF__,"e79: DevspaceType [%d] = '%d' ( free )\n", i, 
                              ActDevsp->lDevspaceType )) ;
    }
  else
    {
    DBG1 (( MF__,"e79: DevspaceName [%d] = '%s'\n",i, ActDevsp->szDevspaceName ));
    DBG1 (( MF__,"e79: DevspaceSize [%d] = '%u'\n",i, ActDevsp->lDevspaceSize  ));
    DBG1 (( MF__,"e79: DevspaceType [%d] = '%d'\n",i, ActDevsp->lDevspaceType));
    }
  }
}
#endif
