/****************************************************************************/
/*!

  @file        SysView_Files.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "Files" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_Files.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_Files::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Files::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_CHARBYTE ,SV_FILEID, 8);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_OWNER, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_SCHEMANAME, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_NAME, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_INDEXNAME, 32);
	m_Table->AppendCol (ITOCT_FIXED ,SV_ROOT, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_TYPE, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDSIZE, 20);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Files::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Files::GetColCount", SysView_Trace, 5);

    return SV_CC_FILES;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_Files::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Files::EstimateRows", SysView_Trace, 5);

    return SV_ER_FILES;
}

/*---------------------------------------------------------------------------*/

void SysView_Files::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_Files::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
