/*!
  @file           RTEThread_ConsoleCommandQueue.cpp
  @author         StefanP
  @special area   Kernel Console Thread
  @brief          CommandQueue
  @see            

\if EMIT_LICENCE
  ========== licence begin  GPL
  Copyright (c) 2002-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end
\endif
*/




/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include    "RunTime/RTE_MessageList.hpp"
#include    "RunTime/RTE_Message.hpp"
#include    "RunTime/RTE_Console_Thread_Messages.hpp"
#include    "RunTime/RTE_ConsoleCommon.hpp"
#include    "RunTime/Threading/RTEThread_ConsoleCommandQueue.hpp"
#include    "RunTime/Threading/RTEThread_ConsoleRequest.h"
#include    "SAPDBCommon/Tracing/SAPDBTrace_Topic.hpp"
#include    "SAPDBCommon/Tracing/SAPDBTrace_Usage.hpp"


extern SAPDBTrace_Topic Console_Trace;

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/
RTEThread_ConsoleCommandQueue   *RTEThread_ConsoleCommandQueue::m_Instance = NULL; 



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

RTEThread_ConsoleCommandQueue::RTEThread_ConsoleCommandQueue   
( 
    Allocator&  alloc 
) :  Container_List<RTEThread_ConsoleRequest> (alloc)
{
    SAPDBTRACE_METHOD_DEBUG ("RTEThread_ConsoleCommandQueue::RTEThread_ConsoleCommandQueue", 
                             Console_Trace, 9);

    sqlcreatemutex(&m_commandQueueMutex);
}

/*---------------------------------------------------------------------------*/

RTEThread_ConsoleCommandQueue::~RTEThread_ConsoleCommandQueue ()
{
    SAPDBTRACE_METHOD_DEBUG ("RTEThread_ConsoleCommandQueue::~RTEThread_ConsoleCommandQueue", 
                             Console_Trace, 9);

    sqldestroymutex(&m_commandQueueMutex);
}

/*---------------------------------------------------------------------------*/

RTEThread_ConsoleCommandQueue & RTEThread_ConsoleCommandQueue::Instance()
{
    SAPDBTRACE_ROUTINE_DEBUG("RTEThread_ConsoleCommandQueue::Instance", Console_Trace, 9);
    
    if (NULL == m_Instance)
    {
        SAPDBTRACE_WRITELN(Console_Trace, 1, "Creation of command queue instance");
        m_Instance = new (RTEMem_Allocator::Instance()) RTEThread_ConsoleCommandQueue (RTEMem_Allocator::Instance());
        if (NULL == m_Instance)
        {
            RTE_Crash (SAPDBErr_MessageList(RTE_CONTEXT, RTEERR_SYS_ALLOC_INST, "RTEThread_ConsoleCommandQueue"));
        }
    }

    return *m_Instance;
}

/*---------------------------------------------------------------------------*/

void    RTEThread_ConsoleCommandQueue::PutCommand  
(
    RTEThread_ConsoleRequest const &            request
)
{
/*===========================================================================*
 *  Locals                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  Instructions                                                             *
 *===========================================================================*/
    SAPDBTRACE_METHOD_DEBUG ("RTEThread_ConsoleCommandQueue::PutCommand", 
                             Console_Trace, 1);

    /*--- Insert a new request  ---------------------------------------------*/
    Lock ();
    InsertEnd (request); 
    Unlock ();
}

/*---------------------------------------------------------------------------*/

void RTEThread_ConsoleCommandQueue::GetCommand  
(
    ConsoleWorkerInfo &                         threadInfo, 
    RTEThread_ConsoleRequest &                  request
)
{
/*===========================================================================*
 *  Locals                                                                   *
 *===========================================================================*/

/*===========================================================================*
 *  Instructions                                                             *
 *===========================================================================*/
    SAPDBTRACE_METHOD_DEBUG ("RTEThread_ConsoleCommandQueue::GetCommand", 
                             Console_Trace, 1);

    /* Looking for further requests in the command queue */
    Lock ();
    threadInfo.state &= CONSOLE_WORKER_STATE_BASE_MASK;

    if (!IsEmpty ())
    {
//?? liefert * Pointer oder Inhalt? Hier fehlt wahrscheinlich noch der & Operator fr Iterator
//Hier wird der Copy Konstruktur bentigt?!
        request = *Begin();
        DeleteFront (); 

        threadInfo.state |= CONSOLE_WORKER_STATE_ACTIVE;
    }
    else
    {
        threadInfo.state |= CONSOLE_WORKER_STATE_WAITING;
    }

    Unlock ();

    return;
}

