/*!========================================================================

  @file         RTEComm_ParseURIEscapeRFC2396.hpp
  @ingroup      
  @author       RaymondR

  @brief        URI character escaping array (RFC2396 conform)

                !!!!! DO NOT ALTER THIS FILE DIRECTLY !!!!!!

                Character escaping array for RFC 2396 conform
                URI parsing/buildup.

                The array contains 256 entries, one per each character
                representation. If a character has to be escaped
                ( <hexdigit><hexdigit> ) for an URI part, a specific
                part identfier is set for that array entry.

                UTF8 characters are handled byte wise like a normal
                ascii character.

                This file has been generated via 
                'RTEComm_BuildURIEscapeRFC2396.cpp'.
                
                The link description name is 'BuildURIEscapeRFC2396.lnk'

                !!!!! DO NOT ALTER THIS FILE DIRECTLY !!!!!!
                

  @since        2004-04-16  12:10
  @sa           

  ==========================================================================

  \if EMIT_LICENCE

    ========== licence begin GPL
    Copyright (c) 2003-2004 SAP AG

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

  \endif
 ============================================================================*/

#ifndef RTECOMM_PARSEURIESCAPERFC2396_HPP
#define RTECOMM_PARSEURIESCAPERFC2396_HPP

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include    "SAPDBCommon/SAPDB_Types.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/

// Escape characters (%xx), as defined in RFC2396
//
#define NO_ESC               0x0000 // do not escape character 
#define ESC_URI              0x0001 // URI escape characters 
#define ESC_SCHEME           0x0002 // scheme escape characters 
#define ESC_PROTNAME         0x0004 // protocol escape characters 
#define ESC_LOCATION         0x0008 // location part escape characters 
#define ESC_HOST             0x0010 // host + port escape characters 
#define ESC_HOSTNAME         0x0020 // hostname esscape characters 
#define ESC_PATH             0x0040 // path part escape characters 
#define ESC_PATH_CONTENT     0x0080 // path content escape characters 
#define ESC_QUERY            0x0100 // query part escape characters 
#define ESC_QUERY_CONTENT    0x0200 // query content part escape characters 
#define ESC_FRAGMENT         0x0400 // fragment escape characters 


/*===========================================================================*
 *  CODE                                                                     *
 *===========================================================================*/


#if defined(DECLARE_ESCAPE_CHAR_ARRAY)
//
//
// Character sets defined in RFC2396
//
//  lowalpha        "abcdefghijklmnopqrstuvwxyz"
//  upalpha         "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
//  alpha           lowalpha | upalpha
//
//  digit           "0123456789"
//  alphanum        alpha |digit
//
//  reserved        ";/?:@&=+$,"
//
//  mark            "-_.!~*'()"
//  unreserved      alphanum | mark
//
//  delims          "<>#%""
//  unwise          "{}|\^[]`"
//
//  uric            reserved | unreserved
//  uri_scheme      alpha |digit | "+-."
//
//  it's not RFC2396 conform, but we don't allow path parameters separated by ';' 
//  uri_path        unreserved | ":@&=+$,"
//  uri_query       uric
//  uri_query_cont  unreserved

static const SAPDB_UInt4 escapeCharsRFC2396[256] = 
{
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*!!!!!!!! DO NOT ALTER THIS ARRAY DIRECTLY !!!!!!!!!*/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
    /* [0x00] -     */  NO_ESC, 
    /* [0x01] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x02] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x03] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x04] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x05] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x06] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x07] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x08] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x09] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0a] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0b] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0c] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0d] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0e] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x0f] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x10] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x11] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x12] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x13] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x14] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x15] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x16] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x17] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x18] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x19] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1a] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1b] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1c] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1d] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1e] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x1f] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x20] - ' ' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x21] - '!' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME,
    /* [0x22] - '"' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x23] - '#' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x24] - '$' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x25] - '%' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x26] - '&' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x27] - ''' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME,
    /* [0x28] - '(' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME,
    /* [0x29] - ')' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME,
    /* [0x2a] - '*' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOST | ESC_HOSTNAME,
    /* [0x2b] - '+' */  ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x2c] - ',' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x2d] - '-' */  NO_ESC,
    /* [0x2e] - '.' */  NO_ESC,
    /* [0x2f] - '/' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOST | ESC_HOSTNAME | ESC_PATH_CONTENT | ESC_QUERY_CONTENT,
    /* [0x30] - '0' */  NO_ESC,
    /* [0x31] - '1' */  NO_ESC,
    /* [0x32] - '2' */  NO_ESC,
    /* [0x33] - '3' */  NO_ESC,
    /* [0x34] - '4' */  NO_ESC,
    /* [0x35] - '5' */  NO_ESC,
    /* [0x36] - '6' */  NO_ESC,
    /* [0x37] - '7' */  NO_ESC,
    /* [0x38] - '8' */  NO_ESC,
    /* [0x39] - '9' */  NO_ESC,
    /* [0x3a] - ':' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x3b] - ';' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY_CONTENT,
    /* [0x3c] - '<' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x3d] - '=' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x3e] - '>' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x3f] - '?' */  ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY_CONTENT,
    /* [0x40] - '@' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOST | ESC_HOSTNAME | ESC_QUERY_CONTENT,
    /* [0x41] - 'A' */  NO_ESC,
    /* [0x42] - 'B' */  NO_ESC,
    /* [0x43] - 'C' */  NO_ESC,
    /* [0x44] - 'D' */  NO_ESC,
    /* [0x45] - 'E' */  NO_ESC,
    /* [0x46] - 'F' */  NO_ESC,
    /* [0x47] - 'G' */  NO_ESC,
    /* [0x48] - 'H' */  NO_ESC,
    /* [0x49] - 'I' */  NO_ESC,
    /* [0x4a] - 'J' */  NO_ESC,
    /* [0x4b] - 'K' */  NO_ESC,
    /* [0x4c] - 'L' */  NO_ESC,
    /* [0x4d] - 'M' */  NO_ESC,
    /* [0x4e] - 'N' */  NO_ESC,
    /* [0x4f] - 'O' */  NO_ESC,
    /* [0x50] - 'P' */  NO_ESC,
    /* [0x51] - 'Q' */  NO_ESC,
    /* [0x52] - 'R' */  NO_ESC,
    /* [0x53] - 'S' */  NO_ESC,
    /* [0x54] - 'T' */  NO_ESC,
    /* [0x55] - 'U' */  NO_ESC,
    /* [0x56] - 'V' */  NO_ESC,
    /* [0x57] - 'W' */  NO_ESC,
    /* [0x58] - 'X' */  NO_ESC,
    /* [0x59] - 'Y' */  NO_ESC,
    /* [0x5a] - 'Z' */  NO_ESC,
    /* [0x5b] - '[' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x5c] - '\' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x5d] - ']' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x5e] - '^' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x5f] - '_' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOST | ESC_HOSTNAME,
    /* [0x60] - '`' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x61] - 'a' */  NO_ESC,
    /* [0x62] - 'b' */  NO_ESC,
    /* [0x63] - 'c' */  NO_ESC,
    /* [0x64] - 'd' */  NO_ESC,
    /* [0x65] - 'e' */  NO_ESC,
    /* [0x66] - 'f' */  NO_ESC,
    /* [0x67] - 'g' */  NO_ESC,
    /* [0x68] - 'h' */  NO_ESC,
    /* [0x69] - 'i' */  NO_ESC,
    /* [0x6a] - 'j' */  NO_ESC,
    /* [0x6b] - 'k' */  NO_ESC,
    /* [0x6c] - 'l' */  NO_ESC,
    /* [0x6d] - 'm' */  NO_ESC,
    /* [0x6e] - 'n' */  NO_ESC,
    /* [0x6f] - 'o' */  NO_ESC,
    /* [0x70] - 'p' */  NO_ESC,
    /* [0x71] - 'q' */  NO_ESC,
    /* [0x72] - 'r' */  NO_ESC,
    /* [0x73] - 's' */  NO_ESC,
    /* [0x74] - 't' */  NO_ESC,
    /* [0x75] - 'u' */  NO_ESC,
    /* [0x76] - 'v' */  NO_ESC,
    /* [0x77] - 'w' */  NO_ESC,
    /* [0x78] - 'x' */  NO_ESC,
    /* [0x79] - 'y' */  NO_ESC,
    /* [0x7a] - 'z' */  NO_ESC,
    /* [0x7b] - '{' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x7c] - '|' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x7d] - '}' */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x7e] - '~' */  ESC_SCHEME | ESC_PROTNAME | ESC_HOST | ESC_HOSTNAME,
    /* [0x7f] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x80] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x81] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x82] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x83] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x84] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x85] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x86] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x87] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x88] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x89] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8a] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8b] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8c] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8d] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8e] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x8f] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x90] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x91] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x92] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x93] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x94] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x95] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x96] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x97] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x98] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x99] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9a] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9b] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9c] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9d] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9e] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0x9f] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xa9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xaa] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xab] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xac] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xad] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xae] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xaf] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xb9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xba] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xbb] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xbc] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xbd] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xbe] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xbf] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xc9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xca] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xcb] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xcc] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xcd] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xce] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xcf] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xd9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xda] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xdb] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xdc] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xdd] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xde] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xdf] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xe9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xea] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xeb] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xec] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xed] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xee] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xef] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf0] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf1] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf2] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf3] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf4] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf5] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf6] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf7] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf8] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xf9] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xfa] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xfb] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xfc] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xfd] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xfe] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT,
    /* [0xff] -     */  ESC_URI | ESC_SCHEME | ESC_PROTNAME | ESC_LOCATION | ESC_HOST | ESC_HOSTNAME | ESC_PATH | ESC_PATH_CONTENT | ESC_QUERY | ESC_QUERY_CONTENT | ESC_FRAGMENT
/*!!!!!!!! DO NOT ALTER THIS ARRAY DIRECTLY !!!!!!!!!*/
};


#endif /* DECLARE_ESCAPE_CHAR_ARRAY */

#endif  /* RTECOMM_PARSEURIESCAPERFC2396_HPP */
