#include "Oms/OMS_TimeStamp.hpp"
#include "SAPDBCommon/SAPDB_MemCopyMove.hpp"
#include <string.h>

//
// Implementation of OmsTimeStamp
//

OmsTimeStamp::OmsTimeStamp(const OmsTypeABAPTimeStamp& timeStamp)
{
  SAPDB_MemCopyNoCheck (&m_TimeStamp, &timeStamp, sizeof(timeStamp));
  ToDateTime();
}

/*----------------------------------------------------------------------*/

const OmsTypeABAPTimeStamp& OmsTimeStamp::omsGetTimeStamp() const
{
  return m_ABAPTimeStamp;
}

/*----------------------------------------------------------------------*/

void OmsTimeStamp::ToDateTime()
{
  int nSec   = m_TimeStamp.nSecond1 * 10 + m_TimeStamp.nSecond2;
  int nMin   = m_TimeStamp.nMinute1 * 10 + m_TimeStamp.nMinute2;
  int nHour  = m_TimeStamp.nHour1   * 10 + m_TimeStamp.nHour2;
  int nDay   = m_TimeStamp.nDay1    * 10 + m_TimeStamp.nDay2;
  int nMonth = m_TimeStamp.nMonth1  * 10 + m_TimeStamp.nMonth2;
  int nYear  = m_TimeStamp.nYear1 * 1000 + m_TimeStamp.nYear2 * 100 +
    m_TimeStamp.nYear3 * 10 + m_TimeStamp.nYear4;

  if (nYear < 1970)
  {
    nYear = 1970;
  }
  else if (nYear > 2099)
  {
    nYear = 2099;
  }
  m_DateTime = OMS_DateTime(nYear, nMonth, nDay, nHour, nMin, nSec);
}
/*----------------------------------------------------------------------*/

void OmsTimeStamp::ToTimeStamp()
{
  int n1, n2, n3, n4;

  div10(m_DateTime.seconds(),  n1, n2);
  m_TimeStamp.nSecond1 = n1;
  m_TimeStamp.nSecond2 = n2;

  div10(m_DateTime.minutes(),  n1, n2);
  m_TimeStamp.nMinute1 = n1;
  m_TimeStamp.nMinute2 = n2;

  div10(m_DateTime.hours(), n1, n2);
  m_TimeStamp.nHour1 = n1;
  m_TimeStamp.nHour2 = n2;

  div10(m_DateTime.day(), n1, n2);
  m_TimeStamp.nDay1 = n1;
  m_TimeStamp.nDay2 = n2;

  div10(m_DateTime.month(),  n1, n2);
  m_TimeStamp.nMonth1 = n1;
  m_TimeStamp.nMonth2 = n2;

  div1000(m_DateTime.year(), n1, n2, n3, n4);
  m_TimeStamp.nYear1 = n1;
  m_TimeStamp.nYear2 = n2;
  m_TimeStamp.nYear3 = n3;
  m_TimeStamp.nYear4 = n4;
}

/*----------------------------------------------------------------------*/
