/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.filters;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.filters.AbstractArtifactsFilter;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.markers.MarkerHandler;
import org.apache.maven.plugin.logging.Log;

public class MarkerFileFilter
extends AbstractArtifactsFilter
implements ArtifactItemFilter {
    boolean overWriteReleases;
    boolean overWriteSnapshots;
    boolean overWriteIfNewer;
    MarkerHandler handler;

    public MarkerFileFilter(boolean overWriteReleases, boolean overWriteSnapshots, boolean overWriteIfNewer, MarkerHandler handler) {
        this.overWriteReleases = overWriteReleases;
        this.overWriteSnapshots = overWriteSnapshots;
        this.overWriteIfNewer = overWriteIfNewer;
        this.handler = handler;
    }

    public Set filter(Set artifacts, Log log) throws MojoExecutionException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!this.okToProcess(new ArtifactItem(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean okToProcess(ArtifactItem item) throws MojoExecutionException {
        Artifact artifact = item.getArtifact();
        boolean overWrite = false;
        boolean result = false;
        if (artifact.isSnapshot() && this.overWriteSnapshots || !artifact.isSnapshot() && this.overWriteReleases) {
            overWrite = true;
        }
        this.handler.setArtifact(artifact);
        if (overWrite || !this.handler.isMarkerSet() || this.overWriteIfNewer && this.handler.isMarkerOlder(artifact)) {
            result = true;
        }
        return result;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean overWriteReleases) {
        this.overWriteReleases = overWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean overWriteSnapshots) {
        this.overWriteSnapshots = overWriteSnapshots;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }
}

