/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mplane.cpp,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */
#define _MATH3D_EXPORT
#include <math3d/mplane.h>
#include <cmath>


/*!
 *
 */
Math3d::MPlane::MPlane()
  : d_n(1,0,0), d_d(0) 
{
}

 
/*!
 *
 */
Math3d::MPlane::MPlane(const M3d& n, double d)
  : d_n(n), d_d(d) 
{
}


/*!
 *
 */
Math3d::MPlane::MPlane(const MPlane& p)
  : d_n(p.d_n), d_d(p.d_d) 
{
}


/*!
 *
 */
const Math3d::MPlane& 
Math3d::MPlane::operator=(const MPlane& p)
{
  d_n=p.d_n;
  d_d=p.d_d;
  return(*this);
}


/*!
 *
 */
void 
Math3d::MPlane::copy(const MPlane& p)
{
  d_n=p.d_n;
  d_d=p.d_d;
}


/*!
 *
 */
void 
Math3d::MPlane::setNormal(const M3d& n)
{
  d_n=n;
}


/*!
 *
 */
void 
Math3d::MPlane::setDist(double d)
{
  d_d=d;
}


/*!
 *
 */
const Math3d::M3d& 
Math3d::MPlane::getNormal() const
{
  return(d_n);
}


/*!
 *
 */
double 
Math3d::MPlane::getDist() const
{
  return(d_d);
}


/*!
 *
 */
bool 
Math3d::MPlane::operator==(const MPlane& p) const
{
  return(cmp(p));
}


/*!
 *
 */
bool 
Math3d::MPlane::operator!=(const MPlane& p) const
{
  return(!cmp(p));
}


/*!
 *
 */
bool 
Math3d::MPlane::cmp(const MPlane& p, double epsilon) const
{
  return(
    d_n.cmp(p.d_n) &&
    (fabs(d_d-p.d_d)<epsilon)
  );
}





