/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mlookat.cpp,v 1.4 2000/10/09 12:17:54 jeh Exp $
 */
#define _MATH3D_EXPORT
#include <math3d/mlookat.h>
#include <math3d/m4x4.h>
#include <cmath>


/*!
 *
 */
Math3d::MLookAt::MLookAt() 
{
  d_dist=1.0;
}


/*!
 *
 */
Math3d::MLookAt::MLookAt(const MLookAt& la) 
  : M3Frame(la)
{
  d_dist=la.d_dist;
}


/*!
 * Does nothing!
 */
Math3d::MLookAt::~MLookAt()
{
}


/*!
 *
 */
const Math3d::MLookAt&
Math3d::MLookAt::operator=(const MLookAt& la)
{
  d_pos=la.d_pos;
  d_dir=la.d_dir;
  d_up=la.d_up;
  d_right=la.d_right;
  d_dist=la.d_dist;
  return(*this);
}


/*!
 *
 */
const Math3d::MLookAt&
Math3d::MLookAt::operator=(const M3Frame& fr)
{
  d_pos=fr.getPos();
  d_dir=fr.getDir();
  d_up=fr.getUp();
  d_right=fr.getRight();
  return(*this);
}


/*!
 *
 */
void
Math3d::MLookAt::copy(const MLookAt& la)
{
  d_pos=la.d_pos;
  d_dir=la.d_dir;
  d_up=la.d_up;
  d_right=la.d_right;
  d_dist=la.d_dist;
}


/*!
 * Sets focal-point that the distance between eye-point and focal-point
 * is dist.
 *
 * \param dist New distance.
 */
void
Math3d::MLookAt::setDist(double dist) 
{
  d_dist=dist;
}


/*! 
 * Rotates around the up axis at the target position.
 *
 * \param angle Angle in radians.
 */
void 
Math3d::MLookAt::azimuth(double angle)
{
  ASSERT(FALSE);
  //FIXME: __IN_WORK__
}


/*! 
 * Rotates around the right axis at the target position.
 *
 * \param angle Angle in radians
 */
void 
Math3d::MLookAt::elevation(double angle)
{
  ASSERT(FALSE);
  //FIXME: __IN_WORK__
}


/*! 
 * Translates the eye-point along the direction axis
 *
 * \param dist Distance to translate.
 */
void 
Math3d::MLookAt::dolly(double dist)
{
  d_pos+=d_dir*dist;
}


/*!
 * \return Distance between eye-point and focal-point
 */
double
Math3d::MLookAt::getDist() const
{
  return(d_dist);
}


/*!
 * Returns the focal-point
 *
 * \return Focal-point (=pos+dist*dir)
 */
Math3d::M3d
Math3d::MLookAt::getTgt() const
{
  return(M3d( 
    d_pos[0]+d_dist*d_dir[0],
    d_pos[1]+d_dist*d_dir[1],
    d_pos[2]+d_dist*d_dir[2]
  ));
}


/*!
 *
 */
bool 
Math3d::MLookAt::operator==(const MLookAt& la) const
{
  return(cmp(la));
}


/*!
 *
 */
bool 
Math3d::MLookAt::operator!=(const MLookAt& la) const
{
  return(!cmp(la));
}


/*!
 *
 */
bool 
Math3d::MLookAt::cmp(const MLookAt& la, double epsilon) const
{
  return(
    d_pos.cmp(la.d_pos, epsilon) &&
    d_right.cmp(la.d_right, epsilon) &&
    d_dir.cmp(la.d_dir, epsilon) &&
    d_up.cmp(la.d_up, epsilon) &&
    (fabs(d_dist-la.d_dist)<epsilon)
  );  
}
