/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include "select_client.h"

client*
select_client_new(Wm *w)
{
   Window win;
   XSetWindowAttributes attr;
   int width,height;
   client *c;
   
   select_client_calc_dim(w,&width,&height);
   if (width == 0 || height ==0) return NULL;
   
   attr.override_redirect = True;
   attr.background_pixel = (w->theme->bg_col).pixel;
   attr.border_pixel = (w->theme->bg_col).pixel;
   attr.event_mask = ButtonPressMask|ExposureMask|EnterWindowMask;

   win = XCreateWindow(w->dpy, w->root,
		       0, main_client_title_height(w->main_client), width, height
		       , w->theme->win_border_width,
		       DefaultDepth(w->dpy, w->screen),
		       CopyFromParent,
		       DefaultVisual(w->dpy, w->screen),
		       CWOverrideRedirect|CWBackPixel|
		       CWBorderPixel|CWEventMask,
		       &attr);

   
   c = base_client_new(w, win);
   c->type = menu;
   c->frame = c->window;
   
   c->destroy      = &select_client_destroy;
   c->button_press = &select_client_button_press;
   c->redraw       = &select_client_redraw;

   w->flags ^= MENU_FLAG; /* turn on menu flag */
   //select_client_redraw(c, FALSE);

   XMapWindow(c->wm->dpy, c->frame); 
   return c;
}

void
select_client_calc_dim(Wm *w, int *width, int *height)
{
   int twidth = 0, theight = 0;
   int tmp;
   client *p;

   //twidth = XTextWidth(w->theme->font, w->main_client->name,
   //		       strlen(w->main_client->name))+4;
   
   START_CLIENT_LOOP(w,p);   
      if (p->type == mainwin && p->name && p != w->main_client && p->mapped)
      {
	 int space_avail = p->wm->dpy_width - 16;
#ifdef USE_XFT
	 XGlyphInfo       extents;
	 XftTextExtents8(w->dpy, w->theme->xftfont,
			 (unsigned char *) p->name,
			 wu_trim_title(p->wm, p->name, space_avail),
			 &extents);
	 tmp = extents.width + ENTRY_SPC;
	 theight += w->theme->xftfont->ascent
	    + w->theme->xftfont->descent + ENTRY_SPC;
#else
	 tmp = XTextWidth(w->theme->font, p->name, wu_trim_title(p->wm, p->name, space_avail))
	    + ENTRY_SPC;
         theight += w->theme->font->ascent
	    + w->theme->font->descent + ENTRY_SPC;
#endif
	 if (tmp > twidth) twidth = tmp;
      }
    END_CLIENT_LOOP(w,p);   
   *width = twidth; *height = theight;
}

void
select_client_button_press(Client *c, XButtonEvent *e)
{
   client *p;
   Theme *t = c->wm->theme;
   int y = 0;
#ifdef USE_XFT
    int font_height = t->xftfont->ascent + t->xftfont->descent + ENTRY_SPC;
#else
    int font_height = t->font->ascent + t->font->descent + ENTRY_SPC;
#endif
    
   for(p = c->prev; p != c ; p = p->prev)
      if (p->type == mainwin && p->name
	  && p != c->wm->main_client && p->mapped)
      {
	 if (e->y > y &&
	     e->y < (y+font_height))
	 {
	    c->wm->main_client->hide(c->wm->main_client);
	    p->show(p);
	    select_client_destroy(c);
	    return;
	 }
	 y += font_height;
      }
   select_client_destroy(c);
}

void
select_client_destroy(Client *c)
{
   c->wm->flags ^= MENU_FLAG;
   //XUnmapWindow(c->wm->dpy, c->frame);
   //XUnmapWindow(c->wm->dpy, c->window);
   base_client_destroy(c);
}

void
select_client_redraw(client *c, Bool use_cache)
{
   client *p;
   Theme *t = c->wm->theme;
   int space_avail = c->wm->dpy_width -16;
#ifdef USE_XFT
   int y = t->xftfont->ascent + t->xftfont->descent;
#else
   int y = t->font->ascent + t->font->descent;
#endif
   
   if (c->backing == (Pixmap)NULL)
      client_init_backing(c, c->width, c->height);
   
   theme_render_area(c->wm, c->backing, 0, 0, c->width, c->height );
   
   for(p = c->prev; p != c ; p = p->prev)
      if (p->type == mainwin && p->name
	  && p != c->wm->main_client && p->mapped)
      {
#ifdef USE_XFT
      XftDrawString8(c->xftdraw, &(t->xft_fg), t->xftfont,
		     ENTRY_SPC/2, y,
		     (unsigned char *) p->name,
		     wu_trim_title(c->wm, p->name, space_avail));
      y += t->xftfont->ascent + t->xftfont->descent + ENTRY_SPC;
#else
        XDrawString(c->wm->dpy, c->backing, t->text_gc,
            ENTRY_SPC/2, y,
            p->name, wu_trim_title(c->wm, p->name, space_avail));
	y += t->font->ascent + t->font->descent + ENTRY_SPC;
#endif
	dbg("showing entry %s", p->name);
	
      }

   XCopyArea(c->wm->dpy, c->backing, c->frame,
	     c->wm->theme->fg_gc, 0, 0, c->width,
	     c->height, 0, 0 );
}



