/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <syslog.h>
#include <errno.h>

#include "mserver.h"

extern int errno;

extern FILE *insock;
extern FILE *outsock;

extern int sfd;
extern int csfd;
extern pid_t parent_pid;

void mserver_halt(int sig)
{
	pid_t mypid = getpid();
	syslog(LOG_NOTICE, "Halting server");
	syslog(LOG_NOTICE, "Closing sockets");

	if (mypid != parent_pid)
	{	
		util_shutdown (csfd, 2);
	}
	
	if (mypid == parent_pid);
	{
		util_close(sfd);
	}

	syslog(LOG_NOTICE, "Server exiting");

	exit (0);
}

void mserver_halt_all()
{
	if (!auth_check("admin", AUTH_NONE))
	{
		syslog(LOG_WARNING, "Unauthorized user tried to halt server!");
	}
	else
	{
		fclose (insock);
		fclose (outsock);
	
		util_system_wait("killall -TERM mserver");

		exit(0);
	}
}
