/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>

#include "mserver.h"

extern int errno;
extern int cspeed;

bool cfile_write(const char *connection)
{
	time_t cur_time;

	util_time(&cur_time);

	shmem_set_cname(connection);
	shmem_set_ctime(cur_time);
	shmem_set_cspeed(cspeed);

	return true;
}

void cfile_getcname(char *cname)
{
	shmem_get_cname(cname);
}


int cfile_getcspeed(void)
{
	return shmem_get_cspeed();
}


int cfile_gettime(void)
{
	return (int) shmem_get_ctime();
}
